/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.stacktrace;

import ch.epfl.scala.debugadapter.Debuggee;
import ch.epfl.scala.debugadapter.Java8;
import ch.epfl.scala.debugadapter.Java9OrAbove;
import ch.epfl.scala.debugadapter.JavaRuntime;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.stacktrace.Scala3DecoderBridge;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Consumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.util.Try;
import scala.util.Try$;

public final class Scala3DecoderBridge$ {
    public static final Scala3DecoderBridge$ MODULE$ = new Scala3DecoderBridge$();

    public Object load(Debuggee debuggee, Class<?> decoderClass, Logger logger, boolean testMode) {
        Seq javaRuntimeJars = (Seq)Option$.MODULE$.option2Iterable(debuggee.javaRuntime()).toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            JavaRuntime javaRuntime = x0$1;
            if (javaRuntime instanceof Java8) {
                Java8 java8 = (Java8)javaRuntime;
                Seq<Path> classJars = java8.classJars();
                return classJars;
            }
            if (javaRuntime instanceof Java9OrAbove) {
                Java9OrAbove java9OrAbove = (Java9OrAbove)javaRuntime;
                return (Seq)java9OrAbove.classSystems().flatMap((Function1 & Serializable)javaFs -> CollectionConverters$.MODULE$.IteratorHasAsScala(Files.list(javaFs.fileSystem().getPath("/modules", new String[0])).iterator()).asScala().toSeq());
            }
            throw new MatchError((Object)javaRuntime);
        });
        Path[] debuggeeClasspath = (Path[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])debuggee.classPath().toArray(ClassTag$.MODULE$.apply(Path.class))), (IterableOnce)javaRuntimeJars, ClassTag$.MODULE$.apply(Path.class));
        Consumer<String> warnLogger = msg -> logger.warn((Function0<String>)(Function0 & Serializable)() -> msg);
        Constructor<?> ctr = decoderClass.getConstructor(Path[].class, Consumer.class, Boolean.TYPE);
        return ctr.newInstance(debuggeeClasspath, warnLogger, Predef$.MODULE$.boolean2Boolean(testMode));
    }

    public Try<Scala3DecoderBridge> tryLoad(Debuggee debuggee, ClassLoader classLoader, Logger logger, boolean testMode) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String className = "ch.epfl.scala.debugadapter.internal.stacktrace.Scala3DecoderBridge";
            Class<?> cls = classLoader.loadClass(className);
            Object bridge = MODULE$.load(debuggee, cls, logger, testMode);
            Method skipMethod = cls.getMethod("skipMethod", Object.class);
            Method formatMethod = cls.getMethod("formatMethod", Object.class);
            return new Scala3DecoderBridge(debuggee, cls, bridge, skipMethod, formatMethod, testMode, logger);
        });
    }

    private Scala3DecoderBridge$() {
    }
}

