/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.internal.NameTransformer;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class NameTransformer$ {
    public static final NameTransformer$ MODULE$ = new NameTransformer$();
    private static final int nops = 128;
    private static final int ncodes = 676;
    private static final String[] op2code = new String[MODULE$.nops()];
    private static final NameTransformer.OpCodes[] code2op = new NameTransformer.OpCodes[MODULE$.ncodes()];

    static {
        MODULE$.enterOp('~', "$tilde");
        MODULE$.enterOp('=', "$eq");
        MODULE$.enterOp('<', "$less");
        MODULE$.enterOp('>', "$greater");
        MODULE$.enterOp('!', "$bang");
        MODULE$.enterOp('#', "$hash");
        MODULE$.enterOp('%', "$percent");
        MODULE$.enterOp('^', "$up");
        MODULE$.enterOp('&', "$amp");
        MODULE$.enterOp('|', "$bar");
        MODULE$.enterOp('*', "$times");
        MODULE$.enterOp('/', "$div");
        MODULE$.enterOp('+', "$plus");
        MODULE$.enterOp('-', "$minus");
        MODULE$.enterOp(':', "$colon");
        MODULE$.enterOp('\\', "$bslash");
        MODULE$.enterOp('?', "$qmark");
        MODULE$.enterOp('@', "$at");
    }

    private int nops() {
        return nops;
    }

    private int ncodes() {
        return ncodes;
    }

    private String[] op2code() {
        return op2code;
    }

    private NameTransformer.OpCodes[] code2op() {
        return code2op;
    }

    private void enterOp(char op, String code) {
        this.op2code()[op] = code;
        int c = (code.charAt(1) - 97) * 26 + code.charAt(2) - 97;
        this.code2op()[c] = new NameTransformer.OpCodes(op, code, this.code2op()[c]);
    }

    public String encode(String name) {
        StringBuilder buf = null;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            Object object;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i);
            if (c < this.nops() && this.op2code()[c] != null) {
                BoxedUnit boxedUnit;
                if (buf == null) {
                    buf = new StringBuilder();
                    boxedUnit = buf.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 0, i));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = buf.append(this.op2code()[c]);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                BoxedUnit boxedUnit;
                if (buf == null) {
                    buf = new StringBuilder();
                    boxedUnit = buf.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 0, i));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = buf.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("$u%04X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                continue;
            }
            object = buf != null ? buf.append(c) : BoxedUnit.UNIT;
        }
        if (buf == null) {
            return name;
        }
        return buf.toString();
    }

    public String decode(String name) {
        StringBuilder buf = null;
        int len = name.length();
        int i = 0;
        while (i < len) {
            char ch1;
            NameTransformer.OpCodes ops = null;
            boolean unicode = false;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i);
            if (c == '$' && i + 2 < len && 'a' <= (ch1 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i + 1)) && ch1 <= 'z') {
                char ch2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i + 2);
                if ('a' <= ch2 && ch2 <= 'z') {
                    for (ops = this.code2op()[(ch1 - 97) * 26 + ch2 - 97]; ops != null && !name.startsWith(ops.code(), i); ops = ops.next()) {
                    }
                    if (ops != null) {
                        BoxedUnit boxedUnit;
                        if (buf == null) {
                            buf = new StringBuilder();
                            boxedUnit = buf.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 0, i));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        buf.append(ops.op());
                        i += ops.code().length();
                    }
                } else if (len - i >= 6 && ch1 == 'u' && (Character.isDigit(ch2) || 'A' <= ch2 && ch2 <= 'F')) {
                    String hex = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), i + 2, i + 6);
                    try {
                        BoxedUnit boxedUnit;
                        char str = (char)Integer.parseInt(hex, 16);
                        if (buf == null) {
                            buf = new StringBuilder();
                            boxedUnit = buf.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 0, i));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        buf.append(str);
                        i += 6;
                        unicode = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (ops != null || unicode) continue;
            Object object = buf != null ? buf.append(c) : BoxedUnit.UNIT;
            ++i;
        }
        if (buf == null) {
            return name;
        }
        return buf.toString();
    }

    public String scalaClassName(String fqcn) {
        String decodedName = this.decode((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fqcn), '.'))));
        int lastDollar = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(decodedName), "$").lastIndexOf(36);
        return StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(decodedName), lastDollar + 1);
    }

    private NameTransformer$() {
    }
}

