/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.javareflect;

import ch.epfl.scala.debugadapter.internal.binary.ClassType;
import ch.epfl.scala.debugadapter.internal.binary.Instruction;
import ch.epfl.scala.debugadapter.internal.binary.Parameter;
import ch.epfl.scala.debugadapter.internal.binary.SignedName;
import ch.epfl.scala.debugadapter.internal.binary.SourceLines;
import ch.epfl.scala.debugadapter.internal.binary.Symbol;
import ch.epfl.scala.debugadapter.internal.binary.Type;
import ch.epfl.scala.debugadapter.internal.javareflect.ExtraMethodInfo;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectLoader;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectParameter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public class JavaReflectMethod
implements Symbol,
ch.epfl.scala.debugadapter.internal.binary.Method {
    private final Method method;
    private final SignedName signedName;
    private final ExtraMethodInfo extraInfos;
    private final JavaReflectLoader loader;

    public JavaReflectMethod(Method method, SignedName signedName, ExtraMethodInfo extraInfos, JavaReflectLoader loader) {
        this.method = method;
        this.signedName = signedName;
        this.extraInfos = extraInfos;
        this.loader = loader;
    }

    @Override
    public SignedName signedName() {
        return this.signedName;
    }

    @Override
    public Option<Type> returnType() {
        return Option$.MODULE$.apply(this.method.getReturnType()).map((Function1 & Serializable)cls -> this.loader.loadClass((Class<?>)cls));
    }

    @Override
    public String returnTypeName() {
        return this.method.getReturnType().getName();
    }

    @Override
    public ClassType declaringClass() {
        return this.loader.loadClass(this.method.getDeclaringClass());
    }

    @Override
    public Seq<Parameter> allParameters() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.method.getParameters());
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> new JavaReflectParameter((java.lang.reflect.Parameter)_$1, this.loader), ClassTag$.MODULE$.apply(JavaReflectParameter.class)));
    }

    @Override
    public String name() {
        return this.method.getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    public String toString() {
        if (this.showSpan().isEmpty()) {
            return this.method.toString();
        }
        return new StringBuilder(1).append(this.method).append(" ").append(this.showSpan()).toString();
    }

    @Override
    public boolean isBridge() {
        return this.method.isBridge();
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public Option<SourceLines> sourceLines() {
        return this.extraInfos.sourceLines();
    }

    @Override
    public Seq<Instruction> instructions() {
        return this.extraInfos.instructions();
    }
}

