/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.stacktrace;

import ch.epfl.scala.debugadapter.internal.binary.Instruction;
import ch.epfl.scala.debugadapter.internal.binary.SourceLines;
import ch.epfl.scala.debugadapter.internal.binary.Symbol;
import ch.epfl.scala.debugadapter.internal.stacktrace.CommonNames$;
import ch.epfl.scala.debugadapter.internal.stacktrace.DecodedClass;
import ch.epfl.scala.debugadapter.internal.stacktrace.DecodedSymbol;
import ch.epfl.scala.debugadapter.internal.stacktrace.NameTransformer$;
import ch.epfl.scala.debugadapter.internal.stacktrace.ThrowOrWarn;
import ch.epfl.scala.debugadapter.internal.stacktrace.ThrowOrWarn$package$;
import ch.epfl.scala.debugadapter.internal.stacktrace.exceptions$package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;
import tastyquery.Contexts;
import tastyquery.Modifiers;
import tastyquery.Names;
import tastyquery.SourceFile;
import tastyquery.SourceLanguage;
import tastyquery.SourceLanguage$;
import tastyquery.SourcePosition;
import tastyquery.SourcePosition$;
import tastyquery.Symbols;
import tastyquery.Trees;
import tastyquery.Types;

public final class extensions$package$
implements Serializable {
    public static final extensions$package$ MODULE$ = new extensions$package$();

    private extensions$package$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(extensions$package$.class);
    }

    public boolean isTrait(Symbols.Symbol symbol) {
        return symbol.isClass() && symbol.asClass().isTrait();
    }

    public boolean isLocal(Symbols.Symbol symbol) {
        return symbol.owner().isTerm();
    }

    public SourcePosition pos(Symbols.Symbol symbol) {
        return (SourcePosition)symbol.tree().map((Function1 & Serializable)_$1 -> ((Trees.Tree)_$1).pos()).getOrElse(this::pos$$anonfun$2);
    }

    public boolean isInline(Symbols.Symbol symbol) {
        return symbol.isTerm() && symbol.asTerm().isInline();
    }

    public String nameStr(Symbols.Symbol symbol) {
        return symbol.name().toString();
    }

    public String showBasic(Symbols.Symbol symbol) {
        SourcePosition pos;
        Option option = symbol.tree().map((Function1 & Serializable)_$2 -> ((Trees.Tree)_$2).pos());
        String span = option instanceof Some && this.isFullyDefined(pos = (SourcePosition)((Some)option).value()) ? (pos.startLine() != pos.endLine() ? new StringBuilder(5).append("(").append(pos.startLine()).append(", ").append(pos.endLine()).append("))").toString() : new StringBuilder(2).append("(").append(pos.startLine()).append(")").toString()) : "";
        return new StringBuilder(1).append(symbol).append(" ").append(span).toString();
    }

    public boolean isAnonClass(Symbols.ClassSymbol symbol) {
        Names.ClassTypeName classTypeName = symbol.name();
        Names.SimpleTypeName simpleTypeName = CommonNames$.MODULE$.anonClass();
        return !(classTypeName != null ? !classTypeName.equals(simpleTypeName) : simpleTypeName != null);
    }

    public String sourceName(Symbols.ClassSymbol symbol) {
        Names.ClassTypeName classTypeName = symbol.name();
        if (classTypeName instanceof Names.ObjectClassTypeName) {
            Names.SimpleTypeName simpleTypeName;
            Names.ObjectClassTypeName objectClassTypeName = Names.ObjectClassTypeName$.MODULE$.unapply((Names.ObjectClassTypeName)classTypeName);
            Names.SimpleTypeName underlying = simpleTypeName = objectClassTypeName._1();
            return underlying.toString();
        }
        Names.ClassTypeName name = classTypeName;
        return name.toString();
    }

    public boolean isGetter(Symbols.TermSymbol symbol) {
        return !symbol.isMethod();
    }

    public boolean isModuleOrLazyVal(Symbols.TermSymbol symbol) {
        return this.isLazyVal(symbol) || symbol.isModuleVal();
    }

    public boolean isLazyVal(Symbols.TermSymbol symbol) {
        Modifiers.TermSymbolKind termSymbolKind = symbol.kind();
        Modifiers.TermSymbolKind termSymbolKind2 = Modifiers.TermSymbolKind$.LazyVal;
        return !(termSymbolKind != null ? !termSymbolKind.equals(termSymbolKind2) : termSymbolKind2 != null);
    }

    public boolean isVal(Symbols.TermSymbol symbol) {
        Modifiers.TermSymbolKind termSymbolKind = symbol.kind();
        Modifiers.TermSymbolKind termSymbolKind2 = Modifiers.TermSymbolKind$.Val;
        return !(termSymbolKind != null ? !termSymbolKind.equals(termSymbolKind2) : termSymbolKind2 != null);
    }

    public boolean isDef(Symbols.TermSymbol symbol) {
        Modifiers.TermSymbolKind termSymbolKind = symbol.kind();
        Modifiers.TermSymbolKind termSymbolKind2 = Modifiers.TermSymbolKind$.Def;
        return !(termSymbolKind != null ? !termSymbolKind.equals(termSymbolKind2) : termSymbolKind2 != null);
    }

    public boolean isVar(Symbols.TermSymbol symbol) {
        Modifiers.TermSymbolKind termSymbolKind = symbol.kind();
        Modifiers.TermSymbolKind termSymbolKind2 = Modifiers.TermSymbolKind$.Var;
        return !(termSymbolKind != null ? !termSymbolKind.equals(termSymbolKind2) : termSymbolKind2 != null);
    }

    public boolean isAnonFun(Symbols.TermSymbol symbol) {
        Names.UnsignedTermName unsignedTermName = symbol.name();
        Names.SimpleName simpleName = CommonNames$.MODULE$.anonFun();
        return !(unsignedTermName != null ? !unsignedTermName.equals(simpleName) : simpleName != null);
    }

    public String targetNameStr(Symbols.TermSymbol symbol, Contexts.Context x$2) {
        return symbol.targetName(x$2).toString();
    }

    public Symbols.TermSymbol overridingSymbolInLinearization(Symbols.TermSymbol symbol, Symbols.ClassSymbol siteClass, Contexts.Context x$3) {
        return (Symbols.TermSymbol)siteClass.linearization(x$3).iterator().flatMap((Function1 & Serializable)inClass -> symbol.matchingSymbol(inClass, siteClass, x$3)).next();
    }

    public boolean isOverridingSymbol(Symbols.TermSymbol symbol, DecodedClass siteClass2, Contexts.Context x$3) {
        return this.classSymbol(siteClass2).exists((Function1 & Serializable)siteClass -> this.isOverridingSymbol(symbol, (Symbols.ClassSymbol)siteClass, x$3));
    }

    public boolean isOverridingSymbol(Symbols.TermSymbol symbol, Symbols.ClassSymbol siteClass, Contexts.Context x$3) {
        Symbols.TermSymbol termSymbol = this.overridingSymbolInLinearization(symbol, siteClass, x$3);
        Symbols.TermSymbol termSymbol2 = symbol;
        return !(termSymbol != null ? !termSymbol.equals(termSymbol2) : termSymbol2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConstructor(Symbols.TermSymbol symbol) {
        if (!symbol.owner().isClass()) return false;
        if (!symbol.isMethod()) return false;
        Names.UnsignedTermName unsignedTermName = symbol.name();
        Names.SimpleName simpleName = Names.nme$.MODULE$.Constructor();
        if (unsignedTermName != null) {
            if (!unsignedTermName.equals(simpleName)) return false;
            return true;
        }
        if (simpleName == null) return true;
        return false;
    }

    public List<Symbols.TermSymbol> paramSymbols(Symbols.TermSymbol symbol) {
        return ((List)((List)symbol.tree().toList().collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Trees.DefTree x) {
                Trees.DefTree defTree = x;
                if (defTree instanceof Trees.DefDef) {
                    Trees.DefDef tree = (Trees.DefDef)defTree;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Trees.DefTree x, Function1 function1) {
                Trees.DefTree defTree = x;
                if (defTree instanceof Trees.DefDef) {
                    Trees.DefDef tree = (Trees.DefDef)defTree;
                    return tree.paramLists();
                }
                return function1.apply((Object)x);
            }
        }).flatten(Predef$.MODULE$.$conforms())).collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Left) {
                    List params = (List)((Left)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Left) {
                    List params = (List)((Left)either).value();
                    return params;
                }
                return function1.apply((Object)x);
            }
        }).flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)_$3 -> _$3.symbol());
    }

    public List<Symbols.LocalTypeParamSymbol> typeParamSymbols(Symbols.TermSymbol symbol) {
        return ((List)((List)symbol.tree().toList().collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Trees.DefTree x) {
                Trees.DefTree defTree = x;
                if (defTree instanceof Trees.DefDef) {
                    Trees.DefDef tree = (Trees.DefDef)defTree;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Trees.DefTree x, Function1 function1) {
                Trees.DefTree defTree = x;
                if (defTree instanceof Trees.DefDef) {
                    Trees.DefDef tree = (Trees.DefDef)defTree;
                    return tree.paramLists();
                }
                return function1.apply((Object)x);
            }
        }).flatten(Predef$.MODULE$.$conforms())).collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Right) {
                    List typeParams = (List)((Right)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Right) {
                    List typeParams = (List)((Right)either).value();
                    return typeParams;
                }
                return function1.apply((Object)x);
            }
        }).flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)_$4 -> _$4.symbol()).collect((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Symbols.TypeParamSymbol x) {
                Symbols.TypeParamSymbol typeParamSymbol = x;
                if (typeParamSymbol instanceof Symbols.LocalTypeParamSymbol) {
                    Symbols.LocalTypeParamSymbol sym = (Symbols.LocalTypeParamSymbol)typeParamSymbol;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Symbols.TypeParamSymbol x, Function1 function1) {
                Symbols.TypeParamSymbol typeParamSymbol = x;
                if (typeParamSymbol instanceof Symbols.LocalTypeParamSymbol) {
                    Symbols.LocalTypeParamSymbol sym = (Symbols.LocalTypeParamSymbol)typeParamSymbol;
                    return sym;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public <A, S extends IterableOnce<Object>> Option<A> singleOpt(IterableOnce<A> xs) {
        IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(xs);
        return Option$.MODULE$.when(IterableOnceExtensionMethods$.MODULE$.size$extension(iterableOnce) == 1, () -> this.singleOpt$$anonfun$1(xs));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public Object singleOrElse(IterableOnce xs, Function0 x) {
        IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(xs);
        if (IterableOnceExtensionMethods$.MODULE$.size$extension(iterableOnce) == 1) {
            return xs.iterator().next();
        }
        return x.apply();
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public IterableOnce orIfEmpty(IterableOnce xs, Function0 ys) {
        IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(xs);
        if (IterableOnceExtensionMethods$.MODULE$.nonEmpty$extension(iterableOnce)) {
            return xs;
        }
        return (IterableOnce)ys.apply();
    }

    public <T extends DecodedSymbol> T singleOrThrow(Seq<T> xs, Symbol symbol) {
        return (T)((DecodedSymbol)this.singleOptOrThrow(xs, symbol).getOrElse(() -> this.singleOrThrow$$anonfun$1(symbol)));
    }

    public <T extends DecodedSymbol> Option<T> singleOptOrThrow(Seq<T> xs, Symbol symbol) {
        if (xs.size() > 1) {
            throw exceptions$package$.MODULE$.ambiguous(symbol, xs);
        }
        return xs.headOption();
    }

    public boolean isPackageObject(Names.TermName name) {
        String nameStr;
        String string = nameStr = name.toString();
        String string2 = "package";
        return !(string == null ? string2 != null : !string.equals(string2)) || nameStr.endsWith("$package");
    }

    public boolean isPackageObjectClass(Names.ClassTypeName name) {
        Names.ClassTypeName classTypeName = name;
        if (classTypeName instanceof Names.SimpleTypeName) {
            Names.SimpleTypeName simpleTypeName = Names.SimpleTypeName$.MODULE$.unapply((Names.SimpleTypeName)classTypeName);
            String string = simpleTypeName._1();
            return false;
        }
        if (classTypeName instanceof Names.ObjectClassTypeName) {
            Names.SimpleTypeName simpleTypeName;
            Names.ObjectClassTypeName objectClassTypeName = Names.ObjectClassTypeName$.MODULE$.unapply((Names.ObjectClassTypeName)classTypeName);
            Names.SimpleTypeName underlying = simpleTypeName = objectClassTypeName._1();
            return this.isPackageObject((Names.TermName)underlying.toTermName());
        }
        throw new MatchError((Object)classTypeName);
    }

    public List<Types.Type> allParamTypes(Types.TermType tpe) {
        while (true) {
            Types.TermType termType;
            if ((termType = tpe) instanceof Types.MethodType) {
                Types.MethodType t = (Types.MethodType)termType;
                return (List)t.paramTypes().$plus$plus(this.allParamTypes((Types.TermType)t.resultType()));
            }
            if (!(termType instanceof Types.PolyType)) break;
            Types.PolyType t = (Types.PolyType)termType;
            tpe = t.resultType();
        }
        return package$.MODULE$.Nil();
    }

    public List<Names.UnsignedTermName> allParamNames(Types.TermType tpe) {
        while (true) {
            Types.TermType termType;
            if ((termType = tpe) instanceof Types.MethodType) {
                Types.MethodType t = (Types.MethodType)termType;
                return (List)t.paramNames().$plus$plus(this.allParamNames((Types.TermType)t.resultType()));
            }
            if (!(termType instanceof Types.PolyType)) break;
            Types.PolyType t = (Types.PolyType)termType;
            tpe = t.resultType();
        }
        return package$.MODULE$.Nil();
    }

    public Types.Type returnType(Types.TermType tpe) {
        Types.TermType termType;
        while ((termType = tpe) instanceof Types.MethodType || termType instanceof Types.PolyType) {
            Types.LambdaType t = (Types.LambdaType)termType;
            tpe = t.resultType();
        }
        if (termType instanceof Types.Type) {
            Types.Type t = (Types.Type)termType;
            return t;
        }
        if (termType instanceof Types.PackageRef) {
            Types.PackageRef t = (Types.PackageRef)termType;
            throw exceptions$package$.MODULE$.unexpected("return type on package ref");
        }
        throw new MatchError((Object)termType);
    }

    public Option<Types.Type> safeDealias(Types.Type tpe, Contexts.Context x$2, ThrowOrWarn x$3) {
        return ThrowOrWarn$package$.MODULE$.tryOrNone(() -> this.safeDealias$$anonfun$1(tpe, x$2), x$3);
    }

    public boolean isOperatorLike(Types.Type tpe) {
        Types.Type type = tpe;
        if (type instanceof Types.TypeRef) {
            Types.TypeRef ref = (Types.TypeRef)type;
            String operatorChars = "\\+\\-\\*\\/\\%\\&\\|\\^\\<\\>\\=\\!\\~\\#\\:\\@\\?";
            Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(3).append("[^").append(operatorChars).append("]").toString()));
            return !regex.findFirstIn((CharSequence)ref.name().toString()).isDefined();
        }
        return false;
    }

    public Option<Types.ErasedTypeRef> erasedAsReturnType(Types.Type tpe, Contexts.Context x$2, ThrowOrWarn x$3) {
        return this.erased(tpe, true, x$2, x$3);
    }

    public Option<Types.ErasedTypeRef> erasedAsArgType(Types.Type tpe, boolean asJavaVarargs, Contexts.Context x$3, ThrowOrWarn x$4) {
        Types.Type type = tpe;
        if (type instanceof Types.RepeatedType) {
            Types.RepeatedType tpe2 = (Types.RepeatedType)type;
            if (asJavaVarargs) {
                return this.erased((Types.Type)x$3.defn().ArrayTypeOf((Types.TypeOrWildcard)tpe2.elemType()), false, x$3, x$4);
            }
        }
        return this.erased(tpe, false, x$3, x$4);
    }

    public boolean erasedAsArgType$default$2(Types.Type tpe) {
        return false;
    }

    public Option<Types.ErasedTypeRef> erased(Types.Type tpe, boolean isReturnType, Contexts.Context x$3, ThrowOrWarn x$4) {
        return ThrowOrWarn$package$.MODULE$.tryOrNone(() -> this.erased$$anonfun$1(tpe, isReturnType, x$3), x$4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNumberedTypeRefInScalaPackage(Types.TermType tpe, String namePrefix) {
        while (true) {
            Types.TermType termType;
            if ((termType = tpe) instanceof Types.TypeRef) {
                String string;
                Types.TypeRef ref = (Types.TypeRef)termType;
                if (!this.isScalaPackage(ref.prefix())) return false;
                Names.TypeName typeName = ref.name();
                if (!(typeName instanceof Names.SimpleTypeName)) {
                    if (typeName instanceof Names.ObjectClassTypeName) return false;
                    if (!(typeName instanceof Names.UniqueTypeName)) throw new MatchError((Object)typeName);
                    return false;
                }
                Names.SimpleTypeName simpleTypeName = Names.SimpleTypeName$.MODULE$.unapply((Names.SimpleTypeName)typeName);
                String nameStr = string = simpleTypeName._1();
                boolean bl = nameStr.startsWith(namePrefix);
                if (!bl) return false;
                return true;
            }
            if (!(termType instanceof Types.AppliedType)) return false;
            Types.AppliedType tpe2 = (Types.AppliedType)termType;
            tpe = tpe2.tycon();
        }
    }

    public boolean isTuple(Types.TermType tpe) {
        return this.isNumberedTypeRefInScalaPackage(tpe, "Tuple");
    }

    public boolean isFunction(Types.TermType tpe) {
        return this.isNumberedTypeRefInScalaPackage(tpe, "Function");
    }

    public boolean isContextFunction(Types.TermType tpe) {
        return this.isNumberedTypeRefInScalaPackage(tpe, "ContextFunction");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScalaPredef(Types.TermRef ref) {
        if (!this.isScalaPackage(ref.prefix())) return false;
        Names.TermName termName = ref.name();
        Names.SimpleName simpleName = CommonNames$.MODULE$.Predef();
        if (termName != null) {
            if (!termName.equals(simpleName)) return false;
            return true;
        }
        if (simpleName == null) return true;
        return false;
    }

    public boolean isScalaPackage(Types.Prefix prefix) {
        Types.Prefix prefix2 = prefix;
        if (prefix2 instanceof Types.PackageRef) {
            Types.PackageRef p = (Types.PackageRef)prefix2;
            Names.SimpleName simpleName = p.symbol().name();
            Names.SimpleName simpleName2 = Names.nme$.MODULE$.scalaPackageName();
            return !(simpleName != null ? !simpleName.equals(simpleName2) : simpleName2 != null) && p.symbol().owner().isRootPackage();
        }
        return false;
    }

    public boolean matchLines(Trees.Tree tree, SourceLines sourceLines, Contexts.Context x$3) {
        Trees.Tree tree2 = tree;
        if (tree2 instanceof Trees.Lambda) {
            Trees.Lambda lambda = (Trees.Lambda)tree2;
            return this.matchLines(this.pos(lambda.meth().symbol(x$3)), sourceLines);
        }
        Trees.Tree tree3 = tree2;
        return this.matchLines(tree3.pos(), sourceLines);
    }

    public Seq<Trees.TermTree> allArgsFlatten(Trees.Apply tree) {
        return (Seq)this.rec$1((Trees.Tree)tree.fun()).$plus$plus((IterableOnce)tree.args());
    }

    public Option<Types.MethodType> safeMethodType(Trees.Apply tree, Contexts.Context x$2, ThrowOrWarn x$3) {
        return ThrowOrWarn$package$.MODULE$.tryOrNone(() -> this.safeMethodType$$anonfun$1(tree, x$2), x$3);
    }

    public Option<Symbols.TermSymbol> safeFunSymbol(Trees.Apply tree, Contexts.Context x$2, ThrowOrWarn x$3) {
        return this.rec$2(x$2, x$3, (Trees.Tree)tree);
    }

    public Option<Symbols.Symbol> safeSymbol(Trees.TermReferenceTree tree, Contexts.Context x$2, ThrowOrWarn x$3) {
        return ThrowOrWarn$package$.MODULE$.tryOrNone(() -> this.safeSymbol$$anonfun$1(tree, x$2), x$3);
    }

    public Option<Types.TermType> safeTpe(Trees.TermTree tree, Contexts.Context x$2, ThrowOrWarn x$3) {
        return ThrowOrWarn$package$.MODULE$.tryOrNone(() -> this.safeTpe$$anonfun$1(tree, x$2), x$3);
    }

    public boolean isFullyDefined(SourcePosition pos) {
        return !pos.isUnknown() && pos.hasLineColumnInformation();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enclose(SourcePosition pos, SourcePosition other) {
        if (!this.isFullyDefined(pos)) return false;
        if (!this.isFullyDefined(other)) return false;
        SourceFile sourceFile = pos.sourceFile();
        SourceFile sourceFile2 = other.sourceFile();
        if (sourceFile == null) {
            if (sourceFile2 != null) {
                return false;
            }
        } else if (!sourceFile.equals(sourceFile2)) return false;
        if (pos.startOffset() <= other.startOffset()) {
            if (pos.endOffset() > other.endOffset()) return true;
        }
        if (pos.startOffset() >= other.startOffset()) return false;
        if (pos.endOffset() < other.endOffset()) return false;
        return true;
    }

    public boolean containsLine(SourcePosition pos, int line) {
        return this.isFullyDefined(pos) && pos.startLine() <= line && pos.endLine() >= line;
    }

    public boolean matchLines(SourcePosition pos, SourceLines sourceLines) {
        return !this.isFullyDefined(pos) || !pos.sourceFile().name().endsWith(sourceLines.sourceName()) || sourceLines.tastySpan().forall((Function1)(JFunction1.mcZI.sp & Serializable)line -> pos.startLine() <= line && pos.endLine() >= line);
    }

    public String showBasic(SourcePosition pos) {
        SourcePosition sourcePosition = pos;
        SourcePosition pos2 = sourcePosition;
        if (this.isFullyDefined(pos2)) {
            if (pos2.startLine() != pos2.endLine()) {
                return new StringBuilder(5).append("(").append(pos2.startLine()).append(", ").append(pos2.endLine()).append("))").toString();
            }
            return new StringBuilder(2).append("(").append(pos2.startLine()).append(")").toString();
        }
        return "";
    }

    public Option<Symbols.ClassSymbol> classSymbol(DecodedClass self) {
        while (true) {
            DecodedClass decodedClass;
            if ((decodedClass = self) instanceof DecodedClass.ClassDef) {
                DecodedClass.ClassDef self2 = (DecodedClass.ClassDef)decodedClass;
                return Some$.MODULE$.apply((Object)self2.symbol());
            }
            if (!(decodedClass instanceof DecodedClass.InlinedClass)) break;
            DecodedClass.InlinedClass self3 = (DecodedClass.InlinedClass)decodedClass;
            self = self3.underlying();
        }
        return None$.MODULE$;
    }

    public boolean isJava(DecodedClass self) {
        return this.classSymbol(self).exists((Function1 & Serializable)_$5 -> {
            SourceLanguage sourceLanguage = _$5.sourceLanguage();
            SourceLanguage sourceLanguage2 = SourceLanguage$.Java;
            return !(sourceLanguage != null ? !sourceLanguage.equals(sourceLanguage2) : sourceLanguage2 != null);
        });
    }

    public boolean isTrait(DecodedClass self) {
        return this.classSymbol(self).exists((Function1 & Serializable)_$6 -> _$6.isTrait());
    }

    public boolean isModuleClass(DecodedClass self) {
        return this.classSymbol(self).exists((Function1 & Serializable)_$7 -> _$7.isModuleClass());
    }

    public Seq<Symbols.Symbol> declarations(DecodedClass self, Contexts.Context x$2) {
        return (Seq)Option$.MODULE$.option2Iterable(this.classSymbol(self)).toSeq().flatMap((Function1 & Serializable)_$8 -> _$8.declarations(x$2));
    }

    public Seq<Symbols.ClassSymbol> linearization(DecodedClass self, Contexts.Context x$2) {
        return (Seq)Option$.MODULE$.option2Iterable(this.classSymbol(self)).toSeq().flatMap((Function1 & Serializable)_$9 -> _$9.linearization(x$2));
    }

    public Option<Types.ThisType> thisType(DecodedClass self, Contexts.Context x$2) {
        return this.classSymbol(self).map((Function1 & Serializable)_$10 -> _$10.thisType());
    }

    public Option<DecodedClass> companionClass(DecodedClass self, Contexts.Context x$2) {
        return this.companionClassSymbol(self, x$2).map((Function1 & Serializable)_$11 -> new DecodedClass.ClassDef((Symbols.ClassSymbol)_$11));
    }

    public Option<Symbols.ClassSymbol> companionClassSymbol(DecodedClass self, Contexts.Context x$2) {
        while (true) {
            DecodedClass decodedClass;
            if ((decodedClass = self) instanceof DecodedClass.ClassDef) {
                DecodedClass.ClassDef self2 = (DecodedClass.ClassDef)decodedClass;
                return self2.symbol().companionClass(x$2);
            }
            if (decodedClass instanceof DecodedClass.SyntheticCompanionClass) {
                DecodedClass.SyntheticCompanionClass self3 = (DecodedClass.SyntheticCompanionClass)decodedClass;
                return Some$.MODULE$.apply((Object)self3.companionSymbol());
            }
            if (!(decodedClass instanceof DecodedClass.InlinedClass)) break;
            DecodedClass.InlinedClass self4 = (DecodedClass.InlinedClass)decodedClass;
            self = self4.underlying();
        }
        return None$.MODULE$;
    }

    public String name(Object self) {
        Object object = self;
        if (object instanceof Symbol) {
            Symbol self2 = (Symbol)object;
            return self2.name();
        }
        if (object instanceof Instruction.Field) {
            Instruction.Field self3 = (Instruction.Field)object;
            return self3.name();
        }
        if (object instanceof Instruction.Method) {
            Instruction.Method self4 = (Instruction.Method)object;
            return self4.name();
        }
        throw new MatchError(object);
    }

    public boolean isExpanded(Object self) {
        return this.name(self).matches(".+\\$\\$(_\\$)*(.+)");
    }

    public Seq<String> unexpandedDecodedNames(Object self) {
        Regex expanded = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+\\$\\$(_\\$)*(.+)"));
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.name(self), NameTransformer$.MODULE$.decode(this.unexpand$1(expanded, this.name(self))), this.unexpand$1(expanded, this.decodedName(self))})).distinct();
    }

    public String decodedName(Object self) {
        return NameTransformer$.MODULE$.decode(this.name(self));
    }

    public boolean isPut(Instruction.Field field) {
        return field.opcode() == 181 || field.opcode() == 179;
    }

    private final SourcePosition pos$$anonfun$2() {
        return SourcePosition$.MODULE$.NoPosition();
    }

    private final Object singleOpt$$anonfun$1(IterableOnce xs$1) {
        return xs$1.iterator().next();
    }

    private final DecodedSymbol singleOrThrow$$anonfun$1(Symbol symbol$3) {
        throw exceptions$package$.MODULE$.notFound(symbol$3);
    }

    private final Types.Type safeDealias$$anonfun$1(Types.Type tpe$1, Contexts.Context x$2$1) {
        return tpe$1.dealias(x$2$1);
    }

    private final Types.ErasedTypeRef erased$$anonfun$1(Types.Type tpe$2, boolean isReturnType$1, Contexts.Context x$3$3) {
        return Types.ErasedTypeRef$.MODULE$.erase(tpe$2, SourceLanguage$.Scala3, isReturnType$1, x$3$3);
    }

    private final Seq rec$1(Trees.Tree fun) {
        Trees.Tree tree;
        while ((tree = fun) instanceof Trees.TypeApply) {
            Trees.TypeApply typeApply = Trees.TypeApply$.MODULE$.unapply((Trees.TypeApply)tree);
            Trees.TermTree termTree = typeApply._1();
            List list = typeApply._2();
            Trees.TermTree fun2 = termTree;
            fun = fun2;
        }
        if (tree instanceof Trees.Apply) {
            Trees.Apply apply = Trees.Apply$.MODULE$.unapply((Trees.Apply)tree);
            Trees.TermTree termTree = apply._1();
            List list = apply._2();
            Trees.TermTree fun3 = termTree;
            List args = list;
            return (Seq)this.rec$1((Trees.Tree)fun3).$plus$plus((IterableOnce)args);
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private final Types.MethodType safeMethodType$$anonfun$1(Trees.Apply tree$1, Contexts.Context x$2$2) {
        return tree$1.methodType(x$2$2);
    }

    private final Option rec$2(Contexts.Context x$2$3, ThrowOrWarn x$3$4, Trees.Tree tree) {
        Trees.Tree tree2;
        while (true) {
            if ((tree2 = tree) instanceof Trees.Apply) {
                Trees.Apply tree3 = (Trees.Apply)tree2;
                tree = tree3.fun();
                continue;
            }
            if (!(tree2 instanceof Trees.TypeApply)) break;
            Trees.TypeApply tree4 = (Trees.TypeApply)tree2;
            tree = tree4.fun();
        }
        if (tree2 instanceof Trees.TermReferenceTree) {
            Trees.TermReferenceTree tree5 = (Trees.TermReferenceTree)tree2;
            return this.safeSymbol(tree5, x$2$3, x$3$4).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Symbols.Symbol x) {
                    Symbols.Symbol symbol = x;
                    if (symbol instanceof Symbols.TermSymbol) {
                        Symbols.TermSymbol sym = (Symbols.TermSymbol)symbol;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Symbols.Symbol x, Function1 function1) {
                    Symbols.Symbol symbol = x;
                    if (symbol instanceof Symbols.TermSymbol) {
                        Symbols.TermSymbol sym = (Symbols.TermSymbol)symbol;
                        return sym;
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        return None$.MODULE$;
    }

    private final Symbols.Symbol safeSymbol$$anonfun$1(Trees.TermReferenceTree tree$2, Contexts.Context x$2$4) {
        return tree$2.symbol(x$2$4);
    }

    private final Types.TermType safeTpe$$anonfun$1(Trees.TermTree tree$3, Contexts.Context x$2$5) {
        return tree$3.tpe(x$2$5);
    }

    private final String unexpand$1(Regex expanded$1, String name) {
        List list;
        Option option;
        String string = name;
        if (string != null && !(option = expanded$1.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
            String string2;
            String string3 = (String)list.apply(0);
            String name2 = string2 = (String)list.apply(1);
            return name2;
        }
        return name;
    }
}

