/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.jdi;

import ch.epfl.scala.debugadapter.internal.binary.Instruction;
import ch.epfl.scala.debugadapter.internal.binary.Instruction$Field$;
import ch.epfl.scala.debugadapter.internal.binary.Instruction$Method$;
import ch.epfl.scala.debugadapter.internal.jdi.ByteReader;
import ch.epfl.scala.debugadapter.internal.jdi.ConstantPool$;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxesRunTime;

public class ConstantPool {
    private final IndexedSeq<Object> offsets;
    private final ByteReader reader;

    public static byte CLASS_TAG() {
        return ConstantPool$.MODULE$.CLASS_TAG();
    }

    public static byte DOUBLE_TAG() {
        return ConstantPool$.MODULE$.DOUBLE_TAG();
    }

    public static byte DYNAMIC_TAG() {
        return ConstantPool$.MODULE$.DYNAMIC_TAG();
    }

    public static byte FIELDREF_TAG() {
        return ConstantPool$.MODULE$.FIELDREF_TAG();
    }

    public static byte FLOAT_TAG() {
        return ConstantPool$.MODULE$.FLOAT_TAG();
    }

    public static byte INTEGER_TAG() {
        return ConstantPool$.MODULE$.INTEGER_TAG();
    }

    public static byte INTERFACE_METHODREF_TAG() {
        return ConstantPool$.MODULE$.INTERFACE_METHODREF_TAG();
    }

    public static byte INVOKE_DYNAMIC_TAG() {
        return ConstantPool$.MODULE$.INVOKE_DYNAMIC_TAG();
    }

    public static byte LONG_TAG() {
        return ConstantPool$.MODULE$.LONG_TAG();
    }

    public static byte METHODREF_TAG() {
        return ConstantPool$.MODULE$.METHODREF_TAG();
    }

    public static byte METHOD_HANDLE_TAG() {
        return ConstantPool$.MODULE$.METHOD_HANDLE_TAG();
    }

    public static byte METHOD_TYPE_TAG() {
        return ConstantPool$.MODULE$.METHOD_TYPE_TAG();
    }

    public static byte MODULE_TAG() {
        return ConstantPool$.MODULE$.MODULE_TAG();
    }

    public static byte NAME_AND_TYPE_TAG() {
        return ConstantPool$.MODULE$.NAME_AND_TYPE_TAG();
    }

    public static byte PACKAGE_TAG() {
        return ConstantPool$.MODULE$.PACKAGE_TAG();
    }

    public static byte STRING_TAG() {
        return ConstantPool$.MODULE$.STRING_TAG();
    }

    public static byte UTF8_TAG() {
        return ConstantPool$.MODULE$.UTF8_TAG();
    }

    public static ConstantPool apply(byte[] byArray) {
        return ConstantPool$.MODULE$.apply(byArray);
    }

    public ConstantPool(IndexedSeq<Object> offsets, ByteReader reader) {
        this.offsets = offsets;
        this.reader = reader;
    }

    public String readUtf8(int index) {
        int offset = BoxesRunTime.unboxToInt((Object)this.offsets.apply(index - 1));
        int size = this.reader.unsignedShort(offset);
        return this.reader.utf8(offset + 2, size);
    }

    public String readClass(int index) {
        int offset = BoxesRunTime.unboxToInt((Object)this.offsets.apply(index - 1));
        return this.readUtf8(this.reader.unsignedShort(offset)).replace('/', '.');
    }

    public Tuple2<String, String> readNameAndType(int index) {
        int offset = BoxesRunTime.unboxToInt((Object)this.offsets.apply(index - 1));
        return Tuple2$.MODULE$.apply((Object)this.readUtf8(this.reader.unsignedShort(offset)), (Object)this.readUtf8(this.reader.unsignedShort(offset + 2)));
    }

    public Instruction.Field readField(int opcode, int index) {
        int offset = BoxesRunTime.unboxToInt((Object)this.offsets.apply(index - 1));
        String owner = this.readClass(this.reader.unsignedShort(offset));
        Tuple2<String, String> tuple2 = this.readNameAndType(this.reader.unsignedShort(offset + 2));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = (String)tuple2._1();
        String descriptor = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)name, (Object)descriptor);
        String name2 = (String)tuple22._1();
        String descriptor2 = (String)tuple22._2();
        return Instruction$Field$.MODULE$.apply(opcode, owner, name2, descriptor2);
    }

    public Instruction.Method readMethod(int opcode, int index) {
        int offset = BoxesRunTime.unboxToInt((Object)this.offsets.apply(index - 1));
        String owner = this.readClass(this.reader.unsignedShort(offset));
        Tuple2<String, String> tuple2 = this.readNameAndType(this.reader.unsignedShort(offset + 2));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = (String)tuple2._1();
        String descriptor = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)name, (Object)descriptor);
        String name2 = (String)tuple22._1();
        String descriptor2 = (String)tuple22._2();
        boolean isInterface = this.reader.byte(offset - 1) == ConstantPool$.MODULE$.INTERFACE_METHODREF_TAG();
        return Instruction$Method$.MODULE$.apply(opcode, owner, name2, descriptor2, isInterface);
    }
}

