/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.javareflect;

import ch.epfl.scala.debugadapter.internal.binary.ClassType;
import ch.epfl.scala.debugadapter.internal.binary.Field;
import ch.epfl.scala.debugadapter.internal.binary.SignedName;
import ch.epfl.scala.debugadapter.internal.binary.SignedName$;
import ch.epfl.scala.debugadapter.internal.binary.SourceLines;
import ch.epfl.scala.debugadapter.internal.binary.Symbol;
import ch.epfl.scala.debugadapter.internal.javareflect.ExtraClassInfo;
import ch.epfl.scala.debugadapter.internal.javareflect.ExtraMethodInfo;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectConstructor;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectField;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectLoader;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectMethod;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectUtils$;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public class JavaReflectClass
implements Symbol,
ClassType {
    private final Class<?> cls;
    private final ExtraClassInfo extraInfo;
    private final JavaReflectLoader classLoader;

    public JavaReflectClass(Class<?> cls, ExtraClassInfo extraInfo, JavaReflectLoader classLoader) {
        this.cls = cls;
        this.extraInfo = extraInfo;
        this.classLoader = classLoader;
    }

    @Override
    public JavaReflectLoader classLoader() {
        return this.classLoader;
    }

    @Override
    public String name() {
        return this.cls.getTypeName();
    }

    @Override
    public Option<ClassType> superclass() {
        return Option$.MODULE$.apply(this.cls.getSuperclass()).map((Function1 & Serializable)cls -> this.classLoader().loadClass((Class<?>)cls));
    }

    @Override
    public Seq<ClassType> interfaces() {
        return Predef$.MODULE$.wrapRefArray((Object[])this.cls.getInterfaces()).toList().map((Function1 & Serializable)cls -> this.classLoader().loadClass((Class<?>)cls));
    }

    @Override
    public boolean isInterface() {
        return this.cls.isInterface();
    }

    @Override
    public Option<SourceLines> sourceLines() {
        return this.extraInfo.sourceLines();
    }

    @Override
    public Option<ch.epfl.scala.debugadapter.internal.binary.Method> declaredMethod(String name, String sig) {
        return this.declaredMethods().find((Function1 & Serializable)m -> {
            SignedName signedName = m.signedName();
            SignedName signedName2 = SignedName$.MODULE$.apply(name, sig);
            return !(signedName != null ? !((Object)signedName).equals(signedName2) : signedName2 != null);
        });
    }

    @Override
    public Option<ch.epfl.scala.debugadapter.internal.binary.Method> method(String name, String sig) {
        return this.declaredMethod(name, sig).orElse(() -> this.method$$anonfun$1(name, sig));
    }

    @Override
    public Option<Field> declaredField(String name) {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)new JavaReflectField(this.cls.getDeclaredField(name), this.classLoader()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String toString() {
        if (this.showSpan().isEmpty()) {
            return this.cls.toString();
        }
        return new StringBuilder(1).append(this.cls).append(" ").append(this.showSpan()).toString();
    }

    @Override
    public Seq<ch.epfl.scala.debugadapter.internal.binary.Method> declaredMethods() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.cls.getDeclaredMethods());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)m -> {
            SignedName sig = JavaReflectUtils$.MODULE$.signature((Method)m);
            ExtraMethodInfo methodInfo = this.extraInfo.getMethodInfo(sig);
            return new JavaReflectMethod((Method)m, sig, methodInfo, this.classLoader());
        }, ClassTag$.MODULE$.apply(JavaReflectMethod.class)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])this.cls.getDeclaredConstructors());
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.$plus$plus$extension(object2, ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)c -> {
            SignedName sig = JavaReflectUtils$.MODULE$.signature((Constructor<?>)c);
            ExtraMethodInfo methodInfo = this.extraInfo.getMethodInfo(sig);
            return new JavaReflectConstructor((Constructor<?>)c, sig, methodInfo, this.classLoader());
        }, ClassTag$.MODULE$.apply(JavaReflectConstructor.class)), ClassTag$.MODULE$.apply(ch.epfl.scala.debugadapter.internal.binary.Method.class)));
    }

    private final Option method$$anonfun$1(String name$2, String sig$2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.cls.getMethods());
        return ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)m -> {
            SignedName signedName = JavaReflectUtils$.MODULE$.signature((Method)m);
            SignedName signedName2 = SignedName$.MODULE$.apply(name$2, sig$2);
            return !(signedName != null ? !((Object)signedName).equals(signedName2) : signedName2 != null);
        }).map((Function1 & Serializable)method -> {
            JavaReflectClass declaringClass = this.classLoader().loadClass(method.getDeclaringClass());
            return Tuple2$.MODULE$.apply(method, (Object)declaringClass);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Method method = (Method)tuple2._1();
                JavaReflectClass declaringClass = (JavaReflectClass)tuple2._2();
                return declaringClass.declaredMethod(name$2, sig$2).map((Function1 & Serializable)declaredMethod -> declaredMethod);
            }
            throw new MatchError((Object)tuple2);
        });
    }
}

