/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.javareflect;

import ch.epfl.scala.debugadapter.internal.binary.ClassType;
import ch.epfl.scala.debugadapter.internal.binary.Instruction;
import ch.epfl.scala.debugadapter.internal.binary.Method;
import ch.epfl.scala.debugadapter.internal.binary.Parameter;
import ch.epfl.scala.debugadapter.internal.binary.SignedName;
import ch.epfl.scala.debugadapter.internal.binary.SourceLines;
import ch.epfl.scala.debugadapter.internal.binary.Symbol;
import ch.epfl.scala.debugadapter.internal.binary.Type;
import ch.epfl.scala.debugadapter.internal.javareflect.ExtraMethodInfo;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectLoader;
import ch.epfl.scala.debugadapter.internal.javareflect.JavaReflectParameter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public class JavaReflectConstructor
implements Symbol,
Method {
    private final Constructor<?> constructor;
    private final SignedName signedName;
    private final ExtraMethodInfo extraInfos;
    private final JavaReflectLoader loader;

    public JavaReflectConstructor(Constructor<?> constructor, SignedName signedName, ExtraMethodInfo extraInfos, JavaReflectLoader loader) {
        this.constructor = constructor;
        this.signedName = signedName;
        this.extraInfos = extraInfos;
        this.loader = loader;
    }

    @Override
    public SignedName signedName() {
        return this.signedName;
    }

    @Override
    public Option<Type> returnType() {
        return Some$.MODULE$.apply((Object)this.loader.loadClass(Void.TYPE));
    }

    @Override
    public String returnTypeName() {
        return "void";
    }

    @Override
    public ClassType declaringClass() {
        return this.loader.loadClass(this.constructor.getDeclaringClass());
    }

    @Override
    public Seq<Parameter> allParameters() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.constructor.getParameters());
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> new JavaReflectParameter((java.lang.reflect.Parameter)_$1, this.loader), ClassTag$.MODULE$.apply(JavaReflectParameter.class)));
    }

    @Override
    public String name() {
        return "<init>";
    }

    @Override
    public boolean isBridge() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    public String toString() {
        return this.constructor.toString();
    }

    @Override
    public Option<SourceLines> sourceLines() {
        return this.extraInfos.sourceLines();
    }

    @Override
    public Seq<Instruction> instructions() {
        return this.extraInfos.instructions();
    }
}

