/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.stacktrace;

import ch.epfl.scala.debugadapter.internal.stacktrace.DecodedSymbol;
import ch.epfl.scala.debugadapter.internal.stacktrace.extensions$package$;
import scala.Option;
import scala.Some$;
import tastyquery.SourcePosition;
import tastyquery.Symbols;
import tastyquery.Trees;
import tastyquery.Types;

public interface DecodedClass
extends DecodedSymbol {

    public static final class ClassDef
    implements DecodedSymbol,
    DecodedClass {
        private final Symbols.ClassSymbol symbol;

        public ClassDef(Symbols.ClassSymbol symbol) {
            this.symbol = symbol;
        }

        public Symbols.ClassSymbol symbol() {
            return this.symbol;
        }

        public Option<Symbols.ClassSymbol> symbolOpt() {
            return Some$.MODULE$.apply((Object)this.symbol());
        }

        public String toString() {
            return new StringBuilder(10).append("ClassDef(").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(")").toString();
        }
    }

    public static final class InlinedClass
    implements DecodedSymbol,
    DecodedClass {
        private final DecodedClass underlying;
        private final Trees.Tree callTree;

        public InlinedClass(DecodedClass underlying, Trees.Tree callTree) {
            this.underlying = underlying;
            this.callTree = callTree;
        }

        public DecodedClass underlying() {
            return this.underlying;
        }

        public Trees.Tree callTree() {
            return this.callTree;
        }

        @Override
        public Option<Symbols.TermOrTypeSymbol> symbolOpt() {
            return this.underlying().symbolOpt();
        }

        public SourcePosition callPos() {
            return this.callTree().pos();
        }

        public String toString() {
            if (this.underlying() instanceof InlinedClass) {
                return this.underlying().toString();
            }
            return new StringBuilder(10).append(this.underlying()).append(" (inlined)").toString();
        }
    }

    public static final class SAMOrPartialFunction
    implements DecodedSymbol,
    DecodedClass {
        private final Symbols.TermSymbol symbol;
        private final Symbols.ClassSymbol parentClass;
        private final Types.Type tpe;

        public SAMOrPartialFunction(Symbols.TermSymbol symbol, Symbols.ClassSymbol parentClass, Types.Type tpe) {
            this.symbol = symbol;
            this.parentClass = parentClass;
            this.tpe = tpe;
        }

        public Symbols.TermSymbol symbol() {
            return this.symbol;
        }

        public Symbols.ClassSymbol parentClass() {
            return this.parentClass;
        }

        public Types.Type tpe() {
            return this.tpe;
        }

        public Option<Symbols.TermSymbol> symbolOpt() {
            return Some$.MODULE$.apply((Object)this.symbol());
        }

        public String toString() {
            return new StringBuilder(24).append("SAMOrPartialFunction(").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(", ").append(this.tpe().showBasic()).append(")").toString();
        }
    }

    public static final class SyntheticCompanionClass
    implements DecodedSymbol,
    DecodedClass {
        private final Symbols.ClassSymbol companionSymbol;

        public SyntheticCompanionClass(Symbols.ClassSymbol companionSymbol) {
            this.companionSymbol = companionSymbol;
        }

        public Symbols.ClassSymbol companionSymbol() {
            return this.companionSymbol;
        }

        public String toString() {
            return new StringBuilder(25).append("SyntheticCompanionClass(").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.companionSymbol())).append(")").toString();
        }
    }
}

