/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.stacktrace;

import ch.epfl.scala.debugadapter.internal.stacktrace.DecodedClass;
import ch.epfl.scala.debugadapter.internal.stacktrace.DecodedSymbol;
import ch.epfl.scala.debugadapter.internal.stacktrace.extensions$package$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some$;
import tastyquery.SourcePosition;
import tastyquery.Symbols;
import tastyquery.Trees;
import tastyquery.Types;

public interface DecodedMethod
extends DecodedSymbol {
    public DecodedClass owner();

    public static Option symbolOpt$(DecodedMethod $this) {
        return $this.symbolOpt();
    }

    default public Option<Symbols.TermSymbol> symbolOpt() {
        return None$.MODULE$;
    }

    public Types.TypeOrMethodic declaredType();

    public static final class AdaptedFun
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedMethod target;

        public AdaptedFun(DecodedMethod target) {
            this.target = target;
        }

        public DecodedMethod target() {
            return this.target;
        }

        @Override
        public DecodedClass owner() {
            return this.target().owner();
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.target().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return this.target().symbolOpt();
        }

        public String toString() {
            return new StringBuilder(12).append("AdaptedFun(").append(this.target()).append(")").toString();
        }
    }

    public static final class Bridge
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedMethod target;
        private final Types.TypeOrMethodic declaredType;

        public Bridge(DecodedMethod target, Types.TypeOrMethodic declaredType) {
            this.target = target;
            this.declaredType = declaredType;
        }

        public DecodedMethod target() {
            return this.target;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.target().owner();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return this.target().symbolOpt();
        }

        public String toString() {
            return new StringBuilder(10).append("Bridge(").append(this.target()).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class ByNameArg
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.Symbol treeOwner;
        private final Trees.Tree argTree;
        private final Types.Type declaredType;

        public ByNameArg(DecodedClass owner, Symbols.Symbol treeOwner, Trees.Tree argTree, Types.Type declaredType) {
            this.owner = owner;
            this.treeOwner = treeOwner;
            this.argTree = argTree;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.Symbol treeOwner() {
            return this.treeOwner;
        }

        public Trees.Tree argTree() {
            return this.argTree;
        }

        public Types.Type declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Trees.Tree> treeOpt() {
            return Some$.MODULE$.apply((Object)this.argTree());
        }

        public String toString() {
            return new StringBuilder(17).append("ByNameArg(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic(this.treeOwner())).append(", ").append(extensions$package$.MODULE$.showBasic(this.argTree().pos())).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class DeserializeLambda
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Types.TypeOrMethodic declaredType;

        public DeserializeLambda(DecodedClass owner, Types.TypeOrMethodic declaredType) {
            this.owner = owner;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.declaredType;
        }

        public String toString() {
            return new StringBuilder(21).append("DeserializeLambda(").append(this.owner()).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class GetterAccessor
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.TermSymbol symbol;
        private final Types.TypeOrMethodic declaredType;

        public GetterAccessor(DecodedClass owner, Symbols.TermSymbol symbol, Types.TypeOrMethodic declaredType) {
            this.owner = owner;
            this.symbol = symbol;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.TermSymbol symbol() {
            return this.symbol;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return Some$.MODULE$.apply((Object)this.symbol());
        }

        public String toString() {
            return new StringBuilder(20).append("GetterAccessor(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class InlineAccessor
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final DecodedMethod target;

        public InlineAccessor(DecodedClass owner, DecodedMethod target) {
            this.owner = owner;
            this.target = target;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public DecodedMethod target() {
            return this.target;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.target().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return this.target().symbolOpt();
        }

        public String toString() {
            return new StringBuilder(18).append("InlineAccessor(").append(this.owner()).append(", ").append(this.target()).append(")").toString();
        }
    }

    public static final class InlinedMethod
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedMethod underlying;
        private final Trees.Tree callTree;

        public InlinedMethod(DecodedMethod underlying, Trees.Tree callTree) {
            this.underlying = underlying;
            this.callTree = callTree;
        }

        public DecodedMethod underlying() {
            return this.underlying;
        }

        public Trees.Tree callTree() {
            return this.callTree;
        }

        @Override
        public DecodedClass owner() {
            return this.underlying().owner();
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.underlying().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return this.underlying().symbolOpt();
        }

        public SourcePosition callPos() {
            return this.callTree().pos();
        }

        public String toString() {
            if (this.underlying() instanceof InlinedMethod) {
                return this.underlying().toString();
            }
            return new StringBuilder(10).append(this.underlying()).append(" (inlined)").toString();
        }
    }

    public static final class LazyInit
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.TermSymbol symbol;

        public LazyInit(DecodedClass owner, Symbols.TermSymbol symbol) {
            this.owner = owner;
            this.symbol = symbol;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.TermSymbol symbol() {
            return this.symbol;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.symbol().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return Some$.MODULE$.apply((Object)this.symbol());
        }

        public String toString() {
            return new StringBuilder(12).append("LazyInit(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(")").toString();
        }
    }

    public static final class LiftedTry
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.Symbol treeOwner;
        private final Trees.Tree tryTree;
        private final Types.Type declaredType;

        public LiftedTry(DecodedClass owner, Symbols.Symbol treeOwner, Trees.Tree tryTree, Types.Type declaredType) {
            this.owner = owner;
            this.treeOwner = treeOwner;
            this.tryTree = tryTree;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.Symbol treeOwner() {
            return this.treeOwner;
        }

        public Trees.Tree tryTree() {
            return this.tryTree;
        }

        public Types.Type declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Trees.Tree> treeOpt() {
            return Some$.MODULE$.apply((Object)this.tryTree());
        }

        public String toString() {
            return new StringBuilder(17).append("LiftedTry(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic(this.treeOwner())).append(", ").append(extensions$package$.MODULE$.showBasic(this.tryTree().pos())).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class MixinForwarder
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final DecodedMethod target;

        public MixinForwarder(DecodedClass owner, DecodedMethod target) {
            this.owner = owner;
            this.target = target;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public DecodedMethod target() {
            return this.target;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.target().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return this.target().symbolOpt();
        }

        public String toString() {
            return new StringBuilder(18).append("MixinForwarder(").append(this.owner()).append(", ").append(this.target()).append(")").toString();
        }
    }

    public static final class OuterAccessor
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Types.Type declaredType;

        public OuterAccessor(DecodedClass owner, Types.Type declaredType) {
            this.owner = owner;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Types.Type declaredType() {
            return this.declaredType;
        }

        public String toString() {
            return new StringBuilder(17).append("OuterAccessor(").append(this.owner()).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class SAMOrPartialFunctionConstructor
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Types.Type declaredType;

        public SAMOrPartialFunctionConstructor(DecodedClass owner, Types.Type declaredType) {
            this.owner = owner;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Types.Type declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return None$.MODULE$;
        }

        public String toString() {
            return new StringBuilder(14).append("AdaptedFun(").append(this.owner()).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class SAMOrPartialFunctionImpl
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.TermSymbol implementedSymbol;
        private final Types.TypeOrMethodic declaredType;

        public SAMOrPartialFunctionImpl(DecodedClass owner, Symbols.TermSymbol implementedSymbol, Types.TypeOrMethodic declaredType) {
            this.owner = owner;
            this.implementedSymbol = implementedSymbol;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.TermSymbol implementedSymbol() {
            return this.implementedSymbol;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return this.owner().symbolOpt().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Symbols.TermOrTypeSymbol x) {
                    Symbols.TermOrTypeSymbol termOrTypeSymbol = x;
                    if (termOrTypeSymbol instanceof Symbols.TermSymbol) {
                        Symbols.TermSymbol sym = (Symbols.TermSymbol)termOrTypeSymbol;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Symbols.TermOrTypeSymbol x, Function1 function1) {
                    Symbols.TermOrTypeSymbol termOrTypeSymbol = x;
                    if (termOrTypeSymbol instanceof Symbols.TermSymbol) {
                        Symbols.TermSymbol sym = (Symbols.TermSymbol)termOrTypeSymbol;
                        return sym;
                    }
                    return function1.apply((Object)x);
                }
            });
        }

        @Override
        public Option<Trees.Tree> treeOpt() {
            return this.owner().treeOpt();
        }

        public String toString() {
            return new StringBuilder(30).append("SAMOrPartialFunctionImpl(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.implementedSymbol())).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class SetterAccessor
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.TermSymbol symbol;
        private final Types.TypeOrMethodic declaredType;

        public SetterAccessor(DecodedClass owner, Symbols.TermSymbol symbol, Types.TypeOrMethodic declaredType) {
            this.owner = owner;
            this.symbol = symbol;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.TermSymbol symbol() {
            return this.symbol;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return Option$.MODULE$.when(this.symbol().isMethod(), this::symbolOpt$$anonfun$1);
        }

        public String toString() {
            return new StringBuilder(20).append("SetterAccessor(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }

        private final Symbols.TermSymbol symbolOpt$$anonfun$1() {
            return this.symbol();
        }
    }

    public static final class SpecializedMethod
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.TermSymbol symbol;

        public SpecializedMethod(DecodedClass owner, Symbols.TermSymbol symbol) {
            this.owner = owner;
            this.symbol = symbol;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.TermSymbol symbol() {
            return this.symbol;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.symbol().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return Some$.MODULE$.apply((Object)this.symbol());
        }

        public String toString() {
            return new StringBuilder(21).append("SpecializedMethod(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(")").toString();
        }
    }

    public static final class StaticForwarder
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final DecodedMethod target;
        private final Types.TypeOrMethodic declaredType;

        public StaticForwarder(DecodedClass owner, DecodedMethod target, Types.TypeOrMethodic declaredType) {
            this.owner = owner;
            this.target = target;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public DecodedMethod target() {
            return this.target;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return this.target().symbolOpt();
        }

        public String toString() {
            return new StringBuilder(21).append("StaticForwarder(").append(this.owner()).append(", ").append(this.target()).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class SuperAccessor
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.TermSymbol symbol;
        private final Types.TypeOrMethodic declaredType;

        public SuperAccessor(DecodedClass owner, Symbols.TermSymbol symbol, Types.TypeOrMethodic declaredType) {
            this.owner = owner;
            this.symbol = symbol;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.TermSymbol symbol() {
            return this.symbol;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return Some$.MODULE$.apply((Object)this.symbol());
        }

        public String toString() {
            return new StringBuilder(19).append("SuperAccessor(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class SuperConstructorArg
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.ClassSymbol treeOwner;
        private final Trees.Tree argTree;
        private final Types.Type declaredType;

        public SuperConstructorArg(DecodedClass owner, Symbols.ClassSymbol treeOwner, Trees.Tree argTree, Types.Type declaredType) {
            this.owner = owner;
            this.treeOwner = treeOwner;
            this.argTree = argTree;
            this.declaredType = declaredType;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.ClassSymbol treeOwner() {
            return this.treeOwner;
        }

        public Trees.Tree argTree() {
            return this.argTree;
        }

        public Types.Type declaredType() {
            return this.declaredType;
        }

        @Override
        public Option<Trees.Tree> treeOpt() {
            return Some$.MODULE$.apply((Object)this.argTree());
        }

        public String toString() {
            return new StringBuilder(27).append("SuperConstructorArg(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.treeOwner())).append(", ").append(extensions$package$.MODULE$.showBasic(this.argTree().pos())).append(", ").append(this.declaredType().showBasic()).append(")").toString();
        }
    }

    public static final class TraitParamAccessor
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.TermSymbol symbol;

        public TraitParamAccessor(DecodedClass owner, Symbols.TermSymbol symbol) {
            this.owner = owner;
            this.symbol = symbol;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.TermSymbol symbol() {
            return this.symbol;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.symbol().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return Some$.MODULE$.apply((Object)this.symbol());
        }

        public String toString() {
            return new StringBuilder(22).append("TraitParamAccessor(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(")").toString();
        }
    }

    public static final class TraitStaticForwarder
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedMethod target;

        public TraitStaticForwarder(DecodedMethod target) {
            this.target = target;
        }

        public DecodedMethod target() {
            return this.target;
        }

        @Override
        public DecodedClass owner() {
            return this.target().owner();
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.target().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return this.target().symbolOpt();
        }

        public String toString() {
            return new StringBuilder(22).append("TraitStaticForwarder(").append(this.target()).append(")").toString();
        }
    }

    public static final class ValOrDefDef
    implements DecodedSymbol,
    DecodedMethod {
        private final DecodedClass owner;
        private final Symbols.TermSymbol symbol;

        public ValOrDefDef(DecodedClass owner, Symbols.TermSymbol symbol) {
            this.owner = owner;
            this.symbol = symbol;
        }

        @Override
        public DecodedClass owner() {
            return this.owner;
        }

        public Symbols.TermSymbol symbol() {
            return this.symbol;
        }

        @Override
        public Types.TypeOrMethodic declaredType() {
            return this.symbol().declaredType();
        }

        @Override
        public Option<Symbols.TermSymbol> symbolOpt() {
            return Some$.MODULE$.apply((Object)this.symbol());
        }

        public String toString() {
            return new StringBuilder(15).append("ValOrDefDef(").append(this.owner()).append(", ").append(extensions$package$.MODULE$.showBasic((Symbols.Symbol)this.symbol())).append(")").toString();
        }
    }
}

