/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.stacktrace;

import ch.epfl.scala.debugadapter.internal.stacktrace.DecodedClass;
import ch.epfl.scala.debugadapter.internal.stacktrace.DecodedMethod;
import ch.epfl.scala.debugadapter.internal.stacktrace.ThrowOrWarn;
import ch.epfl.scala.debugadapter.internal.stacktrace.ThrowOrWarn$package$;
import ch.epfl.scala.debugadapter.internal.stacktrace.extensions$package$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.util.matching.Regex;
import tastyquery.Names;
import tastyquery.Symbols;
import tastyquery.Types;

public class StackTraceFormatter {
    private final ThrowOrWarn x$1;

    public StackTraceFormatter(ThrowOrWarn x$1) {
        this.x$1 = x$1;
    }

    public String format(DecodedClass cls) {
        DecodedClass decodedClass = cls;
        if (decodedClass instanceof DecodedClass.ClassDef) {
            DecodedClass.ClassDef cls2 = (DecodedClass.ClassDef)decodedClass;
            return this.formatQualifiedName((Symbols.Symbol)cls2.symbol());
        }
        if (decodedClass instanceof DecodedClass.SAMOrPartialFunction) {
            DecodedClass.SAMOrPartialFunction cls3 = (DecodedClass.SAMOrPartialFunction)decodedClass;
            return this.dot(this.formatOwner((Symbols.Symbol)cls3.symbol()), new StringBuilder(7).append("<anon ").append(this.formatQualifiedName((Symbols.Symbol)cls3.parentClass())).append(">").toString());
        }
        if (decodedClass instanceof DecodedClass.SyntheticCompanionClass) {
            DecodedClass.SyntheticCompanionClass cls4 = (DecodedClass.SyntheticCompanionClass)decodedClass;
            return this.formatQualifiedName((Symbols.Symbol)cls4.companionSymbol());
        }
        if (decodedClass instanceof DecodedClass.InlinedClass) {
            DecodedClass.InlinedClass cls5 = (DecodedClass.InlinedClass)decodedClass;
            return this.format(cls5.underlying());
        }
        throw new MatchError((Object)decodedClass);
    }

    private String formatAsOwner(DecodedClass cls) {
        DecodedClass decodedClass;
        while (true) {
            if ((decodedClass = cls) instanceof DecodedClass.ClassDef) {
                DecodedClass.ClassDef cls2 = (DecodedClass.ClassDef)decodedClass;
                return this.formatAsOwner((Symbols.Symbol)cls2.symbol());
            }
            if (decodedClass instanceof DecodedClass.SAMOrPartialFunction) {
                DecodedClass.SAMOrPartialFunction cls3 = (DecodedClass.SAMOrPartialFunction)decodedClass;
                return this.shorten((List<String>)((List)this.formatAllSymbols(cls3.symbol().owner()).$colon$plus((Object)new StringBuilder(7).append("<anon ").append(this.formatQualifiedName((Symbols.Symbol)cls3.parentClass())).append(">").toString())));
            }
            if (decodedClass instanceof DecodedClass.SyntheticCompanionClass) {
                DecodedClass.SyntheticCompanionClass cls4 = (DecodedClass.SyntheticCompanionClass)decodedClass;
                return this.formatAsOwner((Symbols.Symbol)cls4.companionSymbol());
            }
            if (!(decodedClass instanceof DecodedClass.InlinedClass)) break;
            DecodedClass.InlinedClass cls5 = (DecodedClass.InlinedClass)decodedClass;
            cls = cls5.underlying();
        }
        throw new MatchError((Object)decodedClass);
    }

    public String format(DecodedMethod method) {
        String string;
        Types.TypeOrMethodic typeOrMethodic = method.declaredType();
        if (typeOrMethodic instanceof Types.Type) {
            Types.Type tpe = (Types.Type)typeOrMethodic;
            string = new StringBuilder(2).append(": ").append(this.format((Types.TypeMappable)tpe)).toString();
        } else {
            Types.TypeOrMethodic tpe = typeOrMethodic;
            string = this.format((Types.TypeMappable)tpe);
        }
        String typeAscription = string;
        return new StringBuilder(0).append(this.dot(this.formatOwner(method), this.formatName(method))).append(typeAscription).toString();
    }

    private String formatOwner(DecodedMethod method) {
        DecodedMethod decodedMethod;
        while (true) {
            if ((decodedMethod = method) instanceof DecodedMethod.ValOrDefDef) {
                DecodedMethod.ValOrDefDef method2 = (DecodedMethod.ValOrDefDef)decodedMethod;
                return this.formatOwner((Symbols.Symbol)method2.symbol());
            }
            if (decodedMethod instanceof DecodedMethod.LazyInit) {
                DecodedMethod.LazyInit method3 = (DecodedMethod.LazyInit)decodedMethod;
                if (extensions$package$.MODULE$.isTrait(method3.symbol().owner())) {
                    return this.format(method3.owner());
                }
                return this.formatOwner((Symbols.Symbol)method3.symbol());
            }
            if (decodedMethod instanceof DecodedMethod.TraitParamAccessor) {
                DecodedMethod.TraitParamAccessor method4 = (DecodedMethod.TraitParamAccessor)decodedMethod;
                return this.format(method4.owner());
            }
            if (decodedMethod instanceof DecodedMethod.MixinForwarder) {
                DecodedMethod.MixinForwarder method5 = (DecodedMethod.MixinForwarder)decodedMethod;
                return this.format(method5.owner());
            }
            if (decodedMethod instanceof DecodedMethod.TraitStaticForwarder) {
                DecodedMethod.TraitStaticForwarder method6 = (DecodedMethod.TraitStaticForwarder)decodedMethod;
                method = method6.target();
                continue;
            }
            if (decodedMethod instanceof DecodedMethod.OuterAccessor) {
                DecodedMethod.OuterAccessor method7 = (DecodedMethod.OuterAccessor)decodedMethod;
                return this.format(method7.owner());
            }
            if (decodedMethod instanceof DecodedMethod.SuperConstructorArg) {
                DecodedMethod.SuperConstructorArg method8 = (DecodedMethod.SuperConstructorArg)decodedMethod;
                return this.formatAsOwner((Symbols.Symbol)method8.treeOwner());
            }
            if (decodedMethod instanceof DecodedMethod.LiftedTry) {
                DecodedMethod.LiftedTry method9 = (DecodedMethod.LiftedTry)decodedMethod;
                return this.formatAsOwner(method9.treeOwner());
            }
            if (decodedMethod instanceof DecodedMethod.ByNameArg) {
                DecodedMethod.ByNameArg method10 = (DecodedMethod.ByNameArg)decodedMethod;
                return this.formatAsOwner(method10.treeOwner());
            }
            if (decodedMethod instanceof DecodedMethod.Bridge) {
                DecodedMethod.Bridge method11 = (DecodedMethod.Bridge)decodedMethod;
                method = method11.target();
                continue;
            }
            if (decodedMethod instanceof DecodedMethod.SAMOrPartialFunctionImpl) {
                DecodedMethod.SAMOrPartialFunctionImpl method12 = (DecodedMethod.SAMOrPartialFunctionImpl)decodedMethod;
                return this.format(method12.owner());
            }
            if (decodedMethod instanceof DecodedMethod.StaticForwarder) {
                DecodedMethod.StaticForwarder method13 = (DecodedMethod.StaticForwarder)decodedMethod;
                return this.format(method13.owner());
            }
            if (decodedMethod instanceof DecodedMethod.DeserializeLambda) {
                DecodedMethod.DeserializeLambda method14 = (DecodedMethod.DeserializeLambda)decodedMethod;
                return this.format(method14.owner());
            }
            if (decodedMethod instanceof DecodedMethod.SetterAccessor) {
                DecodedMethod.SetterAccessor method15 = (DecodedMethod.SetterAccessor)decodedMethod;
                return this.format(method15.owner());
            }
            if (decodedMethod instanceof DecodedMethod.GetterAccessor) {
                DecodedMethod.GetterAccessor method16 = (DecodedMethod.GetterAccessor)decodedMethod;
                return this.format(method16.owner());
            }
            if (decodedMethod instanceof DecodedMethod.SuperAccessor) {
                DecodedMethod.SuperAccessor method17 = (DecodedMethod.SuperAccessor)decodedMethod;
                return this.format(method17.owner());
            }
            if (decodedMethod instanceof DecodedMethod.SpecializedMethod) {
                DecodedMethod.SpecializedMethod method18 = (DecodedMethod.SpecializedMethod)decodedMethod;
                return this.formatOwner((Symbols.Symbol)method18.symbol());
            }
            if (decodedMethod instanceof DecodedMethod.InlineAccessor) {
                DecodedMethod.InlineAccessor method19 = (DecodedMethod.InlineAccessor)decodedMethod;
                return this.format(method19.owner());
            }
            if (decodedMethod instanceof DecodedMethod.AdaptedFun) {
                DecodedMethod.AdaptedFun method20 = (DecodedMethod.AdaptedFun)decodedMethod;
                method = method20.target();
                continue;
            }
            if (decodedMethod instanceof DecodedMethod.SAMOrPartialFunctionConstructor) {
                DecodedMethod.SAMOrPartialFunctionConstructor method21 = (DecodedMethod.SAMOrPartialFunctionConstructor)decodedMethod;
                return this.format(method21.owner());
            }
            if (!(decodedMethod instanceof DecodedMethod.InlinedMethod)) break;
            DecodedMethod.InlinedMethod method22 = (DecodedMethod.InlinedMethod)decodedMethod;
            method = method22.underlying();
        }
        throw new MatchError((Object)decodedMethod);
    }

    private String formatName(DecodedMethod method) {
        DecodedMethod decodedMethod;
        while (true) {
            if ((decodedMethod = method) instanceof DecodedMethod.ValOrDefDef) {
                DecodedMethod.ValOrDefDef method2 = (DecodedMethod.ValOrDefDef)decodedMethod;
                return this.formatName((Symbols.Symbol)method2.symbol());
            }
            if (decodedMethod instanceof DecodedMethod.LazyInit) {
                DecodedMethod.LazyInit method3 = (DecodedMethod.LazyInit)decodedMethod;
                return this.dot(this.formatName((Symbols.Symbol)method3.symbol()), "<lazy init>");
            }
            if (decodedMethod instanceof DecodedMethod.TraitParamAccessor) {
                DecodedMethod.TraitParamAccessor method4 = (DecodedMethod.TraitParamAccessor)decodedMethod;
                return this.formatName((Symbols.Symbol)method4.symbol());
            }
            if (decodedMethod instanceof DecodedMethod.MixinForwarder) {
                DecodedMethod.MixinForwarder method5 = (DecodedMethod.MixinForwarder)decodedMethod;
                return this.dot(this.formatName(method5.target()), "<mixin forwarder>");
            }
            if (decodedMethod instanceof DecodedMethod.TraitStaticForwarder) {
                DecodedMethod.TraitStaticForwarder method6 = (DecodedMethod.TraitStaticForwarder)decodedMethod;
                return this.dot(this.formatName(method6.target()), "<static forwarder>");
            }
            if (decodedMethod instanceof DecodedMethod.OuterAccessor) {
                return "<outer>";
            }
            if (decodedMethod instanceof DecodedMethod.SuperConstructorArg) {
                DecodedMethod.SuperConstructorArg method7 = (DecodedMethod.SuperConstructorArg)decodedMethod;
                return "<init>.<super arg>";
            }
            if (decodedMethod instanceof DecodedMethod.LiftedTry) {
                DecodedMethod.LiftedTry method8 = (DecodedMethod.LiftedTry)decodedMethod;
                return "<try>";
            }
            if (decodedMethod instanceof DecodedMethod.ByNameArg) {
                return "<by-name arg>";
            }
            if (decodedMethod instanceof DecodedMethod.Bridge) {
                DecodedMethod.Bridge method9 = (DecodedMethod.Bridge)decodedMethod;
                return this.dot(this.formatName(method9.target()), "<bridge>");
            }
            if (decodedMethod instanceof DecodedMethod.SAMOrPartialFunctionImpl) {
                DecodedMethod.SAMOrPartialFunctionImpl method10 = (DecodedMethod.SAMOrPartialFunctionImpl)decodedMethod;
                return this.formatName((Symbols.Symbol)method10.implementedSymbol());
            }
            if (decodedMethod instanceof DecodedMethod.StaticForwarder) {
                DecodedMethod.StaticForwarder method11 = (DecodedMethod.StaticForwarder)decodedMethod;
                return this.dot(this.formatName(method11.target()), "<static forwarder>");
            }
            if (decodedMethod instanceof DecodedMethod.DeserializeLambda) {
                return "$deserializeLambda$";
            }
            if (decodedMethod instanceof DecodedMethod.SetterAccessor) {
                DecodedMethod.SetterAccessor method12 = (DecodedMethod.SetterAccessor)decodedMethod;
                if (method12.symbol().isMethod()) {
                    return this.formatName((Symbols.Symbol)method12.symbol());
                }
                if (extensions$package$.MODULE$.isVar(method12.symbol())) {
                    return new StringBuilder(2).append(this.formatName((Symbols.Symbol)method12.symbol())).append("_=").toString();
                }
                return this.dot(this.formatName((Symbols.Symbol)method12.symbol()), "<setter>");
            }
            if (decodedMethod instanceof DecodedMethod.GetterAccessor) {
                DecodedMethod.GetterAccessor method13 = (DecodedMethod.GetterAccessor)decodedMethod;
                return this.formatName((Symbols.Symbol)method13.symbol());
            }
            if (decodedMethod instanceof DecodedMethod.SuperAccessor) {
                DecodedMethod.SuperAccessor method14 = (DecodedMethod.SuperAccessor)decodedMethod;
                return this.dot(this.formatName((Symbols.Symbol)method14.symbol()), "<super>");
            }
            if (decodedMethod instanceof DecodedMethod.SpecializedMethod) {
                DecodedMethod.SpecializedMethod method15 = (DecodedMethod.SpecializedMethod)decodedMethod;
                return this.dot(this.formatName((Symbols.Symbol)method15.symbol()), "<specialized>");
            }
            if (decodedMethod instanceof DecodedMethod.InlineAccessor) {
                DecodedMethod.InlineAccessor method16 = (DecodedMethod.InlineAccessor)decodedMethod;
                return new StringBuilder(9).append("<inline ").append(this.dot(this.formatOwner(method16.target()), this.formatName(method16.target()))).append(">").toString();
            }
            if (decodedMethod instanceof DecodedMethod.AdaptedFun) {
                DecodedMethod.AdaptedFun method17 = (DecodedMethod.AdaptedFun)decodedMethod;
                return this.dot(this.formatName(method17.target()), "<adapted>");
            }
            if (decodedMethod instanceof DecodedMethod.SAMOrPartialFunctionConstructor) {
                return "<init>";
            }
            if (!(decodedMethod instanceof DecodedMethod.InlinedMethod)) break;
            DecodedMethod.InlinedMethod method18 = (DecodedMethod.InlinedMethod)decodedMethod;
            method = method18.underlying();
        }
        throw new MatchError((Object)decodedMethod);
    }

    private String formatOwner(Symbols.Symbol sym) {
        return this.formatAsOwner(sym.owner());
    }

    private String formatQualifiedName(Symbols.Symbol sym) {
        return this.dot(this.formatAsOwner(sym.owner()), this.formatName(sym));
    }

    private String formatAsOwner(Symbols.Symbol owner) {
        return this.shorten(this.formatAllSymbols(owner));
    }

    private List<String> formatAllSymbols(Symbols.Symbol sym) {
        return this.rec$1(sym, (List)package$.MODULE$.Nil());
    }

    private String formatName(Symbols.Symbol sym) {
        Symbols.ClassSymbol sym2;
        Symbols.Symbol symbol = sym;
        if (symbol instanceof Symbols.ClassSymbol && extensions$package$.MODULE$.isPackageObjectClass((sym2 = (Symbols.ClassSymbol)symbol).name())) {
            return this.format((Names.Name)sym2.owner().name());
        }
        return this.format((Names.Name)sym.name());
    }

    public String dot(String prefix, String suffix) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(prefix)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(suffix))) {
            return new StringBuilder(1).append(prefix).append(".").append(suffix).toString();
        }
        return new StringBuilder(0).append(prefix).append(suffix).toString();
    }

    public String dotDotDot(String prefix, String suffix) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(prefix)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(suffix))) {
            return new StringBuilder(3).append(prefix).append(".\u2026.").append(suffix).toString();
        }
        return new StringBuilder(0).append(prefix).append(suffix).toString();
    }

    private String shorten(List<String> xs) {
        if (xs.size() <= 3) {
            return xs.mkString(".");
        }
        return this.dotDotDot(this.dot((String)xs.head(), (String)((IterableOps)xs.tail()).head()), (String)((List)xs.tail()).last());
    }

    private String format(Names.Name name) {
        return StackTraceFormatter.rec$2(name);
    }

    private String format(Types.TypeMappable t2) {
        Types.TypeMappable typeMappable;
        while (true) {
            if ((typeMappable = t2) instanceof Types.MethodType) {
                Types.MethodType t3 = (Types.MethodType)typeMappable;
                String params = ((List)t3.paramNames().map((Function1 & Serializable)paramName -> {
                    Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+\\$\\d+$"));
                    if (pattern.matches((CharSequence)paramName.toString())) {
                        return "";
                    }
                    return new StringBuilder(2).append(paramName).append(": ").toString();
                }).zip((IterableOnce)t3.paramTypes())).map((Function1 & Serializable)x$1 -> {
                    String string = (String)x$1._1();
                    Types.Type type = (Types.Type)x$1._2();
                    return new StringBuilder(0).append(string).append(this.format((Types.TypeMappable)type)).toString();
                }).mkString(", ");
                String sep = t3.resultType() instanceof Types.MethodicType ? "" : ": ";
                String result = this.format((Types.TypeMappable)t3.resultType());
                String prefix = t3.isContextual() ? "using " : (t3.isImplicit() ? "implicit " : "");
                return new StringBuilder(2).append("(").append(prefix).append(params).append(")").append(sep).append(result).toString();
            }
            if (typeMappable instanceof Types.TypeRef) {
                Types.TypeRef t4 = (Types.TypeRef)typeMappable;
                return new StringBuilder(0).append(this.formatPrefix(t4.prefix())).append(this.format((Names.Name)t4.name())).toString();
            }
            if (typeMappable instanceof Types.AppliedType) {
                Types.AppliedType appliedType = (Types.AppliedType)typeMappable;
                Types.AppliedType t5 = appliedType;
                if (extensions$package$.MODULE$.isFunction((Types.TermType)t5.tycon())) {
                    String args = ((List)t5.args().init()).map((Function1 & Serializable)t -> this.format((Types.TypeMappable)t)).mkString(", ");
                    String result = this.format((Types.TypeMappable)t5.args().last());
                    int n = t5.args().size();
                    if (2 == n) {
                        return new StringBuilder(4).append(args).append(" => ").append(result).toString();
                    }
                    return new StringBuilder(6).append("(").append(args).append(") => ").append(result).toString();
                }
                Types.AppliedType t6 = appliedType;
                if (extensions$package$.MODULE$.isContextFunction((Types.TermType)t6.tycon())) {
                    String args = ((List)t6.args().init()).map((Function1 & Serializable)t -> this.format((Types.TypeMappable)t)).mkString(", ");
                    String result = this.format((Types.TypeMappable)t6.args().last());
                    int n = t6.args().size();
                    if (2 == n) {
                        return new StringBuilder(5).append(args).append(" ?=> ").append(result).toString();
                    }
                    return new StringBuilder(7).append("(").append(args).append(") ?=> ").append(result).toString();
                }
                Types.AppliedType t7 = appliedType;
                if (extensions$package$.MODULE$.isTuple((Types.TermType)t7.tycon())) {
                    String types = t7.args().map((Function1 & Serializable)t -> this.format((Types.TypeMappable)t)).mkString(", ");
                    return new StringBuilder(2).append("(").append(types).append(")").toString();
                }
                Types.AppliedType t8 = appliedType;
                if (extensions$package$.MODULE$.isOperatorLike(t8.tycon()) && t8.args().size() == 2) {
                    String operatorLikeTypeFormat = t8.args().map((Function1 & Serializable)t -> this.format((Types.TypeMappable)t)).mkString(new StringBuilder(2).append(" ").append(((Types.TypeRef)t8.tycon()).name().toString()).append(" ").toString());
                    return operatorLikeTypeFormat;
                }
                Types.AppliedType t9 = appliedType;
                String tycon = this.format((Types.TypeMappable)t9.tycon());
                String args = t9.args().map((Function1 & Serializable)t -> this.format((Types.TypeMappable)t)).mkString(", ");
                return new StringBuilder(2).append(tycon).append("[").append(args).append("]").toString();
            }
            if (typeMappable instanceof Types.PolyType) {
                Types.PolyType t10 = (Types.PolyType)typeMappable;
                String args = t10.paramNames().mkString(", ");
                String sep = t10.resultType() instanceof Types.MethodicType ? "" : ": ";
                String result = this.format((Types.TypeMappable)t10.resultType());
                return new StringBuilder(2).append("[").append(args).append("]").append(sep).append(result).toString();
            }
            if (typeMappable instanceof Types.OrType) {
                Types.OrType t11 = (Types.OrType)typeMappable;
                String first = this.format((Types.TypeMappable)t11.first());
                String second = this.format((Types.TypeMappable)t11.second());
                return new StringBuilder(3).append(first).append(" | ").append(second).toString();
            }
            if (typeMappable instanceof Types.AndType) {
                Types.AndType t12 = (Types.AndType)typeMappable;
                String first = this.format((Types.TypeMappable)t12.first());
                String second = this.format((Types.TypeMappable)t12.second());
                return new StringBuilder(3).append(first).append(" & ").append(second).toString();
            }
            if (typeMappable instanceof Types.ThisType) {
                Types.ThisType t13 = (Types.ThisType)typeMappable;
                return new StringBuilder(10).append(this.format((Types.TypeMappable)t13.tref())).append(".this.type").toString();
            }
            if (typeMappable instanceof Types.TermRefinement) {
                String parentType;
                Types.TermRefinement t14 = (Types.TermRefinement)typeMappable;
                String string = parentType = this.format((Types.TypeMappable)t14.parent());
                String string2 = "PolyFunction";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return this.formatPolymorphicFunction(t14.refinedType());
                }
                return new StringBuilder(6).append(parentType).append(" {...}").toString();
            }
            if (typeMappable instanceof Types.AnnotatedType) {
                Types.AnnotatedType t15 = (Types.AnnotatedType)typeMappable;
                t2 = t15.typ();
                continue;
            }
            if (typeMappable instanceof Types.TypeParamRef) {
                Types.TypeParamRef t16 = (Types.TypeParamRef)typeMappable;
                return t16.paramName().toString();
            }
            if (typeMappable instanceof Types.TermParamRef) {
                Types.TermParamRef t17 = (Types.TermParamRef)typeMappable;
                return new StringBuilder(4).append(this.formatPrefix((Types.Prefix)t17)).append("type").toString();
            }
            if (typeMappable instanceof Types.TermRef) {
                Types.TermRef t18 = (Types.TermRef)typeMappable;
                return new StringBuilder(4).append(this.formatPrefix((Types.Prefix)t18)).append("type").toString();
            }
            if (typeMappable instanceof Types.ConstantType) {
                Types.ConstantType t19 = (Types.ConstantType)typeMappable;
                Object object = t19.value().value();
                if (object == null) {
                    return "Null";
                }
                if (object instanceof String) {
                    String str = (String)object;
                    return new StringBuilder(2).append("\"").append(str).append("\"").toString();
                }
                if (object instanceof Types.Type) {
                    Types.Type t20 = (Types.Type)object;
                    return new StringBuilder(9).append("classOf[").append(this.format((Types.TypeMappable)t20)).append("]").toString();
                }
                Object v = object;
                return v.toString();
            }
            if (typeMappable instanceof Types.ByNameType) {
                Types.ByNameType t21 = (Types.ByNameType)typeMappable;
                return new StringBuilder(3).append("=> ").append(this.format((Types.TypeMappable)t21.resultType())).toString();
            }
            if (typeMappable instanceof Types.RepeatedType) {
                Types.RepeatedType t22 = (Types.RepeatedType)typeMappable;
                return new StringBuilder(1).append(this.format((Types.TypeMappable)t22.elemType())).append("*").toString();
            }
            if (typeMappable instanceof Types.TypeRefinement) {
                Types.TypeRefinement t23 = (Types.TypeRefinement)typeMappable;
                return new StringBuilder(6).append(this.format((Types.TypeMappable)t23.parent())).append(" {...}").toString();
            }
            if (!(typeMappable instanceof Types.RecType)) break;
            Types.RecType t24 = (Types.RecType)typeMappable;
            t2 = t24.parent();
        }
        if (typeMappable instanceof Types.WildcardTypeArg) {
            return "?";
        }
        if (typeMappable instanceof Types.TypeLambda) {
            Types.TypeLambda t25 = (Types.TypeLambda)typeMappable;
            String args = t25.paramNames().map((Function1 & Serializable)t -> t.toString()).mkString(", ");
            String result = this.format((Types.TypeMappable)t25.resultType());
            return new StringBuilder(7).append("[").append(args).append("] =>> ").append(result).toString();
        }
        if (typeMappable instanceof Types.NothingType) {
            Types.NothingType t26 = (Types.NothingType)typeMappable;
            return "Nothing";
        }
        if (typeMappable instanceof Types.AnyKindType) {
            Types.AnyKindType t27 = (Types.AnyKindType)typeMappable;
            return "AnyKind";
        }
        if (typeMappable instanceof Types.RecThis || typeMappable instanceof Types.SkolemType || typeMappable instanceof Types.SuperType || typeMappable instanceof Types.MatchType || typeMappable instanceof Types.CustomTransientGroundType) {
            Types.Type t28 = (Types.Type)typeMappable;
            ThrowOrWarn$package$.MODULE$.throwOrWarn(new StringBuilder(19).append("Cannot format type ").append(t28.getClass().getName()).toString(), this.x$1);
            return "<unsupported>";
        }
        throw new MatchError((Object)typeMappable);
    }

    private String formatPolymorphicFunction(Types.TypeOrMethodic t) {
        Types.TypeOrMethodic typeOrMethodic = t;
        if (typeOrMethodic instanceof Types.PolyType) {
            Types.PolyType t2 = (Types.PolyType)typeOrMethodic;
            String args = t2.paramNames().mkString(", ");
            String result = this.formatPolymorphicFunction(t2.resultType());
            return new StringBuilder(6).append("[").append(args).append("] => ").append(result).toString();
        }
        if (typeOrMethodic instanceof Types.MethodType) {
            Types.MethodType t3 = (Types.MethodType)typeOrMethodic;
            String params = t3.paramTypes().map((Function1 & Serializable)_$1 -> this.format((Types.TypeMappable)_$1)).mkString(", ");
            if (t3.paramTypes().size() > 1) {
                return new StringBuilder(6).append("(").append(params).append(") => ").append(this.format((Types.TypeMappable)t3.resultType())).toString();
            }
            return new StringBuilder(4).append(params).append(" => ").append(this.format((Types.TypeMappable)t3.resultType())).toString();
        }
        if (typeOrMethodic instanceof Types.Type) {
            Types.Type t4 = (Types.Type)typeOrMethodic;
            return this.format((Types.TypeMappable)t4);
        }
        throw new MatchError((Object)typeOrMethodic);
    }

    private String formatPrefix(Types.Prefix p) {
        String string;
        Types.Prefix prefix = p;
        if (Types.NoPrefix$.MODULE$.equals(prefix)) {
            string = "";
        } else if (prefix instanceof Types.TermRef) {
            Types.TermRef termRef = (Types.TermRef)prefix;
            Types.TermRef p2 = termRef;
            if (extensions$package$.MODULE$.isScalaPredef(p2)) {
                string = "";
            } else {
                Types.TermRef p3 = termRef;
                if (extensions$package$.MODULE$.isPackageObject(p3.name())) {
                    string = "";
                } else {
                    Types.TermRef p4 = termRef;
                    string = new StringBuilder(0).append(this.formatPrefix(p4.prefix())).append(this.format((Names.Name)p4.name())).toString();
                }
            }
        } else if (prefix instanceof Types.TermParamRef) {
            Types.TermParamRef p5 = (Types.TermParamRef)prefix;
            string = p5.paramName().toString();
        } else if (prefix instanceof Types.PackageRef) {
            Types.PackageRef p6 = (Types.PackageRef)prefix;
            string = "";
        } else if (prefix instanceof Types.ThisType) {
            Types.ThisType p7 = (Types.ThisType)prefix;
            string = "";
        } else if (prefix instanceof Types.Type) {
            Types.Type t = (Types.Type)prefix;
            string = this.format((Types.TypeMappable)t);
        } else {
            throw new MatchError((Object)prefix);
        }
        String prefix2 = string;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(prefix2))) {
            return new StringBuilder(1).append(prefix2).append(".").toString();
        }
        return prefix2;
    }

    private final List rec$1(Symbols.Symbol sym, List acc) {
        while (true) {
            Symbols.Symbol symbol;
            if ((symbol = sym) instanceof Symbols.ClassSymbol) {
                Symbols.ClassSymbol sym2 = (Symbols.ClassSymbol)symbol;
                if (extensions$package$.MODULE$.isPackageObjectClass(sym2.name())) {
                    String string = this.format((Names.Name)sym2.owner().name());
                    return acc.$colon$colon((Object)string);
                }
                Symbols.Symbol symbol2 = sym2.owner();
                String string = this.formatName((Symbols.Symbol)sym2);
                List list = acc.$colon$colon((Object)string);
                sym = symbol2;
                acc = list;
                continue;
            }
            if (!(symbol instanceof Symbols.TermSymbol)) break;
            Symbols.TermSymbol sym3 = (Symbols.TermSymbol)symbol;
            if (extensions$package$.MODULE$.isDef(sym3)) {
                Symbols.Symbol symbol3 = sym3.owner();
                String string = this.formatName((Symbols.Symbol)sym3);
                List list = acc.$colon$colon((Object)string);
                sym = symbol3;
                acc = list;
                continue;
            }
            sym = sym3.owner();
        }
        return acc;
    }

    private static final String rec$2(Names.Name name) {
        Names.Name name2;
        while (true) {
            Names.SimpleName simpleName;
            if ((name2 = name) instanceof Names.DefaultGetterName) {
                Names.DefaultGetterName defaultGetterName = Names.DefaultGetterName$.MODULE$.unapply((Names.DefaultGetterName)name2);
                Names.UnsignedTermName unsignedTermName = defaultGetterName._1();
                int n = defaultGetterName._2();
                Names.UnsignedTermName termName = unsignedTermName;
                int num = n;
                return new StringBuilder(11).append(termName.toString()).append(".<default ").append(num + 1).append(">").toString();
            }
            if (name2 instanceof Names.TypeName) {
                Names.TypeName name3 = (Names.TypeName)name2;
                name = name3.toTermName();
                continue;
            }
            if (name2 instanceof Names.SimpleName) {
                Names.SimpleName simpleName2 = Names.SimpleName$.MODULE$.unapply((Names.SimpleName)name2);
                String string = simpleName2._1();
                if ("$anonfun".equals(string)) {
                    return "<anon fun>";
                }
                if ("$anon".equals(string)) {
                    return "<anon class>";
                }
            }
            if (!(name2 instanceof Names.ObjectClassName)) break;
            Names.ObjectClassName objectClassName = Names.ObjectClassName$.MODULE$.unapply((Names.ObjectClassName)name2);
            Names.SimpleName underlying = simpleName = objectClassName._1();
            name = underlying;
        }
        if (name2 instanceof Names.UniqueName) {
            Names.SimpleName simpleName;
            String string;
            Names.UniqueName uniqueName = Names.UniqueName$.MODULE$.unapply((Names.UniqueName)name2);
            Names.UnsignedTermName unsignedTermName = uniqueName._1();
            String string2 = uniqueName._2();
            int n = uniqueName._3();
            if (unsignedTermName instanceof Names.SimpleName && "".equals(string = (simpleName = Names.SimpleName$.MODULE$.unapply((Names.SimpleName)unsignedTermName))._1())) {
                return "<anon>";
            }
        }
        return name.toString();
    }
}

