/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.decoder.DecodedMethod;
import ch.epfl.scala.decoder.StackTraceFormatter;
import tastyquery.Modifiers;
import tastyquery.Symbols;

public class DecodedMethodBridge {
    private final DecodedMethod method;
    private final StackTraceFormatter formatter;

    public DecodedMethodBridge(DecodedMethod method, StackTraceFormatter formatter) {
        this.method = method;
        this.formatter = formatter;
    }

    public String format() {
        return this.formatter.format(this.method);
    }

    public boolean isGenerated() {
        return this.isGenerated(this.method);
    }

    private boolean isGenerated(DecodedMethod method) {
        while (true) {
            DecodedMethod decodedMethod;
            if ((decodedMethod = method) instanceof DecodedMethod.ValOrDefDef) {
                DecodedMethod.ValOrDefDef method2 = (DecodedMethod.ValOrDefDef)decodedMethod;
                Symbols.TermSymbol sym = method2.symbol();
                return this.isGetter(sym) && (!this.isTrait(sym.owner()) || !this.isModuleOrLazyVal(sym)) || this.isLocal((Symbols.Symbol)sym) && this.isModuleOrLazyVal(sym) || sym.isSetter() || sym.isSynthetic() && !this.isLocal((Symbols.Symbol)sym) || sym.isExport();
            }
            if (decodedMethod instanceof DecodedMethod.LazyInit) {
                DecodedMethod.LazyInit method3 = (DecodedMethod.LazyInit)decodedMethod;
                return this.isTrait(method3.symbol().owner());
            }
            if (decodedMethod instanceof DecodedMethod.TraitStaticForwarder) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.TraitParamAccessor) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.MixinForwarder) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.Bridge) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.StaticForwarder) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.OuterAccessor) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.SetterAccessor) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.GetterAccessor) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.SuperAccessor) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.SpecializedMethod) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.InlineAccessor) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.AdaptedFun) {
                return true;
            }
            if (decodedMethod instanceof DecodedMethod.SAMOrPartialFunctionConstructor) {
                return true;
            }
            if (!(decodedMethod instanceof DecodedMethod.InlinedMethod)) break;
            DecodedMethod.InlinedMethod method4 = (DecodedMethod.InlinedMethod)decodedMethod;
            method = method4.underlying();
        }
        return false;
    }

    private boolean isGetter(Symbols.TermSymbol symbol) {
        return !symbol.isMethod();
    }

    private boolean isModuleOrLazyVal(Symbols.TermSymbol symbol) {
        return this.isLazyVal(symbol) || symbol.isModuleVal();
    }

    private boolean isLazyVal(Symbols.TermSymbol symbol) {
        Modifiers.TermSymbolKind termSymbolKind = symbol.kind();
        Modifiers.TermSymbolKind termSymbolKind2 = Modifiers.TermSymbolKind$.LazyVal;
        return !(termSymbolKind != null ? !termSymbolKind.equals(termSymbolKind2) : termSymbolKind2 != null);
    }

    private boolean isTrait(Symbols.Symbol symbol) {
        return symbol.isClass() && symbol.asClass().isTrait();
    }

    private boolean isLocal(Symbols.Symbol symbol) {
        return symbol.owner().isTerm();
    }
}

