/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.evaluation;

import dotty.tools.dotc.EvaluationContext;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.untpd;
import dotty.tools.dotc.ast.untpd$;
import dotty.tools.dotc.core.Constants;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Names$;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.evaluation.InsertExpression$;
import dotty.tools.dotc.parsing.Parsers;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.dotc.util.Spans;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public class InsertExpression
extends Phases.Phase {
    private final EvaluationContext evalCtx;
    private final String expressionClassSource;

    public static String name() {
        return InsertExpression$.MODULE$.name();
    }

    public InsertExpression(EvaluationContext evalCtx) {
        this.evalCtx = evalCtx;
        this.expressionClassSource = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("class " + evalCtx.expressionClassName() + "(names: Array[String], values: Array[Object]):\n       |  val valuesByName = names.zip(values).toMap\n       |\n       |  def evaluate(): Unit =\n       |    ()\n       |\n       |  def callPrivate(obj: Any, methodName: String, paramTypeNames: Array[String], args: Array[Object]) =\n       |    val expectedParamTypeNames = paramTypeNames.map(paramTypeName => paramTypeName.asInstanceOf[String])\n       |    val parameterTypes = args.map(parameterType => parameterType.getClass)\n       |    val method = obj\n       |      .getClass()\n       |      .getDeclaredMethods()\n       |      .filter(declaredMethod => declaredMethod.getName() == methodName)\n       |      .find(method => {\n       |        val paramTypeNames = method\n       |          .getParameterTypes()\n       |          .map(parameterType => parameterType.getName())\n       |        val paramTypeNamesMatch = expectedParamTypeNames\n       |          .zip(paramTypeNames)\n       |          .forall {\n       |            case (expectedParamTypeName, paramTypeName) =>\n       |              expectedParamTypeName == paramTypeName\n       |          }\n       |        method.getParameterTypes().size == paramTypeNames.size && paramTypeNamesMatch\n       |      })\n       |      .get\n       |    method.setAccessible(true)\n       |    method.invoke(obj, args: _*)\n       |"));
    }

    public String phaseName() {
        return InsertExpression$.MODULE$.name();
    }

    public boolean isCheckable() {
        return false;
    }

    public void run(Contexts.Context x$1) {
        Trees.Tree parsedExpression = this.parseExpression(this.evalCtx.expression(), x$1);
        Seq<Trees.Tree<Null$>> parsedExpressionClass = this.parseExpressionClass(this.expressionClassSource, x$1);
        Trees.Tree tree = x$1.compilationUnit().untpdTree();
        x$1.compilationUnit().untpdTree_$eq(new TreeInserter(this, (Trees.Tree<Null$>)parsedExpression, parsedExpressionClass).transform(tree, x$1));
    }

    private Trees.Tree parseExpression(String expression, Contexts.Context x$2) {
        String expressionSource = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("object Expression:\n         |  { " + expression + " }\n         |"));
        Trees.Tree parsedExpression = this.parseSource("<wrapped-expression>", expressionSource, x$2);
        return (Trees.Tree)((untpd.ModuleDef)((Trees.PackageDef)parsedExpression).stats().head()).impl().body(x$2).head();
    }

    private Seq<Trees.Tree<Null$>> parseExpressionClass(String expressionClassSource, Contexts.Context x$2) {
        Trees.PackageDef parsedExpressionClass = (Trees.PackageDef)this.parseSource("source", expressionClassSource, x$2);
        return parsedExpressionClass.stats();
    }

    private Trees.Tree parseSource(String name, String source, Contexts.Context x$3) {
        Parsers.Parser parser = new Parsers.Parser(SourceFile$.MODULE$.virtual(name, source, SourceFile$.MODULE$.virtual$default$3()), x$3);
        return parser.parse();
    }

    public boolean dotty$tools$dotc$evaluation$InsertExpression$$isOnBreakpoint(Trees.Tree tree, Contexts.Context x$2) {
        int startLine = Spans.Span$.MODULE$.exists$extension(tree.span()) ? tree.sourcePos(x$2).startLine() + 1 : -1;
        return startLine == this.evalCtx.breakpointLine();
    }

    public Trees.Tree dotty$tools$dotc$evaluation$InsertExpression$$mkExprBlock(Trees.Tree expr, Trees.Tree tree, Contexts.Context x$3) {
        Names.SimpleName exprTermName = Names$.MODULE$.termName(this.evalCtx.expressionClassName().toLowerCase());
        Trees.Ident ident = untpd$.MODULE$.Ident((Names.Name)exprTermName, SourceFile$.MODULE$.fromContext(x$3));
        Trees.ValDef valDef = untpd$.MODULE$.ValDef((Names.TermName)exprTermName, (Trees.Tree)untpd$.MODULE$.TypeTree(SourceFile$.MODULE$.fromContext(x$3)), (Object)expr, SourceFile$.MODULE$.fromContext(x$3));
        return untpd$.MODULE$.Block((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Trees.NameTree[]{valDef, ident})), tree, SourceFile$.MODULE$.fromContext(x$3));
    }

    public static final /* synthetic */ Trees.Tree dotty$tools$dotc$evaluation$InsertExpression$TreeInserter$$_$transform$$anonfun$1(Trees.PackageDef tree$1, Trees.Tree _$1) {
        return (Trees.Tree)_$1.withSpan(tree$1.span());
    }

    public class TreeInserter
    extends untpd.UntypedTreeMap {
        private final Trees.Tree expression;
        private final Seq<Trees.Tree<Null$>> expressionClass;
        private boolean expressionInserted;
        private final InsertExpression $outer;

        public TreeInserter(InsertExpression $outer, Trees.Tree<Null$> expression, Seq<Trees.Tree<Null$>> expressionClass) {
            this.expression = expression;
            this.expressionClass = expressionClass;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(untpd.UntypedTreeMap$.MODULE$.$lessinit$greater$default$1());
            this.expressionInserted = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Trees.Tree transform(Trees.Tree tree, Contexts.Context x$2) {
            Trees.Tree tree2;
            Trees.Template tree3;
            Trees.PackageDef packageDef;
            Trees.Tree tree4 = tree;
            if (tree4 instanceof Trees.PackageDef) {
                Trees.PackageDef tree5 = (Trees.PackageDef)tree4;
                Trees.PackageDef transformed = (Trees.PackageDef)super.transform((Trees.Tree)tree5, x$2);
                if (this.expressionInserted) {
                    this.expressionInserted = false;
                    packageDef = this.cpy().PackageDef((Trees.Tree)transformed, transformed.pid(), (List)transformed.stats().$plus$plus((IterableOnce)this.expressionClass.map(arg_0 -> InsertExpression.dotty$tools$dotc$evaluation$InsertExpression$TreeInserter$$_$transform$$anonfun$1(tree5, arg_0))), x$2);
                    return packageDef;
                }
                packageDef = transformed;
                return packageDef;
            }
            if (tree4 instanceof Trees.Template && this.$outer.dotty$tools$dotc$evaluation$InsertExpression$$isOnBreakpoint((Trees.Tree)(tree3 = (Trees.Template)tree4), x$2)) {
                this.expressionInserted = true;
                Trees.Tree exprBlock = this.$outer.dotty$tools$dotc$evaluation$InsertExpression$$mkExprBlock(this.expression, (Trees.Tree)untpd$.MODULE$.Literal(Constants.Constant$.MODULE$.apply(BoxedUnit.UNIT), SourceFile$.MODULE$.fromContext(x$2)), x$2);
                List list = (List)tree3.body(x$2).$colon$plus((Object)exprBlock);
                Trees.DefDef defDef = this.cpy().Template$default$2(tree3);
                List list2 = this.cpy().Template$default$3(tree3);
                List list3 = this.cpy().Template$default$4(tree3);
                Trees.ValDef valDef = this.cpy().Template$default$5(tree3);
                Trees.Template newTemplate = this.cpy().Template(tree3, defDef, list2, list3, valDef, (Object)list, x$2);
                packageDef = super.transform((Trees.Tree)newTemplate, x$2);
                return packageDef;
            }
            if (tree4 instanceof Trees.DefDef) {
                Trees.DefDef defDef = (Trees.DefDef)tree4;
                Trees.DefDef defDef2 = Trees.DefDef$.MODULE$.unapply(defDef);
                Names.TermName termName = defDef2._1();
                List list = defDef2._2();
                Trees.Tree tree6 = defDef2._3();
                Object object = defDef2._4();
                Names.TermName name = termName;
                List paramss = list;
                Trees.Tree tpt = tree6;
                Trees.DefDef tree7 = defDef;
                if (this.$outer.dotty$tools$dotc$evaluation$InsertExpression$$isOnBreakpoint((Trees.Tree)tree7, x$2)) {
                    this.expressionInserted = true;
                    packageDef = this.cpy().DefDef(tree7, name, paramss, tpt, (Object)this.$outer.dotty$tools$dotc$evaluation$InsertExpression$$mkExprBlock(this.expression, tree7.rhs(x$2), x$2), x$2);
                    return packageDef;
                }
            }
            if (tree4 instanceof Trees.ValDef) {
                Trees.ValDef valDef = (Trees.ValDef)tree4;
                Trees.ValDef valDef2 = Trees.ValDef$.MODULE$.unapply(valDef);
                Names.TermName termName = valDef2._1();
                Trees.Tree tree8 = valDef2._2();
                Object object = valDef2._3();
                Names.TermName name = termName;
                Trees.Tree tpt = tree8;
                Trees.ValDef tree9 = valDef;
                if (this.$outer.dotty$tools$dotc$evaluation$InsertExpression$$isOnBreakpoint((Trees.Tree)tree9, x$2)) {
                    this.expressionInserted = true;
                    packageDef = this.cpy().ValDef(tree9, name, tpt, (Object)this.$outer.dotty$tools$dotc$evaluation$InsertExpression$$mkExprBlock(this.expression, tree9.rhs(x$2), x$2), x$2);
                    return packageDef;
                }
            }
            if (this.$outer.dotty$tools$dotc$evaluation$InsertExpression$$isOnBreakpoint(tree2 = tree4, x$2)) {
                this.expressionInserted = true;
                Trees.Block expr = (Trees.Block)this.$outer.dotty$tools$dotc$evaluation$InsertExpression$$mkExprBlock(this.expression, tree2, x$2);
                packageDef = expr;
                return packageDef;
            }
            Trees.Tree tree10 = tree4;
            packageDef = super.transform(tree10, x$2);
            return packageDef;
        }

        public final InsertExpression dotty$tools$dotc$evaluation$InsertExpression$TreeInserter$$$outer() {
            return this.$outer;
        }
    }
}

