/*
 * Decompiled with CFR 0.152.
 */
package migrate.compiler.interfaces;

import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.AbstractFile$;
import migrate.compiler.interfaces.CompilationUnit;
import migrate.compiler.interfaces.FileWithErrorReporter;
import migrate.compiler.interfaces.MigrateReporter;
import migrate.compiler.interfaces.MigrationSourceFile;
import migrate.compiler.interfaces.QuietReporter;
import migrate.compiler.interfaces.Scala3Driver;
import migrate.compiler.interfaces.Scala3SetupException;
import migrate.interfaces.CompilationException;
import migrate.interfaces.Logger;
import scala.Function1;
import scala.collection.immutable.List;
import scala.io.Codec;
import scala.runtime.AbstractFunction1;

public class Scala3Compiler {
    private Compiler compiler;
    private Contexts.Context context;
    private Codec codec = Codec.defaultCharsetCodec();
    private Function1<CompilationUnit, SourceFile> toSourceFile = new AbstractFunction1<CompilationUnit, SourceFile>(){

        public SourceFile apply(CompilationUnit compilationUnit) {
            return new MigrationSourceFile(compilationUnit.content, compilationUnit.name, compilationUnit.path);
        }
    };
    private Function1<String, SourceFile> toSourceFile2 = new AbstractFunction1<String, SourceFile>(){

        public SourceFile apply(String string) {
            AbstractFile abstractFile = AbstractFile$.MODULE$.getFile(string);
            return SourceFile$.MODULE$.apply(abstractFile, Scala3Compiler.this.codec);
        }
    };

    public Scala3Compiler(Compiler compiler, Contexts.Context context) {
        this.compiler = compiler;
        this.context = context;
    }

    public static Scala3Compiler setup(String[] stringArray) throws Scala3SetupException {
        return Scala3Driver.setupCompiler(stringArray);
    }

    public void quietCompile(List<CompilationUnit> list) throws CompilationException {
        List list2 = list.map(this.toSourceFile);
        QuietReporter quietReporter = new QuietReporter();
        Contexts.FreshContext freshContext = this.context.fresh().setReporter((Reporter)quietReporter);
        Run run = this.compiler.newRun((Contexts.Context)freshContext);
        run.compileSources(list2);
        if (quietReporter.hasErrors()) {
            throw new CompilationException(quietReporter.allErrors().mkString("\n"));
        }
    }

    public void compileWithRewrite(List<String> list) throws CompilationException {
        List list2 = list.map(this.toSourceFile2);
        QuietReporter quietReporter = new QuietReporter();
        Contexts.FreshContext freshContext = this.context.fresh().setReporter((Reporter)quietReporter);
        Run run = this.compiler.newRun((Contexts.Context)freshContext);
        run.compileSources(list2);
        if (quietReporter.hasErrors()) {
            throw new CompilationException(quietReporter.allErrors().mkString("\n"));
        }
    }

    public void compileAndReport(List<CompilationUnit> list, Logger logger) throws CompilationException {
        List list2 = list.map(this.toSourceFile);
        MigrateReporter migrateReporter = new MigrateReporter(logger);
        Contexts.FreshContext freshContext = this.context.fresh().setReporter((Reporter)migrateReporter);
        Run run = this.compiler.newRun((Contexts.Context)freshContext);
        run.compileSources(list2);
        if (migrateReporter.hasErrors()) {
            throw new CompilationException(migrateReporter.allErrors().mkString("\n"));
        }
    }

    public String[] compileAndReportFilesWithErrors(List<CompilationUnit> list) {
        List list2 = list.map(this.toSourceFile);
        FileWithErrorReporter fileWithErrorReporter = new FileWithErrorReporter();
        Contexts.FreshContext freshContext = this.context.fresh().setReporter((Reporter)fileWithErrorReporter);
        Run run = this.compiler.newRun((Contexts.Context)freshContext);
        run.compileSources(list2);
        return fileWithErrorReporter.getFilesWithErrors();
    }
}

