/*
 * Decompiled with CFR 0.152.
 */
package migrate.interfaces;

import coursierapi.Dependency;
import coursierapi.Fetch;
import coursierapi.ResolutionParams;
import coursierapi.ScalaVersion;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import migrate.interfaces.Lib;
import migrate.interfaces.Logger;
import migrate.interfaces.MigrateClassloader;
import migrate.interfaces.MigratedLibs;
import migrate.interfaces.MigratedScalacOptions;

public interface Migrate {
    public void migrate(List<Path> var1, List<Path> var2, Path var3, List<Path> var4, List<String> var5, List<Path> var6, List<String> var7, Path var8, Path var9);

    public MigratedScalacOptions migrateScalacOption(List<String> var1);

    public MigratedLibs migrateLibs(List<Lib> var1);

    public void migrateSyntax(List<Path> var1, Path var2, List<Path> var3, List<String> var4, Path var5);

    public static ClassLoader getClassLoader(String string, String string2) throws Exception {
        List<URL> list = Migrate.getJars(string, string2);
        MigrateClassloader migrateClassloader = new MigrateClassloader(Migrate.class.getClassLoader());
        URLClassLoader uRLClassLoader = new URLClassLoader((URL[])list.stream().toArray(URL[]::new), (ClassLoader)migrateClassloader);
        return uRLClassLoader;
    }

    public static Migrate getInstance(ClassLoader classLoader, Logger logger) throws Exception {
        Class<?> clazz = classLoader.loadClass("migrate.interfaces.MigrateImpl");
        Constructor<?> constructor = clazz.getDeclaredConstructor(Logger.class);
        constructor.setAccessible(true);
        return (Migrate)constructor.newInstance(logger);
    }

    public static List<URL> getJars(String string, String string2) throws Exception {
        ScalaVersion scalaVersion = ScalaVersion.of((String)string2);
        Dependency dependency = Dependency.parse((String)("ch.epfl.scala::scala3-migrate-core:" + string), (ScalaVersion)scalaVersion);
        List<URL> list = Migrate.fetch(Collections.singletonList(dependency), ResolutionParams.create());
        return list;
    }

    public static List<URL> fetch(List<Dependency> list, ResolutionParams resolutionParams) throws Exception {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        List list2 = Fetch.create().withDependencies((Dependency[])list.stream().toArray(Dependency[]::new)).withResolutionParams(resolutionParams).fetch();
        for (File file : list2) {
            URL uRL = file.toURI().toURL();
            arrayList.add(uRL);
        }
        return arrayList;
    }
}

