/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.compat;

import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class StringParsers$ {
    public static StringParsers$ MODULE$;

    static {
        new StringParsers$();
    }

    private final int intOverflowBoundary() {
        return -214748364;
    }

    private final int intOverflowDigit() {
        return 9;
    }

    private final long longOverflowBoundary() {
        return -922337203685477580L;
    }

    private final int longOverflowDigit() {
        return 9;
    }

    private final int decValue(char ch) {
        return Character.digit(ch, 10);
    }

    private final Option<Object> stepToOverflow(String from, int len, int agg, boolean isPositive, int min) {
        return this.rec$1(1, agg, min, len, isPositive, from);
    }

    private final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public final Option<Object> parseBool(String from) {
        if (from.equalsIgnoreCase("true")) {
            return new Some<Object>(BoxesRunTime.boxToBoolean(true));
        }
        if (from.equalsIgnoreCase("false")) {
            return new Some<Object>(BoxesRunTime.boxToBoolean(false));
        }
        return None$.MODULE$;
    }

    public final Option<Object> parseByte(String from) {
        int len = from.length();
        if (len == 0) {
            return None$.MODULE$;
        }
        char first = from.charAt(0);
        int v = this.decValue(first);
        if (len == 1) {
            if (v > -1) {
                return new Some<Object>(BoxesRunTime.boxToByte((byte)v));
            }
            return None$.MODULE$;
        }
        if (v > -1) {
            return this.stepToOverflow(from, len, -v, true, -128).map((Function1<Object, Object> & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToByte(StringParsers$.$anonfun$parseByte$1(BoxesRunTime.unboxToInt(x$1))));
        }
        if (first == '+') {
            return this.stepToOverflow(from, len, 0, true, -128).map((Function1<Object, Object> & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToByte(StringParsers$.$anonfun$parseByte$2(BoxesRunTime.unboxToInt(x$2))));
        }
        if (first == '-') {
            return this.stepToOverflow(from, len, 0, false, -128).map((Function1<Object, Object> & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToByte(StringParsers$.$anonfun$parseByte$3(BoxesRunTime.unboxToInt(x$3))));
        }
        return None$.MODULE$;
    }

    public final Option<Object> parseShort(String from) {
        int len = from.length();
        if (len == 0) {
            return None$.MODULE$;
        }
        char first = from.charAt(0);
        int v = this.decValue(first);
        if (len == 1) {
            if (v > -1) {
                return new Some<Object>(BoxesRunTime.boxToShort((short)v));
            }
            return None$.MODULE$;
        }
        if (v > -1) {
            return this.stepToOverflow(from, len, -v, true, Short.MIN_VALUE).map((Function1<Object, Object> & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToShort(StringParsers$.$anonfun$parseShort$1(BoxesRunTime.unboxToInt(x$4))));
        }
        if (first == '+') {
            return this.stepToOverflow(from, len, 0, true, Short.MIN_VALUE).map((Function1<Object, Object> & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToShort(StringParsers$.$anonfun$parseShort$2(BoxesRunTime.unboxToInt(x$5))));
        }
        if (first == '-') {
            return this.stepToOverflow(from, len, 0, false, Short.MIN_VALUE).map((Function1<Object, Object> & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToShort(StringParsers$.$anonfun$parseShort$3(BoxesRunTime.unboxToInt(x$6))));
        }
        return None$.MODULE$;
    }

    public final Option<Object> parseInt(String from) {
        int len = from.length();
        if (len == 0) {
            return None$.MODULE$;
        }
        char first = from.charAt(0);
        int v = this.decValue(first);
        if (len == 1) {
            if (v > -1) {
                return new Some<Object>(BoxesRunTime.boxToInteger(v));
            }
            return None$.MODULE$;
        }
        if (v > -1) {
            return this.step$1(1, -v, true, len, from);
        }
        if (first == '+') {
            return this.step$1(1, 0, true, len, from);
        }
        if (first == '-') {
            return this.step$1(1, 0, false, len, from);
        }
        return None$.MODULE$;
    }

    public final Option<Object> parseLong(String from) {
        int len = from.length();
        if (len == 0) {
            return None$.MODULE$;
        }
        char first = from.charAt(0);
        long v = this.decValue(first);
        if (len == 1) {
            if (v > -1L) {
                return new Some<Object>(BoxesRunTime.boxToLong(v));
            }
            return None$.MODULE$;
        }
        if (v > -1L) {
            return this.step$2(1, -v, true, len, from);
        }
        if (first == '+') {
            return this.step$2(1, 0L, true, len, from);
        }
        if (first == '-') {
            return this.step$2(1, 0L, false, len, from);
        }
        return None$.MODULE$;
    }

    public final boolean checkFloatFormat(String format) {
        int unsigned;
        int unspacedStart = new StringOps(Predef$.MODULE$.augmentString(format)).indexWhere((Function1<Object, Object> & java.io.Serializable & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.$anonfun$checkFloatFormat$12(BoxesRunTime.unboxToChar(ch))));
        int unspacedEnd = new StringOps(Predef$.MODULE$.augmentString(format)).lastIndexWhere((Function1<Object, Object> & java.io.Serializable & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.$anonfun$checkFloatFormat$13(BoxesRunTime.unboxToChar(ch)))) + 1;
        if (unspacedStart == -1 || unspacedStart >= unspacedEnd || unspacedEnd <= 0) {
            return false;
        }
        char startchar = format.charAt(unspacedStart);
        int n = unsigned = startchar == '-' || startchar == '+' ? unspacedStart + 1 : unspacedStart;
        if (unsigned >= unspacedEnd) {
            return false;
        }
        if (format.charAt(unsigned) == 'N') {
            String string = format.substring(unsigned, unspacedEnd);
            String string2 = "NaN";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        if (format.charAt(unsigned) == 'I') {
            String string = format.substring(unsigned, unspacedEnd);
            String string3 = "Infinity";
            return !(string != null ? !string.equals(string3) : string3 != null);
        }
        char endchar = format.charAt(unspacedEnd - 1);
        int desuffixed = endchar == 'f' || endchar == 'F' || endchar == 'd' || endchar == 'D' ? unspacedEnd - 1 : unspacedEnd;
        int len = desuffixed - unsigned;
        if (len <= 0) {
            return false;
        }
        if (len >= 2 && (format.charAt(unsigned + 1) == 'x' || format.charAt(unsigned + 1) == 'X')) {
            return format.charAt(unsigned) == '0' && this.isHexFloatLiteral$1(unsigned + 2, desuffixed, format);
        }
        return this.isDecFloatLiteral$1(unsigned, desuffixed, format);
    }

    public Option<Object> parseFloat(String from) {
        if (this.checkFloatFormat(from)) {
            return new Some<Object>(BoxesRunTime.boxToFloat(Float.parseFloat(from)));
        }
        return None$.MODULE$;
    }

    public Option<Object> parseDouble(String from) {
        if (this.checkFloatFormat(from)) {
            return new Some<Object>(BoxesRunTime.boxToDouble(Double.parseDouble(from)));
        }
        return None$.MODULE$;
    }

    private final Option rec$1(int i, int agg, int min$1, int len$1, boolean isPositive$1, String from$1) {
        while (agg >= min$1) {
            if (i == len$1) {
                if (!isPositive$1) {
                    return new Some<Integer>(BoxesRunTime.boxToInteger(agg));
                }
                if (agg == min$1) {
                    return None$.MODULE$;
                }
                return new Some<Integer>(BoxesRunTime.boxToInteger(-agg));
            }
            int digit = this.decValue(from$1.charAt(i));
            if (digit == -1) {
                return None$.MODULE$;
            }
            agg = agg * 10 - digit;
            ++i;
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ byte $anonfun$parseByte$1(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$parseByte$2(int x$2) {
        return (byte)x$2;
    }

    public static final /* synthetic */ byte $anonfun$parseByte$3(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ short $anonfun$parseShort$1(int x$4) {
        return (short)x$4;
    }

    public static final /* synthetic */ short $anonfun$parseShort$2(int x$5) {
        return (short)x$5;
    }

    public static final /* synthetic */ short $anonfun$parseShort$3(int x$6) {
        return (short)x$6;
    }

    private final Option step$1(int i, int agg, boolean isPositive, int len$2, String from$2) {
        while (true) {
            if (i == len$2) {
                if (!isPositive) {
                    return new Some<Integer>(BoxesRunTime.boxToInteger(agg));
                }
                if (agg == Integer.MIN_VALUE) {
                    return None$.MODULE$;
                }
                return new Some<Integer>(BoxesRunTime.boxToInteger(-agg));
            }
            if (agg < -214748364) {
                return None$.MODULE$;
            }
            int digit = this.decValue(from$2.charAt(i));
            if (digit == -1 || agg == -214748364 && digit == 9) {
                return None$.MODULE$;
            }
            agg = agg * 10 - digit;
            ++i;
        }
    }

    private final Option step$2(int i, long agg, boolean isPositive, int len$3, String from$3) {
        while (true) {
            if (i == len$3) {
                if (isPositive && agg == Long.MIN_VALUE) {
                    return None$.MODULE$;
                }
                if (isPositive) {
                    return new Some<Long>(BoxesRunTime.boxToLong(-agg));
                }
                return new Some<Long>(BoxesRunTime.boxToLong(agg));
            }
            if (agg < -922337203685477580L) {
                return None$.MODULE$;
            }
            int digit = this.decValue(from$3.charAt(i));
            if (digit == -1 || agg == -922337203685477580L && digit == 9) {
                return None$.MODULE$;
            }
            agg = agg * 10L - (long)digit;
            ++i;
        }
    }

    private final boolean rec$2(int i, int end$1, Function1 pred$1, String format$1) {
        boolean bl;
        block3: {
            block2: {
                while (i < end$1) {
                    if (BoxesRunTime.unboxToBoolean(pred$1.apply(BoxesRunTime.boxToCharacter(format$1.charAt(i))))) {
                        ++i;
                        continue;
                    }
                    break block2;
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean forAllBetween$1(int start, int end, Function1 pred, String format$1) {
        return this.rec$2(start, end, pred, format$1);
    }

    private final int rec$3(int i, int until$1, Function1 predicate$1, String format$1) {
        while (i < until$1 && BoxesRunTime.unboxToBoolean(predicate$1.apply(BoxesRunTime.boxToCharacter(format$1.charAt(i))))) {
            ++i;
        }
        return i;
    }

    private final int skipIndexWhile$1(Function1 predicate, int from, int until, String format$1) {
        return this.rec$3(from, until, predicate, format$1);
    }

    private static final boolean isHexDigit$1(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private final boolean prefixOK$1(int startIndex, int endIndex, String format$1) {
        int noLeading;
        int len = endIndex - startIndex;
        return len > 0 && !(format$1.charAt(startIndex) != '.' ? (noLeading = this.skipIndexWhile$1((Function1<Object, Object> & java.io.Serializable & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.isHexDigit$1(BoxesRunTime.unboxToChar(ch))), startIndex, endIndex, format$1)) < endIndex && (format$1.charAt(noLeading) != '.' || !this.forAllBetween$1(noLeading + 1, endIndex, (Function1<Object, Object> & java.io.Serializable & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.isHexDigit$1(BoxesRunTime.unboxToChar(ch))), format$1)) : len <= 1 || !this.forAllBetween$1(startIndex + 1, endIndex, (Function1<Object, Object> & java.io.Serializable & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.isHexDigit$1(BoxesRunTime.unboxToChar(ch))), format$1));
    }

    private final boolean postfixOK$1(int startIndex, int endIndex, String format$1) {
        char startchar;
        return startIndex < endIndex && (this.forAllBetween$1(startIndex, endIndex, (Function1<Object, Object> & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), format$1) || ((startchar = format$1.charAt(startIndex)) == '+' || startchar == '-') && endIndex - startIndex > 1 && this.forAllBetween$1(startIndex + 1, endIndex, (Function1<Object, Object> & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), format$1));
    }

    public static final /* synthetic */ boolean $anonfun$checkFloatFormat$6(char ch) {
        return ch == 'p' || ch == 'P';
    }

    private final boolean isHexFloatLiteral$1(int startIndex, int endIndex, String format$1) {
        int pIndex = new StringOps(Predef$.MODULE$.augmentString(format$1)).indexWhere((Function1<Object, Object> & java.io.Serializable & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.$anonfun$checkFloatFormat$6(BoxesRunTime.unboxToChar(ch))), startIndex);
        return pIndex <= endIndex && this.prefixOK$1(startIndex, pIndex, format$1) && this.postfixOK$1(pIndex + 1, endIndex, format$1);
    }

    private static final boolean isExp$1(char c) {
        return c == 'e' || c == 'E';
    }

    private final boolean expOK$1(int startIndex, int endIndex, String format$1) {
        char startChar;
        return startIndex < endIndex && !((startChar = format$1.charAt(startIndex)) != '+' && startChar != '-' ? this.skipIndexWhile$1((Function1<Object, Object> & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), startIndex, endIndex, format$1) != endIndex : endIndex <= startIndex + 1 || this.skipIndexWhile$1((Function1<Object, Object> & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), startIndex + 1, endIndex, format$1) != endIndex);
    }

    private final boolean isDecFloatLiteral$1(int startIndex, int endIndex, String format$1) {
        char startChar = format$1.charAt(startIndex);
        if (startChar == '.') {
            int noSignificant = this.skipIndexWhile$1((Function1<Object, Object> & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), startIndex + 1, endIndex, format$1);
            return noSignificant > startIndex + 1 && (noSignificant >= endIndex || StringParsers$.isExp$1(format$1.charAt(noSignificant)) && this.expOK$1(noSignificant + 1, endIndex, format$1));
        }
        if (this.isDigit(startChar)) {
            int noSignificant;
            int noInt = this.skipIndexWhile$1((Function1<Object, Object> & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), startIndex, endIndex, format$1);
            return noInt == endIndex || !(format$1.charAt(noInt) != '.' ? !StringParsers$.isExp$1(format$1.charAt(noInt)) || !this.expOK$1(noInt + 1, endIndex, format$1) : (noSignificant = this.skipIndexWhile$1((Function1<Object, Object> & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), noInt + 1, endIndex, format$1)) < endIndex && (!StringParsers$.isExp$1(format$1.charAt(noSignificant)) || !this.expOK$1(noSignificant + 1, endIndex, format$1)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkFloatFormat$12(char ch) {
        return ch > ' ';
    }

    public static final /* synthetic */ boolean $anonfun$checkFloatFormat$13(char ch) {
        return ch > ' ';
    }

    private StringParsers$() {
        MODULE$ = this;
    }
}

