/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.Patch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class UnifiedDiffUtils {
    private static final Pattern UNIFIED_DIFF_CHUNK_REGEXP = Pattern.compile("^@@\\s+-(?:(\\d+)(?:,(\\d+))?)\\s+\\+(?:(\\d+)(?:,(\\d+))?)\\s+@@$");
    private static final String NULL_FILE_INDICATOR = "/dev/null";

    public static Patch<String> parseUnifiedDiff(List<String> diff) {
        boolean inPrelude = true;
        ArrayList<String[]> rawChunk = new ArrayList<String[]>();
        Patch<String> patch = new Patch<String>();
        int old_ln = 0;
        int new_ln = 0;
        for (String line : diff) {
            if (inPrelude) {
                if (!line.startsWith("+++")) continue;
                inPrelude = false;
                continue;
            }
            Matcher m = UNIFIED_DIFF_CHUNK_REGEXP.matcher(line);
            if (m.find()) {
                UnifiedDiffUtils.processLinesInPrevChunk(rawChunk, patch, old_ln, new_ln);
                old_ln = m.group(1) == null ? 1 : Integer.parseInt(m.group(1));
                int n = new_ln = m.group(3) == null ? 1 : Integer.parseInt(m.group(3));
                if (old_ln == 0) {
                    old_ln = 1;
                }
                if (new_ln != 0) continue;
                new_ln = 1;
                continue;
            }
            if (line.length() > 0) {
                String tag = line.substring(0, 1);
                String rest = line.substring(1);
                if (!" ".equals(tag) && !"+".equals(tag) && !"-".equals(tag)) continue;
                rawChunk.add(new String[]{tag, rest});
                continue;
            }
            rawChunk.add(new String[]{" ", ""});
        }
        UnifiedDiffUtils.processLinesInPrevChunk(rawChunk, patch, old_ln, new_ln);
        return patch;
    }

    private static void processLinesInPrevChunk(List<String[]> rawChunk, Patch<String> patch, int old_ln, int new_ln) {
        if (!rawChunk.isEmpty()) {
            ArrayList<String> oldChunkLines = new ArrayList<String>();
            ArrayList<String> newChunkLines = new ArrayList<String>();
            ArrayList<Integer> removePosition = new ArrayList<Integer>();
            ArrayList<Integer> addPosition = new ArrayList<Integer>();
            int removeNum = 0;
            int addNum = 0;
            for (String[] raw_line : rawChunk) {
                String tag = raw_line[0];
                String rest = raw_line[1];
                if (" ".equals(tag) || "-".equals(tag)) {
                    ++removeNum;
                    oldChunkLines.add(rest);
                    if ("-".equals(tag)) {
                        removePosition.add(old_ln - 1 + removeNum);
                    }
                }
                if (!" ".equals(tag) && !"+".equals(tag)) continue;
                ++addNum;
                newChunkLines.add(rest);
                if (!"+".equals(tag)) continue;
                addPosition.add(new_ln - 1 + addNum);
            }
            patch.addDelta(new ChangeDelta(new Chunk(old_ln - 1, oldChunkLines, removePosition), new Chunk(new_ln - 1, newChunkLines, addPosition)));
            rawChunk.clear();
        }
    }

    public static List<String> generateUnifiedDiff(String originalFileName, String revisedFileName, List<String> originalLines, Patch<String> patch, int contextSize) {
        if (!patch.getDeltas().isEmpty()) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("--- " + Optional.ofNullable(originalFileName).orElse(NULL_FILE_INDICATOR));
            ret.add("+++ " + Optional.ofNullable(revisedFileName).orElse(NULL_FILE_INDICATOR));
            ArrayList<AbstractDelta<String>> patchDeltas = new ArrayList<AbstractDelta<String>>(patch.getDeltas());
            ArrayList<AbstractDelta<String>> deltas = new ArrayList<AbstractDelta<String>>();
            AbstractDelta delta = (AbstractDelta)patchDeltas.get(0);
            deltas.add(delta);
            if (patchDeltas.size() > 1) {
                for (int i = 1; i < patchDeltas.size(); ++i) {
                    int position = delta.getSource().getPosition();
                    AbstractDelta nextDelta = (AbstractDelta)patchDeltas.get(i);
                    if (position + delta.getSource().size() + contextSize >= nextDelta.getSource().getPosition() - contextSize) {
                        deltas.add(nextDelta);
                    } else {
                        List<String> curBlock = UnifiedDiffUtils.processDeltas(originalLines, deltas, contextSize, false);
                        ret.addAll(curBlock);
                        deltas.clear();
                        deltas.add(nextDelta);
                    }
                    delta = nextDelta;
                }
            }
            List<String> curBlock = UnifiedDiffUtils.processDeltas(originalLines, deltas, contextSize, patchDeltas.size() == 1 && originalFileName == null);
            ret.addAll(curBlock);
            return ret;
        }
        return new ArrayList<String>();
    }

    private static List<String> processDeltas(List<String> origLines, List<AbstractDelta<String>> deltas, int contextSize, boolean newFile) {
        int line;
        int contextStart;
        int origStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        AbstractDelta<String> curDelta = deltas.get(0);
        if (newFile) {
            origStart = 0;
        } else {
            origStart = curDelta.getSource().getPosition() + 1 - contextSize;
            if (origStart < 1) {
                origStart = 1;
            }
        }
        int revStart = curDelta.getTarget().getPosition() + 1 - contextSize;
        if (revStart < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getSource().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        for (line = contextStart; line < curDelta.getSource().getPosition(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        buffer.addAll(UnifiedDiffUtils.getDeltaText(curDelta));
        origTotal += curDelta.getSource().getLines().size();
        revTotal += curDelta.getTarget().getLines().size();
        for (int deltaIndex = 1; deltaIndex < deltas.size(); ++deltaIndex) {
            int intermediateStart;
            AbstractDelta<String> nextDelta = deltas.get(deltaIndex);
            for (line = intermediateStart = curDelta.getSource().getPosition() + curDelta.getSource().getLines().size(); line < nextDelta.getSource().getPosition(); ++line) {
                buffer.add(" " + origLines.get(line));
                ++origTotal;
                ++revTotal;
            }
            buffer.addAll(UnifiedDiffUtils.getDeltaText(nextDelta));
            origTotal += nextDelta.getSource().getLines().size();
            revTotal += nextDelta.getTarget().getLines().size();
            curDelta = nextDelta;
        }
        for (line = contextStart = curDelta.getSource().getPosition() + curDelta.getSource().getLines().size(); line < contextStart + contextSize && line < origLines.size(); ++line) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
        }
        StringBuilder header = new StringBuilder();
        header.append("@@ -");
        header.append(origStart);
        header.append(",");
        header.append(origTotal);
        header.append(" +");
        header.append(revStart);
        header.append(",");
        header.append(revTotal);
        header.append(" @@");
        buffer.add(0, header.toString());
        return buffer;
    }

    private static List<String> getDeltaText(AbstractDelta<String> delta) {
        ArrayList<String> buffer = new ArrayList<String>();
        for (String line : delta.getSource().getLines()) {
            buffer.add("-" + line);
        }
        for (String line : delta.getTarget().getLines()) {
            buffer.add("+" + line);
        }
        return buffer;
    }

    private UnifiedDiffUtils() {
    }

    public static List<String> generateOriginalAndDiff(List<String> original, List<String> revised) {
        return UnifiedDiffUtils.generateOriginalAndDiff(original, revised, null, null);
    }

    public static List<String> generateOriginalAndDiff(List<String> original, List<String> revised, String originalFileName, String revisedFileName) {
        Patch<String> patch;
        List<String> unifiedDiff;
        String originalFileNameTemp = originalFileName;
        String revisedFileNameTemp = originalFileName;
        if (originalFileNameTemp == null) {
            originalFileNameTemp = "original";
        }
        if (revisedFileNameTemp == null) {
            revisedFileNameTemp = "revised";
        }
        if ((unifiedDiff = UnifiedDiffUtils.generateUnifiedDiff(originalFileNameTemp, revisedFileNameTemp, original, patch = DiffUtils.diff(original, revised), 0)).isEmpty()) {
            unifiedDiff.add("--- " + originalFileNameTemp);
            unifiedDiff.add("+++ " + revisedFileNameTemp);
            unifiedDiff.add("@@ -0,0 +0,0 @@");
        } else if (unifiedDiff.size() >= 3 && !unifiedDiff.get(2).contains("@@ -1,")) {
            unifiedDiff.set(1, unifiedDiff.get(1));
            unifiedDiff.add(2, "@@ -0,0 +0,0 @@");
        }
        List<String> originalWithPrefix = original.stream().map(v -> " " + v).collect(Collectors.toList());
        return UnifiedDiffUtils.insertOrig(originalWithPrefix, unifiedDiff);
    }

    private static List<String> insertOrig(List<String> original, List<String> unifiedDiff) {
        ArrayList<String> result2 = new ArrayList<String>();
        ArrayList<List<String>> diffList = new ArrayList<List<String>>();
        ArrayList<String> diff = new ArrayList<String>();
        for (int i = 0; i < unifiedDiff.size(); ++i) {
            ArrayList<String> twoList;
            String u = unifiedDiff.get(i);
            if (u.startsWith("@@") && !"@@ -0,0 +0,0 @@".equals(u) && !u.contains("@@ -1,")) {
                twoList = new ArrayList<String>();
                twoList.addAll(diff);
                diffList.add(twoList);
                diff.clear();
                diff.add(u);
                continue;
            }
            if (i == unifiedDiff.size() - 1) {
                diff.add(u);
                twoList = new ArrayList();
                twoList.addAll(diff);
                diffList.add(twoList);
                diff.clear();
                break;
            }
            diff.add(u);
        }
        UnifiedDiffUtils.insertOrig(diffList, result2, original);
        return result2;
    }

    private static void insertOrig(List<List<String>> diffList, List<String> result2, List<String> original) {
        for (int i = 0; i < diffList.size(); ++i) {
            int start;
            List<String> diff = diffList.get(i);
            List<String> nexDiff = i == diffList.size() - 1 ? null : diffList.get(i + 1);
            String simb = i == 0 ? diff.get(2) : diff.get(0);
            String nexSimb = nexDiff == null ? null : nexDiff.get(0);
            UnifiedDiffUtils.insert(result2, diff);
            Map<String, Integer> map = UnifiedDiffUtils.getRowMap(simb);
            if (null != nexSimb) {
                Map<String, Integer> nexMap = UnifiedDiffUtils.getRowMap(nexSimb);
                int start2 = 0;
                if (map.get("orgRow") != 0) {
                    start2 = map.get("orgRow") + map.get("orgDel") - 1;
                }
                int end = nexMap.get("revRow") - 2;
                UnifiedDiffUtils.insert(result2, UnifiedDiffUtils.getOrigList(original, start2, end));
            }
            int n = start = (start = map.get("orgRow") + map.get("orgDel") - 1) == -1 ? 0 : start;
            if (simb.contains("@@ -1,") && null == nexSimb && map.get("orgDel").intValue() != original.size()) {
                UnifiedDiffUtils.insert(result2, UnifiedDiffUtils.getOrigList(original, start, original.size() - 1));
                continue;
            }
            if (null != nexSimb || map.get("orgRow") + map.get("orgDel") - 1 >= original.size()) continue;
            UnifiedDiffUtils.insert(result2, UnifiedDiffUtils.getOrigList(original, start, original.size() - 1));
        }
    }

    private static void insert(List<String> result2, List<String> noChangeContent) {
        for (String ins : noChangeContent) {
            result2.add(ins);
        }
    }

    private static Map<String, Integer> getRowMap(String str) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (str.startsWith("@@")) {
            String[] sp2 = str.split(" ");
            String org = sp2[1];
            String[] orgSp = org.split(",");
            map.put("orgRow", Integer.valueOf(orgSp[0].substring(1)));
            map.put("orgDel", Integer.valueOf(orgSp[1]));
            String[] revSp = org.split(",");
            map.put("revRow", Integer.valueOf(revSp[0].substring(1)));
            map.put("revAdd", Integer.valueOf(revSp[1]));
        }
        return map;
    }

    private static List<String> getOrigList(List<String> originalWithPrefix, int start, int end) {
        ArrayList<String> list = new ArrayList<String>();
        if (originalWithPrefix.size() >= 1 && start <= end && end < originalWithPrefix.size()) {
            for (int startTemp = start; startTemp <= end; ++startTemp) {
                list.add(originalWithPrefix.get(startTemp));
            }
        }
        return list;
    }
}

