/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.jgit;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import metaconfig.ConfError$;
import metaconfig.Configured;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.NullOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalafix.internal.jgit.GitChange;
import scalafix.internal.jgit.GitDiff;
import scalafix.internal.jgit.ModifiedFile;
import scalafix.internal.jgit.NewFile;

public final class JGitDiff$ {
    public static final JGitDiff$ MODULE$;

    static {
        new JGitDiff$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configured<List<GitDiff>> apply(Path workingDir, String diffBase) {
        Configured.NotOk notOk;
        if (this.isGitRepository(workingDir)) {
            Configured.NotOk notOk2;
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)builder.readEnvironment().setWorkTree(workingDir.toFile())).build();
            Either<String, ObjectId> either = this.resolve(repository, diffBase);
            if (either instanceof Right) {
                Configured.NotOk notOk3;
                Right right = (Right)either;
                ObjectId id = (ObjectId)right.b();
                Either<String, AbstractTreeIterator> either2 = this.iterator(repository, id);
                if (either2 instanceof Right) {
                    Right right2 = (Right)either2;
                    AbstractTreeIterator oldTree = (AbstractTreeIterator)right2.b();
                    FileTreeIterator newTree = new FileTreeIterator(repository);
                    List diffs = (List)this.getDiff(repository, oldTree, (AbstractTreeIterator)newTree).flatMap((Function1)new Serializable(workingDir){
                        public static final long serialVersionUID = 0L;
                        private final Path workingDir$1;

                        public final List<Product> apply(FileHeader file) {
                            DiffEntry.ChangeType changeType;
                            block7: {
                                Nil$ nil$;
                                block3: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    changeType = file.getChangeType();
                                                    if (!DiffEntry.ChangeType.ADD.equals(changeType)) break block2;
                                                    nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewFile[]{new NewFile(JGitDiff$.MODULE$.scalafix$internal$jgit$JGitDiff$$path$1(file.getNewPath(), this.workingDir$1))}));
                                                    break block3;
                                                }
                                                if (!DiffEntry.ChangeType.MODIFY.equals(changeType)) break block4;
                                                nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ModifiedFile[]{JGitDiff$.MODULE$.scalafix$internal$jgit$JGitDiff$$edits$1(file, this.workingDir$1)}));
                                                break block3;
                                            }
                                            if (!DiffEntry.ChangeType.RENAME.equals(changeType)) break block5;
                                            nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ModifiedFile[]{JGitDiff$.MODULE$.scalafix$internal$jgit$JGitDiff$$edits$1(file, this.workingDir$1)}));
                                            break block3;
                                        }
                                        if (!DiffEntry.ChangeType.COPY.equals(changeType)) break block6;
                                        nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ModifiedFile[]{JGitDiff$.MODULE$.scalafix$internal$jgit$JGitDiff$$edits$1(file, this.workingDir$1)}));
                                        break block3;
                                    }
                                    if (!DiffEntry.ChangeType.DELETE.equals(changeType)) break block7;
                                    nil$ = Nil$.MODULE$;
                                }
                                return nil$;
                            }
                            throw new MatchError((Object)changeType);
                        }
                        {
                            this.workingDir$1 = workingDir$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    notOk3 = new Configured.Ok((Object)diffs);
                } else {
                    if (!(either2 instanceof Left)) throw new MatchError(either2);
                    Left left = (Left)either2;
                    String msg = (String)left.a();
                    notOk3 = ConfError$.MODULE$.msg(msg).notOk();
                }
                notOk2 = notOk3;
            } else {
                if (!(either instanceof Left)) throw new MatchError(either);
                Left left = (Left)either;
                String msg = (String)left.a();
                notOk2 = ConfError$.MODULE$.msg(msg).notOk();
            }
            notOk = notOk2;
            return notOk;
        } else {
            notOk = ConfError$.MODULE$.msg(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a git repository"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingDir}))).notOk();
        }
        return notOk;
    }

    private <T> Left<String, T> unknown(String id) {
        return package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' unknown revision or path not in the working tree."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
    }

    private Either<String, ObjectId> resolve(Repository repo, String revstr) {
        Right right;
        try {
            Right right2;
            Option option = Option$.MODULE$.apply((Object)repo.resolve(revstr));
            if (option instanceof Some) {
                Some some = (Some)option;
                ObjectId id = (ObjectId)some.x();
                right2 = package$.MODULE$.Right().apply((Object)id);
            } else if (None$.MODULE$.equals(option)) {
                right2 = this.unknown(revstr);
            } else {
                throw new MatchError((Object)option);
            }
            right = right2;
        }
        catch (RevisionSyntaxException revisionSyntaxException) {
            right = package$.MODULE$.Left().apply((Object)revisionSyntaxException.getMessage());
        }
        catch (IncorrectObjectTypeException incorrectObjectTypeException) {
            right = package$.MODULE$.Left().apply((Object)incorrectObjectTypeException.getMessage());
        }
        catch (AmbiguousObjectException ambiguousObjectException) {
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is ambiguous. Possible candidates: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{revstr}));
            List out = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ambiguousObjectException.getCandidates()).asScala()).toList().$colon$colon((Object)string);
            right = package$.MODULE$.Left().apply((Object)out.mkString(System.lineSeparator()));
        }
        return right;
    }

    private boolean isGitRepository(Path workingDir) {
        return RepositoryCache.FileKey.isGitRepository((File)workingDir.resolve(".git").toFile(), (FS)FS.DETECTED);
    }

    private Either<String, AbstractTreeIterator> iterator(Repository repository, ObjectId id) {
        Right right;
        try {
            RevWalk walk = new RevWalk(repository);
            RevTree tree = walk.parseTree((AnyObjectId)id);
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            ObjectReader reader = repository.newObjectReader();
            treeParser.reset(reader, (AnyObjectId)tree.getId());
            walk.dispose();
            right = package$.MODULE$.Right().apply((Object)treeParser);
        }
        catch (MissingObjectException missingObjectException) {
            right = this.unknown(id.getName());
        }
        return right;
    }

    private List<FileHeader> getDiff(Repository repository, AbstractTreeIterator oldTree, AbstractTreeIterator newTree) {
        DiffFormatter diffFmt = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
        diffFmt.setRepository(repository);
        diffFmt.setContext(0);
        diffFmt.setDetectRenames(true);
        java.util.List diffs = diffFmt.scan(oldTree, newTree);
        diffFmt.format(diffs);
        diffFmt.flush();
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(diffs).asScala()).map((Function1)new Serializable(diffFmt){
            public static final long serialVersionUID = 0L;
            private final DiffFormatter diffFmt$1;

            public final FileHeader apply(DiffEntry diff) {
                return this.diffFmt$1.toFileHeader(diff);
            }
            {
                this.diffFmt$1 = diffFmt$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
    }

    public final Path scalafix$internal$jgit$JGitDiff$$path$1(String relative, Path workingDir$1) {
        return workingDir$1.resolve(relative);
    }

    public final ModifiedFile scalafix$internal$jgit$JGitDiff$$edits$1(FileHeader file, Path workingDir$1) {
        Buffer changes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)file.toEditList()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GitChange apply(Edit edit) {
                return new GitChange(edit.getBeginB(), edit.getEndB());
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new ModifiedFile(this.scalafix$internal$jgit$JGitDiff$$path$1(file.getNewPath(), workingDir$1), (List<GitChange>)changes.toList());
    }

    private JGitDiff$() {
        MODULE$ = this;
    }
}

