/*
 * Decompiled with CFR 0.152.
 */
package scalafix.cli;

import caseapp.core.Messages;
import caseapp.core.WithHelp;
import com.martiansoftware.nailgun.NGContext;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenSeq$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.meta.inputs.Input;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scalafix.Failure;
import scalafix.Fixed;
import scalafix.Scalafix$;
import scalafix.cli.ArgParserImplicits$;
import scalafix.cli.CommonOptions;
import scalafix.cli.CommonOptions$;
import scalafix.cli.ExitStatus;
import scalafix.cli.ExitStatus$;
import scalafix.cli.ScalafixOptions;
import scalafix.cli.ScalafixOptions$;
import scalafix.cli.termdisplay.TermDisplay;
import scalafix.cli.termdisplay.TermDisplay$;
import scalafix.config.ScalafixConfig;
import scalafix.rewrite.Rewrite;
import scalafix.rewrite.ScalafixMirror;
import scalafix.util.FileOps$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Cli$ {
    public static Cli$ MODULE$;
    private final Messages<WithHelp<ScalafixOptions>> withHelp;
    private final String helpMessage;
    private final String usageMessage;
    private final ScalafixOptions default;

    static {
        new Cli$();
    }

    private Messages<WithHelp<ScalafixOptions>> withHelp() {
        return this.withHelp;
    }

    public String helpMessage() {
        return this.helpMessage;
    }

    public String usageMessage() {
        return this.usageMessage;
    }

    public ScalafixOptions default() {
        return this.default;
    }

    public void main(String[] args) {
        throw scala.sys.package$.MODULE$.exit(this.runMain((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), new CommonOptions(CommonOptions$.MODULE$.apply$default$1(), CommonOptions$.MODULE$.apply$default$2(), CommonOptions$.MODULE$.apply$default$3(), CommonOptions$.MODULE$.apply$default$4(), CommonOptions$.MODULE$.apply$default$5())));
    }

    public ExitStatus safeHandleFile(File file, ScalafixOptions options) {
        ExitStatus exitStatus;
        try {
            exitStatus = this.handleFile(file, options);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.reportError(file, e, options);
            ExitStatus exitStatus2 = ExitStatus$.MODULE$.UnexpectedError();
            exitStatus = exitStatus2;
        }
        return exitStatus;
    }

    public void reportError(File file, Throwable cause, ScalafixOptions options) {
        options.common().err().println(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error fixing file: ", "\n         |Cause: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, cause})))).stripMargin());
        cause.setStackTrace((StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cause.getStackTrace())).take(options.common().stackVerbosity()));
        cause.printStackTrace(options.common().err());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExitStatus handleFile(File file, ScalafixOptions options) {
        ScalafixConfig config = file.getAbsolutePath().endsWith(".sbt") ? options.resolvedSbtConfig() : options.resolvedConfig();
        Fixed fixed = Scalafix$.MODULE$.fix((Input)Input.File$.MODULE$.apply(file), config, (Option)scalafix.syntax.package$.MODULE$.XtensionEitherString(options.resolvedMirror()).get());
        boolean bl = false;
        Fixed.Failed failed = null;
        Fixed fixed2 = fixed;
        if (fixed2 instanceof Fixed.Success) {
            Fixed.Success success = (Fixed.Success)fixed2;
            String code = success.code();
            if (options.inPlace()) {
                File outFile = options.replacePath(file);
                FileOps$.MODULE$.writeFile(outFile, code);
                return ExitStatus$.MODULE$.Ok();
            } else {
                options.common().out().write(code.getBytes());
            }
            return ExitStatus$.MODULE$.Ok();
        }
        if (fixed2 instanceof Fixed.Failed) {
            bl = true;
            failed = (Fixed.Failed)fixed2;
            Failure e = failed.e();
            if (e instanceof Failure.ParseError) {
                Failure.ParseError parseError = (Failure.ParseError)e;
                if (!options.absoluteFiles().exists((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Cli$.$anonfun$handleFile$1(file, x$3)))) return ExitStatus$.MODULE$.ParseError();
                options.common().err().write((parseError.exception().getMessage() + "\n").getBytes());
                return ExitStatus$.MODULE$.ParseError();
            }
        }
        if (!bl) throw new MatchError((Object)fixed2);
        Failure failure = failed.e();
        this.reportError(file, failure.ex(), options);
        return ExitStatus$.MODULE$.ScalafixError();
    }

    public ExitStatus runOn(ScalafixOptions config) {
        List codes = (List)config.files().map((Function1 & java.io.Serializable & Serializable)pathStr -> {
            ExitStatus exitStatus;
            File realPath;
            File path = new File((String)pathStr);
            File workingDirectory = new File(config.common().workingDirectory());
            File file = realPath = path.isAbsolute() ? path : new File(config.common().workingDirectory(), path.getPath());
            if (realPath.isDirectory()) {
                Vector files = (Vector)FileOps$.MODULE$.listFiles(realPath).filter((Function1 & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Cli$.$anonfun$runOn$2(x)));
                Vector filesToFix = config.singleThread() ? files : files.par();
                TermDisplay logger = new TermDisplay(new OutputStreamWriter(System.out), TermDisplay$.MODULE$.$lessinit$greater$default$2());
                logger.init();
                String msg = "Running scalafix...";
                logger.startTask(msg, workingDirectory);
                logger.taskLength(msg, filesToFix.length(), 0L);
                AtomicInteger counter = new AtomicInteger();
                GenSeq codes = (GenSeq)filesToFix.map((Function1 & java.io.Serializable & Serializable)x -> {
                    ExitStatus code = this.safeHandleFile(new File((String)x), config);
                    int progress = counter.incrementAndGet();
                    logger.taskProgress(msg, progress);
                    return code;
                }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom());
                logger.stop();
                exitStatus = (ExitStatus)codes.reduce((Function2 & java.io.Serializable & Serializable)(code1, code2) -> ExitStatus$.MODULE$.merge((ExitStatus)code1, (ExitStatus)code2));
            } else {
                exitStatus = this.safeHandleFile(realPath, config);
            }
            return exitStatus;
        }, List$.MODULE$.canBuildFrom());
        return (ExitStatus)codes.reduce((Function2 & java.io.Serializable & Serializable)(code1, code2) -> ExitStatus$.MODULE$.merge((ExitStatus)code1, (ExitStatus)code2));
    }

    public Either<String, WithHelp<ScalafixOptions>> parse(Seq<String> args) {
        Left left;
        Right right;
        Tuple3 tuple3;
        Either either = ArgParserImplicits$.MODULE$.OptionsParser().withHelp().detailedParse(args);
        if (either instanceof Right && (tuple3 = (Tuple3)(right = (Right)either).value()) != null) {
            WithHelp help = (WithHelp)tuple3._1();
            Seq extraFiles = (Seq)tuple3._2();
            left = ((ScalafixOptions)help.base()).resolvedMirror().map((Function1 & java.io.Serializable & Serializable)_ -> help.map((Function1 & java.io.Serializable & Serializable)x$4 -> {
                List x$12 = (List)((ScalafixOptions)help.base()).files().$plus$plus((GenTraversableOnce)extraFiles, List$.MODULE$.canBuildFrom());
                Option<ScalafixConfig> x$13 = x$4.copy$default$1();
                Option<String> x$14 = x$4.copy$default$2();
                Option<String> x$15 = x$4.copy$default$3();
                Option<String> x$16 = x$4.copy$default$4();
                List<Rewrite<ScalafixMirror>> x$17 = x$4.copy$default$5();
                boolean x$18 = x$4.copy$default$7();
                String x$19 = x$4.copy$default$8();
                String x$20 = x$4.copy$default$9();
                boolean x$21 = x$4.copy$default$10();
                boolean x$22 = x$4.copy$default$11();
                CommonOptions x$23 = x$4.copy$default$12();
                return x$4.copy(x$13, x$14, x$15, x$16, x$17, (List<String>)x$12, x$18, x$19, x$20, x$21, x$22, x$23);
            }));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            String x = (String)left2.value();
            left = package$.MODULE$.Left().apply((Object)x);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int runMain(Seq<String> args, CommonOptions commonOptions) {
        WithHelp withHelp;
        boolean bl;
        WithHelp withHelp2;
        boolean bl2 = false;
        Right right = null;
        Either<String, WithHelp<ScalafixOptions>> either = this.parse(args);
        if (either instanceof Right) {
            boolean bl3;
            bl2 = true;
            right = (Right)either;
            WithHelp withHelp3 = (WithHelp)right.value();
            if (withHelp3 != null && (bl3 = withHelp3.usage())) {
                commonOptions.out().println(this.usageMessage());
                return 0;
            }
        }
        if (bl2 && (withHelp2 = (WithHelp)right.value()) != null && (bl = withHelp2.help())) {
            commonOptions.out().println(this.helpMessage());
            return 0;
        }
        if (bl2 && (withHelp = (WithHelp)right.value()) != null) {
            ScalafixOptions options = (ScalafixOptions)withHelp.base();
            CommonOptions x$24 = commonOptions;
            Option<ScalafixConfig> x$25 = options.copy$default$1();
            Option<String> x$26 = options.copy$default$2();
            Option<String> x$27 = options.copy$default$3();
            Option<String> x$28 = options.copy$default$4();
            List<Rewrite<ScalafixMirror>> x$29 = options.copy$default$5();
            List<String> x$30 = options.copy$default$6();
            boolean x$31 = options.copy$default$7();
            String x$32 = options.copy$default$8();
            String x$33 = options.copy$default$9();
            boolean x$34 = options.copy$default$10();
            boolean x$35 = options.copy$default$11();
            return this.runOn(options.copy(x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$24)).code();
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        Left left = (Left)either;
        String error = (String)left.value();
        commonOptions.err().println(error);
        return 1;
    }

    public void nailMain(NGContext nGContext) {
        this.runMain((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])nGContext.getArgs()), new CommonOptions(nGContext.getWorkingDirectory(), nGContext.out, nGContext.in, nGContext.err, CommonOptions$.MODULE$.apply$default$5()));
    }

    public static final /* synthetic */ boolean $anonfun$handleFile$1(File file$1, File x$3) {
        String string = x$3.getAbsolutePath();
        String string2 = file$1.getAbsolutePath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$runOn$2(String x) {
        return x.endsWith(".scala") || x.endsWith(".sbt");
    }

    private Cli$() {
        MODULE$ = this;
        this.withHelp = ArgParserImplicits$.MODULE$.OptionsMessages().withHelp();
        this.helpMessage = this.withHelp().helpMessage() + new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n        |Examples:\n        |  $ scalafix --rewrites ProcedureSyntax Code.scala # print fixed file to stdout\n        |  $ cat .scalafix.conf\n        |  rewrites = [ProcedureSyntax]\n        |  $ scalafix Code.scala # Same as --rewrites ProcedureSyntax\n        |  scalafix -i --rewrites ProcedureSyntax Code.scala # write fixed file in-place\n        |Exit status codes:\n        | ", "\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ExitStatus$.MODULE$.all().mkString("\n ")})))).stripMargin();
        this.usageMessage = this.withHelp().usageMessage();
        this.default = new ScalafixOptions(ScalafixOptions$.MODULE$.apply$default$1(), ScalafixOptions$.MODULE$.apply$default$2(), ScalafixOptions$.MODULE$.apply$default$3(), ScalafixOptions$.MODULE$.apply$default$4(), ScalafixOptions$.MODULE$.apply$default$5(), ScalafixOptions$.MODULE$.apply$default$6(), ScalafixOptions$.MODULE$.apply$default$7(), ScalafixOptions$.MODULE$.apply$default$8(), ScalafixOptions$.MODULE$.apply$default$9(), ScalafixOptions$.MODULE$.apply$default$10(), ScalafixOptions$.MODULE$.apply$default$11(), ScalafixOptions$.MODULE$.apply$default$12());
    }
}

