/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.v1;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import metaconfig.Conf;
import metaconfig.Conf$;
import metaconfig.ConfEncoder$;
import metaconfig.ConfError;
import metaconfig.Configured;
import metaconfig.annotation.Hidden;
import metaconfig.annotation.Inline;
import metaconfig.generic.Setting;
import metaconfig.generic.Settings;
import metaconfig.generic.Settings$;
import metaconfig.internal.Case$;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.annotation.StaticAnnotation;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.meta.Tree;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.interactive.InteractiveSemanticdb$;
import scala.meta.internal.inputs.package$;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocument$;
import scala.meta.internal.tokenizers.PlatformTokenizerCache$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.parsers.ParseException;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;
import scalafix.Versions$;
import scalafix.cli.ExitStatus;
import scalafix.cli.ExitStatus$;
import scalafix.internal.config.PrintStreamReporter;
import scalafix.internal.diff.DiffUtils$;
import scalafix.internal.v1.ArgExpansion$;
import scalafix.internal.v1.Args;
import scalafix.internal.v1.Args$;
import scalafix.internal.v1.CompletionsOps$;
import scalafix.internal.v1.FileException;
import scalafix.internal.v1.FingerprintOps$;
import scalafix.internal.v1.LazyValue;
import scalafix.internal.v1.LazyValue$;
import scalafix.internal.v1.Ls;
import scalafix.internal.v1.Ls$Find$;
import scalafix.internal.v1.MainOps;
import scalafix.internal.v1.Section;
import scalafix.internal.v1.ValidatedArgs;
import scalafix.lint.RuleDiagnostic;
import scalafix.v1.SemanticDocument;
import scalafix.v1.SemanticDocument$;
import scalafix.v1.SyntacticDocument;
import scalafix.v1.SyntacticDocument$;

public final class MainOps$ {
    public static MainOps$ MODULE$;

    static {
        new MainOps$();
    }

    public ExitStatus run(String[] args, Args base) {
        ExitStatus exitStatus;
        List<String> expanded = ArgExpansion$.MODULE$.expand(args, base.cwd());
        PrintStream out = base.out();
        Configured configured = Conf$.MODULE$.parseCliArgs(expanded, Settings$.MODULE$.FieldsToSettings(Args$.MODULE$.argsSurface())).andThen((Function1 & java.io.Serializable & Serializable)c -> c.as(Args$.MODULE$.decoder(base)));
        if (configured instanceof Configured.Ok) {
            ExitStatus exitStatus2;
            Configured.Ok ok = (Configured.Ok)configured;
            Args args2 = (Args)ok.value();
            if (args2.help()) {
                this.helpMessage(out, 80);
                exitStatus2 = ExitStatus$.MODULE$.Ok();
            } else if (args2.version()) {
                out.println(Versions$.MODULE$.version());
                exitStatus2 = ExitStatus$.MODULE$.Ok();
            } else if (args2.bash()) {
                out.println(CompletionsOps$.MODULE$.bashCompletions());
                exitStatus2 = ExitStatus$.MODULE$.Ok();
            } else if (args2.zsh()) {
                out.println(CompletionsOps$.MODULE$.zshCompletions());
                exitStatus2 = ExitStatus$.MODULE$.Ok();
            } else {
                ExitStatus exitStatus3;
                Configured<ValidatedArgs> configured2 = args2.validate();
                if (configured2 instanceof Configured.Ok) {
                    ExitStatus exitStatus4;
                    Configured.Ok ok2 = (Configured.Ok)configured2;
                    ValidatedArgs validated = (ValidatedArgs)ok2.value();
                    if (validated.rules().isEmpty()) {
                        out.println("Missing --rules");
                        exitStatus4 = ExitStatus$.MODULE$.CommandLineError();
                    } else {
                        exitStatus4 = this.run(validated);
                    }
                    exitStatus3 = exitStatus4;
                } else if (configured2 instanceof Configured.NotOk) {
                    Configured.NotOk notOk = (Configured.NotOk)configured2;
                    ConfError err = notOk.error();
                    PrintStreamReporter qual$1 = new PrintStreamReporter(out);
                    String x$1 = err.toString();
                    Position x$2 = qual$1.error$default$2();
                    qual$1.error(x$1, x$2);
                    exitStatus3 = ExitStatus$.MODULE$.CommandLineError();
                } else {
                    throw new MatchError(configured2);
                }
                exitStatus2 = exitStatus3;
            }
            exitStatus = exitStatus2;
        } else if (configured instanceof Configured.NotOk) {
            Configured.NotOk notOk = (Configured.NotOk)configured;
            ConfError err = notOk.error();
            PrintStreamReporter qual$2 = new PrintStreamReporter(out);
            String x$3 = err.toString();
            Position x$4 = qual$2.error$default$2();
            qual$2.error(x$3, x$4);
            exitStatus = ExitStatus$.MODULE$.CommandLineError();
        } else {
            throw new MatchError((Object)configured);
        }
        return exitStatus;
    }

    public Seq<AbsolutePath> files(ValidatedArgs args) {
        List list;
        SimpleFileVisitor<Path> visitor;
        ArrayBuffer buf;
        Ls ls = args.args().ls();
        if (Ls$Find$.MODULE$.equals(ls)) {
            buf = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            visitor = new SimpleFileVisitor<Path>(args, buf){
                private final ValidatedArgs args$1;
                private final ArrayBuffer buf$1;

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    AbsolutePath path = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
                    RelativePath relpath = path.toRelative(this.args$1.sourceroot());
                    Object object = this.args$1.matches(relpath) ? this.buf$1.$plus$eq((Object)path) : BoxedUnit.UNIT;
                    return FileVisitResult.CONTINUE;
                }
                {
                    this.args$1 = args$1;
                    this.buf$1 = buf$1;
                }
            };
            if (args.args().files().isEmpty()) {
                AbsolutePath absolutePath = args.sourceroot();
                list = Nil$.MODULE$.$colon$colon((Object)absolutePath);
            } else {
                list = args.args().files();
            }
        } else {
            throw new MatchError((Object)ls);
        }
        List roots = list;
        roots.foreach((Function1 & java.io.Serializable & Serializable)root -> {
            Path path;
            if (root.isFile()) {
                path = args.matches(root.toRelative(args.args().cwd())) ? buf.$plus$eq(root) : BoxedUnit.UNIT;
            } else if (root.isDirectory()) {
                path = Files.walkFileTree(root.toNIO(), visitor);
            } else {
                args.config().reporter().error(new java.lang.StringBuilder(14).append(root).append(" is not a file").toString(), args.config().reporter().error$default$2());
                path = BoxedUnit.UNIT;
            }
            return path;
        });
        ArrayBuffer arrayBuffer = buf.result();
        return arrayBuffer;
    }

    private final void trimStackTrace(Throwable e, String untilMethod) {
        while (true) {
            StackTraceElement[] relevantStackTrace = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace())).takeWhile((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$trimStackTrace$1(untilMethod, x$2)));
            e.setStackTrace(relevantStackTrace);
            if (e.getCause() == null) break;
            e = e.getCause();
        }
    }

    public void handleException(Throwable ex, PrintStream out) {
    }

    public ExitStatus adjustExitCode(ValidatedArgs args, ExitStatus code, Seq<AbsolutePath> files) {
        ExitStatus exitStatus;
        if (args.callback().hasLintErrors()) {
            exitStatus = ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.LinterError(), code);
        } else if (args.callback().hasErrors() && code.isOk()) {
            exitStatus = ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.UnexpectedError(), code);
        } else if (files.isEmpty()) {
            args.config().reporter().error("No files to fix", args.config().reporter().error$default$2());
            exitStatus = ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.NoFilesError(), code);
        } else {
            exitStatus = code;
        }
        return exitStatus;
    }

    public void assertFreshSemanticDB(Input input, AbsolutePath file, String fix, TextDocument doc) {
        String string = input.text();
        String string2 = fix;
        if (string == null ? string2 != null : !string.equals(string2)) {
            String inputMD5;
            if (doc.md5().isEmpty()) {
                throw new IllegalArgumentException("-P:semanticdb:md5:on is required.");
            }
            String string3 = inputMD5 = FingerprintOps$.MODULE$.md5(StandardCharsets.UTF_8.encode(CharBuffer.wrap(input.chars())));
            String string4 = doc.md5();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                String string5;
                if (doc.text().isEmpty()) {
                    String string6 = inputMD5;
                    String string7 = doc.md5();
                    string5 = DiffUtils$.MODULE$.unifiedDiff(new java.lang.StringBuilder(23).append(package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append("-ondisk-md5-fingerprint").toString(), new java.lang.StringBuilder(27).append(package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append("-semanticdb-md5-fingerprint").toString(), Nil$.MODULE$.$colon$colon((Object)string6), Nil$.MODULE$.$colon$colon((Object)string7), 1);
                } else {
                    string5 = DiffUtils$.MODULE$.unifiedDiff(new java.lang.StringBuilder(7).append(package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append("-ondisk").toString(), new java.lang.StringBuilder(11).append(package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append("-semanticdb").toString(), new StringOps(Predef$.MODULE$.augmentString(input.text())).linesIterator().toList(), new StringOps(Predef$.MODULE$.augmentString(doc.text())).linesIterator().toList(), 3);
                }
                String diff = string5;
                throw new MainOps.StaleSemanticDB(file, diff);
            }
        }
    }

    public Option<TextDocument> compileWithGlobal(ValidatedArgs args, SyntacticDocument doc) {
        return ((Option)args.global().value()).map((Function1 & java.io.Serializable & Serializable)g -> {
            TextDocument textDocument;
            try {
                textDocument = InteractiveSemanticdb$.MODULE$.toTextDocument(g, doc.input().text(), package$.MODULE$.XtensionInputSyntaxStructure(doc.internal().input()).syntax(), 10000L, (List)Nil$.MODULE$);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                args.global().restart();
                TextDocument textDocument2 = TextDocument$.MODULE$.defaultInstance();
                textDocument = textDocument2;
            }
            TextDocument result = textDocument;
            g.unitOfFile().clear();
            return result.withMd5(FingerprintOps$.MODULE$.md5(StandardCharsets.UTF_8.encode(CharBuffer.wrap(doc.input().chars()))));
        });
    }

    public ExitStatus unsafeHandleFile(ValidatedArgs args, AbsolutePath file) {
        ExitStatus exitStatus;
        Tuple2 tuple2;
        Tuple2 tuple22;
        Input input = args.input(file);
        LazyValue tree = LazyValue$.MODULE$.later((Function0 & java.io.Serializable & Serializable)() -> (Tree)args.parse(input).get());
        SyntacticDocument doc = SyntacticDocument$.MODULE$.apply(input, tree, args.diffDisable(), args.config());
        if (args.rules().isSemantic()) {
            RelativePath relpath = file.toRelative(args.sourceroot());
            SemanticDocument sdoc = SemanticDocument$.MODULE$.fromPath(doc, relpath, args.classLoader(), args.symtab(), (Function0 & java.io.Serializable & Serializable)() -> MODULE$.compileWithGlobal(args, doc));
            Tuple2 tuple23 = args.rules().semanticPatch(sdoc, args.args().autoSuppressLinterErrors());
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            String fix = (String)tuple23._1();
            List messages = (List)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)fix, (Object)messages);
            Tuple2 tuple25 = tuple24;
            String fix2 = (String)tuple25._1();
            List messages2 = (List)tuple25._2();
            this.assertFreshSemanticDB(input, file, fix2, sdoc.internal().textDocument());
            tuple22 = new Tuple2((Object)fix2, (Object)messages2);
        } else {
            tuple22 = tuple2 = args.rules().syntacticPatch(doc, args.args().autoSuppressLinterErrors());
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fixed = (String)tuple2._1();
        List messages = (List)tuple2._2();
        Tuple2 tuple26 = new Tuple2((Object)fixed, (Object)messages);
        Tuple2 tuple27 = tuple26;
        String fixed2 = (String)tuple27._1();
        List messages3 = (List)tuple27._2();
        if (!args.args().autoSuppressLinterErrors()) {
            messages3.foreach((Function1 & java.io.Serializable & Serializable)diag -> {
                MainOps$.$anonfun$unsafeHandleFile$3(args, diag);
                return BoxedUnit.UNIT;
            });
        }
        if (args.args().check()) {
            String string = fixed2;
            String string2 = input.text();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                exitStatus = ExitStatus$.MODULE$.Ok();
            } else {
                String diff = DiffUtils$.MODULE$.unifiedDiff(file.toString(), "<expected fix>", new StringOps(Predef$.MODULE$.augmentString(input.text())).linesIterator().toList(), new StringOps(Predef$.MODULE$.augmentString(fixed2)).linesIterator().toList(), 3);
                args.args().out().println(diff);
                exitStatus = ExitStatus$.MODULE$.TestError();
            }
        } else if (args.args().stdout()) {
            args.args().out().println(fixed2);
            exitStatus = ExitStatus$.MODULE$.Ok();
        } else {
            Object object;
            String string = fixed2;
            String string3 = input.text();
            if (string == null ? string3 != null : !string.equals(string3)) {
                Path toFix = ((AbsolutePath)args.pathReplace().apply((Object)file)).toNIO();
                Files.createDirectories(toFix.getParent(), new FileAttribute[0]);
                object = Files.write(toFix, fixed2.getBytes(args.args().charset()), new OpenOption[0]);
            } else {
                object = BoxedUnit.UNIT;
            }
            exitStatus = ExitStatus$.MODULE$.Ok();
        }
        return exitStatus;
    }

    public ExitStatus handleFile(ValidatedArgs args, AbsolutePath file) {
        ExitStatus exitStatus;
        try {
            PlatformTokenizerCache$.MODULE$.megaCache().clear();
            exitStatus = this.unsafeHandleFile(args, file);
        }
        catch (Throwable throwable) {
            ExitStatus exitStatus2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ParseException) {
                ParseException parseException = (ParseException)throwable2;
                args.config().reporter().error(parseException.shortMessage(), parseException.pos());
                exitStatus2 = ExitStatus$.MODULE$.ParseError();
            } else if (throwable2 instanceof SemanticDocument.Error$.MissingSemanticdb) {
                SemanticDocument.Error$.MissingSemanticdb missingSemanticdb = (SemanticDocument.Error$.MissingSemanticdb)throwable2;
                args.config().reporter().error(missingSemanticdb.getMessage(), args.config().reporter().error$default$2());
                exitStatus2 = ExitStatus$.MODULE$.MissingSemanticdbError();
            } else if (throwable2 instanceof MainOps.StaleSemanticDB) {
                ExitStatus exitStatus3;
                MainOps.StaleSemanticDB staleSemanticDB = (MainOps.StaleSemanticDB)throwable2;
                if (args.args().noStaleSemanticdb()) {
                    exitStatus3 = ExitStatus$.MODULE$.Ok();
                } else {
                    args.config().reporter().error(staleSemanticDB.getMessage(), args.config().reporter().error$default$2());
                    exitStatus3 = ExitStatus$.MODULE$.StaleSemanticdbError();
                }
                exitStatus2 = exitStatus3;
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    FileException ex = new FileException(file, e);
                    this.trimStackTrace(ex, "handleFile");
                    Throwable throwable3 = e;
                    if (throwable3 instanceof AssertionError && e.getMessage() != null && e.getMessage().startsWith("assertion failed:") && e.getMessage().contains("reconstructed args: ")) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        ex.printStackTrace(args.args().out());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    exitStatus2 = ExitStatus$.MODULE$.UnexpectedError();
                } else {
                    throw throwable;
                }
            }
            exitStatus = exitStatus2;
        }
        return exitStatus;
    }

    public ExitStatus run(ValidatedArgs args) {
        Seq<AbsolutePath> files = this.files(args);
        IntRef i = IntRef.create((int)0);
        int N = files.length();
        int width = ((Object)BoxesRunTime.boxToInteger((int)N)).toString().length();
        ObjectRef exit = ObjectRef.create((Object)ExitStatus$.MODULE$.Ok());
        args.rules().rules().foreach((Function1 & java.io.Serializable & Serializable)x$7 -> {
            x$7.beforeStart();
            return BoxedUnit.UNIT;
        });
        files.foreach((Function1 & java.io.Serializable & Serializable)file -> {
            MainOps$.$anonfun$run$3(args, width, i, N, exit, file);
            return BoxedUnit.UNIT;
        });
        args.rules().rules().foreach((Function1 & java.io.Serializable & Serializable)x$8 -> {
            x$8.afterComplete();
            return BoxedUnit.UNIT;
        });
        return this.adjustExitCode(args, (ExitStatus)exit.elem, files);
    }

    public String version() {
        return new java.lang.StringBuilder(9).append("Scalafix ").append(Versions$.MODULE$.version()).toString();
    }

    public String usage() {
        return new StringOps(Predef$.MODULE$.augmentString("|Usage: scalafix [options] [<path> ...]\n       |")).stripMargin();
    }

    public Doc description() {
        return Doc$.MODULE$.paragraph(new StringOps(Predef$.MODULE$.augmentString("|Scalafix is a refactoring and linting tool.\n         |Scalafix supports both syntactic and semantic linter and rewrite rules.\n         |Syntactic rules can run on source code without compilation.\n         |Semantic rules can run on source code that has been compiled with the\n         |SemanticDB compiler plugin.\n         |")).stripMargin());
    }

    public Doc markdownish(String text) {
        ListBuffer buf = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer paragraphs = (ListBuffer)ListBuffer$.MODULE$.empty();
        BooleanRef insideCodeFence = BooleanRef.create((boolean)false);
        new StringOps(Predef$.MODULE$.augmentString(text)).linesIterator().foreach((Function1 & java.io.Serializable & Serializable)line -> {
            block0: {
                if (!line.startsWith("```")) break block0;
                MainOps$.flush$1(insideCodeFence, paragraphs, buf);
                insideCodeFence$1.elem = !insideCodeFence$1.elem;
            }
            return buf.$plus$eq(line);
        });
        MainOps$.flush$1(insideCodeFence, paragraphs, buf);
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)paragraphs);
    }

    public String options(int width) {
        StringBuilder sb = new StringBuilder();
        Settings settings = Settings$.MODULE$.apply(Args$.MODULE$.argsSurface());
        Conf.Obj obj = ConfEncoder$.MODULE$.apply(Args$.MODULE$.argsEncoder()).writeObj((Object)Args$.MODULE$.default());
        ((List)settings.settings().zip((GenIterable)obj.values(), List$.MODULE$.canBuildFrom())).foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            MainOps$.$anonfun$options$5(sb, width, x0$1);
            return BoxedUnit.UNIT;
        });
        return sb.toString();
    }

    public void helpMessage(PrintStream out, int width) {
        out.println(this.version());
        out.println(this.usage());
        out.println(this.description().render(width));
        out.println(this.options(width));
    }

    public String helpMessage(int width) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.helpMessage(new PrintStream(baos), width);
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    public static final /* synthetic */ boolean $anonfun$trimStackTrace$1(String untilMethod$1, StackTraceElement x$2) {
        String string = x$2.getMethodName();
        String string2 = untilMethod$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$unsafeHandleFile$3(ValidatedArgs args$3, RuleDiagnostic diag) {
        args$3.config().reporter().lint(diag);
    }

    public static final /* synthetic */ void $anonfun$run$3(ValidatedArgs args$4, int width$1, IntRef i$1, int N$1, ObjectRef exit$1, AbsolutePath file) {
        if (args$4.args().verbose()) {
            String message = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(21).append("Processing (%").append(width$1).append("s/%s) %s").toString())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$1.elem), BoxesRunTime.boxToInteger((int)N$1), file}));
            args$4.config().reporter().info(message, args$4.config().reporter().info$default$2());
            ++i$1.elem;
        }
        ExitStatus next = MODULE$.handleFile(args$4, file);
        exit$1.elem = ExitStatus$.MODULE$.merge((ExitStatus)exit$1.elem, next);
    }

    private static final void flush$1(BooleanRef insideCodeFence$1, ListBuffer paragraphs$1, ListBuffer buf$2) {
        ListBuffer listBuffer = insideCodeFence$1.elem ? paragraphs$1.$plus$eq((Object)Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)buf$2.map((Function1 & java.io.Serializable & Serializable)str -> Doc$.MODULE$.text(str), ListBuffer$.MODULE$.canBuildFrom()))) : paragraphs$1.$plus$eq((Object)Doc$.MODULE$.paragraph(buf$2.mkString("\n")));
        buf$2.clear();
    }

    public static final /* synthetic */ boolean $anonfun$options$1(StaticAnnotation x$9) {
        return x$9 instanceof Hidden;
    }

    private static final void printOption$1(Setting setting, Conf value, StringBuilder sb$1, int width$2) {
        if (setting.annotations().exists((Function1 & java.io.Serializable & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$options$1(x$9)))) {
            return;
        }
        setting.annotations().foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            StaticAnnotation staticAnnotation = x0$1;
            if (staticAnnotation instanceof Section) {
                Section section = (Section)staticAnnotation;
                boxedUnit = sb$1.append("\n").append(section.name()).append(":\n");
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        String name2 = Case$.MODULE$.camelToKebab(setting.name());
        sb$1.append("\n").append("  --").append(name2);
        setting.extraNames().foreach((Function1 & java.io.Serializable & Serializable)name -> name.length() == 1 ? sb$1.append(" | -").append(Case$.MODULE$.camelToKebab(name)) : BoxedUnit.UNIT);
        Object object = !setting.isBoolean() ? sb$1.append(" ").append(setting.tpe()).append(" (default: ").append(value.toString()).append(")") : BoxedUnit.UNIT;
        sb$1.append("\n");
        setting.description().foreach((Function1 & java.io.Serializable & Serializable)description -> sb$1.append("    ").append(MODULE$.markdownish((String)description).nested(4).render(width$2)).append('\n'));
    }

    public static final /* synthetic */ boolean $anonfun$options$6(StaticAnnotation x$10) {
        return x$10 instanceof Inline;
    }

    public static final /* synthetic */ boolean $anonfun$options$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$options$9(StringBuilder sb$1, int width$2, Tuple2 x$11) {
        Tuple2 tuple2;
        Setting field;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$11;
                if (tuple22 == null) break block2;
                field = (Setting)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        Conf fieldDefault = (Conf)tuple2._2();
        MainOps$.printOption$1(field, fieldDefault, sb$1, width$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$options$7(Conf value$1, StringBuilder sb$1, int width$2, Settings underlying) {
        ((TraversableLike)underlying.settings().zip((GenIterable)((Conf.Obj)value$1).values(), List$.MODULE$.canBuildFrom())).withFilter((Function1 & java.io.Serializable & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$options$8(check$ifrefutable$1))).foreach((Function1 & java.io.Serializable & Serializable)x$11 -> {
            MainOps$.$anonfun$options$9(sb$1, width$2, x$11);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$options$5(StringBuilder sb$1, int width$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Setting setting = (Setting)tuple2._1();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Conf value = (Conf)tuple22._2();
        if (setting.annotations().exists((Function1 & java.io.Serializable & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$options$6(x$10)))) {
            setting.underlying().toList().foreach((Function1 & java.io.Serializable & Serializable)underlying -> {
                MainOps$.$anonfun$options$7(value, sb$1, width$2, underlying);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            MainOps$.printOption$1(setting, value, sb$1, width$2);
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private MainOps$() {
        MODULE$ = this;
    }
}

