/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.jgit;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import metaconfig.ConfError$;
import metaconfig.Configured;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.NullOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalafix.internal.diff.DiffDisable;
import scalafix.internal.diff.DiffDisable$;
import scalafix.internal.diff.GitChange;
import scalafix.internal.diff.ModifiedFile;
import scalafix.internal.diff.NewFile;

public final class JGitDiff$ {
    public static JGitDiff$ MODULE$;

    static {
        new JGitDiff$();
    }

    public Configured<DiffDisable> apply(Path workingDir, String diffBase) {
        Configured configured;
        if (this.isGitRepository(workingDir)) {
            Configured configured2;
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)builder.readEnvironment().setWorkTree(workingDir.toFile())).build();
            Either<String, ObjectId> either = this.resolve(repository, diffBase);
            if (either instanceof Right) {
                Configured configured3;
                Right right = (Right)either;
                ObjectId id = (ObjectId)right.value();
                Either<String, AbstractTreeIterator> either2 = this.iterator(repository, id);
                if (either2 instanceof Right) {
                    Right right2 = (Right)either2;
                    AbstractTreeIterator oldTree = (AbstractTreeIterator)right2.value();
                    FileTreeIterator newTree = new FileTreeIterator(repository);
                    List diffs = (List)this.getDiff(repository, oldTree, (AbstractTreeIterator)newTree).flatMap((Function1 & java.io.Serializable & Serializable)file -> {
                        .colon.colon colon2;
                        DiffEntry.ChangeType changeType = file.getChangeType();
                        if (DiffEntry.ChangeType.ADD.equals(changeType)) {
                            colon2 = new .colon.colon((Object)new NewFile(JGitDiff$.path$1(file.getNewPath(), workingDir)), (List)Nil$.MODULE$);
                        } else if (DiffEntry.ChangeType.MODIFY.equals(changeType)) {
                            colon2 = new .colon.colon((Object)JGitDiff$.edits$1(file, workingDir), (List)Nil$.MODULE$);
                        } else if (DiffEntry.ChangeType.RENAME.equals(changeType)) {
                            colon2 = new .colon.colon((Object)JGitDiff$.edits$1(file, workingDir), (List)Nil$.MODULE$);
                        } else if (DiffEntry.ChangeType.COPY.equals(changeType)) {
                            colon2 = new .colon.colon((Object)JGitDiff$.edits$1(file, workingDir), (List)Nil$.MODULE$);
                        } else if (DiffEntry.ChangeType.DELETE.equals(changeType)) {
                            colon2 = Nil$.MODULE$;
                        } else {
                            throw new MatchError((Object)changeType);
                        }
                        return colon2;
                    }, List$.MODULE$.canBuildFrom());
                    configured3 = new Configured.Ok((Object)DiffDisable$.MODULE$.apply(diffs));
                } else if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    String msg = (String)left.value();
                    configured3 = ConfError$.MODULE$.message(msg).notOk();
                } else {
                    throw new MatchError(either2);
                }
                configured2 = configured3;
            } else if (either instanceof Left) {
                Left left = (Left)either;
                String msg = (String)left.value();
                configured2 = ConfError$.MODULE$.message(msg).notOk();
            } else {
                throw new MatchError(either);
            }
            configured = configured2;
        } else {
            configured = ConfError$.MODULE$.message(new StringBuilder(24).append(workingDir).append(" is not a git repository").toString()).notOk();
        }
        return configured;
    }

    private <T> Left<String, T> unknown(String id) {
        return package$.MODULE$.Left().apply((Object)new StringBuilder(52).append("'").append(id).append("' unknown revision or path not in the working tree.").toString());
    }

    private Either<String, ObjectId> resolve(Repository repo, String revstr) {
        Right right;
        try {
            Right right2;
            Option option = Option$.MODULE$.apply((Object)repo.resolve(revstr));
            if (option instanceof Some) {
                Some some = (Some)option;
                ObjectId id = (ObjectId)some.value();
                right2 = package$.MODULE$.Right().apply((Object)id);
            } else if (None$.MODULE$.equals(option)) {
                right2 = this.unknown(revstr);
            } else {
                throw new MatchError((Object)option);
            }
            right = right2;
        }
        catch (AmbiguousObjectException ambiguous) {
            String string = new StringBuilder(36).append(revstr).append(" is ambiguous. Possible candidates: ").toString();
            List out = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ambiguous.getCandidates()).asScala()).toList().$colon$colon((Object)string);
            right = package$.MODULE$.Left().apply((Object)out.mkString(System.lineSeparator()));
        }
        catch (IncorrectObjectTypeException ot) {
            right = package$.MODULE$.Left().apply((Object)ot.getMessage());
        }
        catch (RevisionSyntaxException st) {
            right = package$.MODULE$.Left().apply((Object)st.getMessage());
        }
        return right;
    }

    private boolean isGitRepository(Path workingDir) {
        return RepositoryCache.FileKey.isGitRepository((File)workingDir.resolve(".git").toFile(), (FS)FS.DETECTED);
    }

    private Either<String, AbstractTreeIterator> iterator(Repository repository, ObjectId id) {
        Right right;
        try {
            RevWalk walk = new RevWalk(repository);
            RevTree tree = walk.parseTree((AnyObjectId)id);
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            ObjectReader reader = repository.newObjectReader();
            treeParser.reset(reader, (AnyObjectId)tree.getId());
            walk.dispose();
            right = package$.MODULE$.Right().apply((Object)treeParser);
        }
        catch (MissingObjectException missing) {
            right = this.unknown(id.getName());
        }
        return right;
    }

    private List<FileHeader> getDiff(Repository repository, AbstractTreeIterator oldTree, AbstractTreeIterator newTree) {
        DiffFormatter diffFmt = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
        diffFmt.setRepository(repository);
        diffFmt.setContext(0);
        diffFmt.setDetectRenames(true);
        java.util.List diffs = diffFmt.scan(oldTree, newTree);
        diffFmt.format(diffs);
        diffFmt.flush();
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(diffs).asScala()).map((Function1 & java.io.Serializable & Serializable)diff -> diffFmt.toFileHeader(diff), Buffer$.MODULE$.canBuildFrom())).toList();
    }

    private static final Path path$1(String relative, Path workingDir$1) {
        return workingDir$1.resolve(relative);
    }

    private static final ModifiedFile edits$1(FileHeader file, Path workingDir$1) {
        Buffer changes = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)file.toEditList()).asScala()).map((Function1 & java.io.Serializable & Serializable)edit -> new GitChange(edit.getBeginB(), edit.getEndB()), Buffer$.MODULE$.canBuildFrom());
        return new ModifiedFile(JGitDiff$.path$1(file.getNewPath(), workingDir$1), changes.toList());
    }

    private JGitDiff$() {
        MODULE$ = this;
    }
}

