/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.v1;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import metaconfig.Conf;
import metaconfig.Conf$;
import metaconfig.ConfEncoder$;
import metaconfig.ConfError;
import metaconfig.Configured;
import metaconfig.annotation.Hidden;
import metaconfig.annotation.Inline;
import metaconfig.generic.Setting;
import metaconfig.generic.Settings;
import metaconfig.generic.Settings$;
import metaconfig.internal.Case$;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.annotation.StaticAnnotation;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.ReusableBuilder;
import scala.collection.mutable.StringBuilder;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.parsers.ParseException;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scalafix.Versions$;
import scalafix.cli.ExitStatus;
import scalafix.cli.ExitStatus$;
import scalafix.interfaces.ScalafixEvaluation;
import scalafix.internal.config.PrintStreamReporter;
import scalafix.internal.diff.DiffUtils$;
import scalafix.internal.interfaces.ScalafixEvaluationImpl;
import scalafix.internal.interfaces.ScalafixEvaluationImpl$;
import scalafix.internal.interfaces.ScalafixFileEvaluationImpl;
import scalafix.internal.interfaces.ScalafixFileEvaluationImpl$;
import scalafix.internal.patch.PatchInternals;
import scalafix.internal.patch.PatchInternals$;
import scalafix.internal.v1.ArgExpansion$;
import scalafix.internal.v1.Args;
import scalafix.internal.v1.Args$;
import scalafix.internal.v1.CompletionsOps$;
import scalafix.internal.v1.FileException;
import scalafix.internal.v1.FingerprintOps$;
import scalafix.internal.v1.Ls;
import scalafix.internal.v1.Ls$Find$;
import scalafix.internal.v1.MainOps;
import scalafix.internal.v1.Section;
import scalafix.internal.v1.ValidatedArgs;
import scalafix.lint.RuleDiagnostic;
import scalafix.patch.Patch;
import scalafix.v0.RuleCtx;
import scalafix.v0.SemanticdbIndex;
import scalafix.v1.SemanticDocument;
import scalafix.v1.SemanticDocument$;
import scalafix.v1.SyntacticDocument;
import scalafix.v1.SyntacticDocument$;

public final class MainOps$ {
    public static final MainOps$ MODULE$ = new MainOps$();

    public ExitStatus run(String[] args, Args base) {
        ExitStatus exitStatus;
        List<String> expanded = ArgExpansion$.MODULE$.expand(args, base.cwd());
        PrintStream out = base.out();
        Configured configured = Conf$.MODULE$.parseCliArgs(expanded, Settings$.MODULE$.FieldsToSettings(Args$.MODULE$.argsSurface())).andThen((Function1 & Serializable)c -> c.as(Args$.MODULE$.decoder(base)));
        if (configured instanceof Configured.Ok) {
            ExitStatus exitStatus2;
            Configured.Ok ok = (Configured.Ok)configured;
            Args args2 = (Args)ok.value();
            if (args2.help()) {
                this.helpMessage(out, 80);
                exitStatus2 = ExitStatus$.MODULE$.Ok();
            } else if (args2.version()) {
                out.println(Versions$.MODULE$.version());
                exitStatus2 = ExitStatus$.MODULE$.Ok();
            } else if (args2.bash()) {
                out.println(CompletionsOps$.MODULE$.bashCompletions());
                exitStatus2 = ExitStatus$.MODULE$.Ok();
            } else if (args2.zsh()) {
                out.println(CompletionsOps$.MODULE$.zshCompletions());
                exitStatus2 = ExitStatus$.MODULE$.Ok();
            } else {
                ExitStatus exitStatus3;
                Configured<ValidatedArgs> configured2 = args2.validate();
                if (configured2 instanceof Configured.Ok) {
                    ExitStatus exitStatus4;
                    Configured.Ok ok2 = (Configured.Ok)configured2;
                    ValidatedArgs validated = (ValidatedArgs)ok2.value();
                    if (validated.rules().isEmpty()) {
                        out.println("No rules requested to run");
                        exitStatus4 = ExitStatus$.MODULE$.NoRulesError();
                    } else {
                        exitStatus4 = this.run(validated);
                    }
                    exitStatus3 = exitStatus4;
                } else if (configured2 instanceof Configured.NotOk) {
                    Configured.NotOk notOk = (Configured.NotOk)configured2;
                    ConfError err = notOk.error();
                    PrintStreamReporter qual$1 = new PrintStreamReporter(out);
                    String x$1 = err.toString();
                    Position x$2 = qual$1.error$default$2();
                    qual$1.error(x$1, x$2);
                    exitStatus3 = ExitStatus$.MODULE$.CommandLineError();
                } else {
                    throw new MatchError(configured2);
                }
                exitStatus2 = exitStatus3;
            }
            exitStatus = exitStatus2;
        } else if (configured instanceof Configured.NotOk) {
            Configured.NotOk notOk = (Configured.NotOk)configured;
            ConfError err = notOk.error();
            PrintStreamReporter qual$2 = new PrintStreamReporter(out);
            String x$3 = err.toString();
            Position x$4 = qual$2.error$default$2();
            qual$2.error(x$3, x$4);
            exitStatus = ExitStatus$.MODULE$.CommandLineError();
        } else {
            throw new MatchError((Object)configured);
        }
        return exitStatus;
    }

    public ScalafixEvaluation runWithResult(ValidatedArgs args) {
        ScalafixEvaluationImpl scalafixEvaluationImpl;
        args.rules().rules().foreach((Function1 & Serializable)x$1 -> {
            x$1.beforeStart();
            return BoxedUnit.UNIT;
        });
        List list = args.rules().rules();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            scalafixEvaluationImpl = ScalafixEvaluationImpl$.MODULE$.apply(ExitStatus$.MODULE$.NoRulesError(), (Option<String>)new Some((Object)"No rules requested to run"));
        } else if (list != null) {
            ScalafixEvaluationImpl scalafixEvaluationImpl2;
            scala.collection.immutable.Seq<AbsolutePath> files = this.getFilesFrom(args);
            if (files.nonEmpty()) {
                scala.collection.immutable.Seq fileEvaluations = (scala.collection.immutable.Seq)files.map((Function1 & Serializable)file -> {
                    ScalafixFileEvaluationImpl scalafixFileEvaluationImpl;
                    Input input = args.input((AbsolutePath)file);
                    Try result = Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.getPatchesAndDiags(args, input, (AbsolutePath)file));
                    Try try_ = result;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        PatchInternals.ResultWithContext result2 = (PatchInternals.ResultWithContext)success.value();
                        scalafixFileEvaluationImpl = ScalafixFileEvaluationImpl$.MODULE$.from((AbsolutePath)file, (Option<String>)new Some((Object)result2.fixed()), ExitStatus$.MODULE$.Ok(), (scala.collection.immutable.Seq<Patch>)result2.patches(), (scala.collection.immutable.Seq<RuleDiagnostic>)result2.diagnostics(), args, result2.ruleCtx(), (Option<SemanticdbIndex>)result2.semanticdbIndex());
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        scalafixFileEvaluationImpl = ScalafixFileEvaluationImpl$.MODULE$.from((AbsolutePath)file, ExitStatus$.MODULE$.from(exception), exception.getMessage(), args);
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return scalafixFileEvaluationImpl;
                });
                args.rules().rules().foreach((Function1 & Serializable)x$2 -> {
                    x$2.afterComplete();
                    return BoxedUnit.UNIT;
                });
                scalafixEvaluationImpl2 = ScalafixEvaluationImpl$.MODULE$.from((scala.collection.immutable.Seq<ScalafixFileEvaluationImpl>)fileEvaluations, ExitStatus$.MODULE$.Ok());
            } else {
                scalafixEvaluationImpl2 = ScalafixEvaluationImpl$.MODULE$.apply(ExitStatus$.MODULE$.NoFilesError(), (Option<String>)new Some((Object)"No files to fix"));
            }
            scalafixEvaluationImpl = scalafixEvaluationImpl2;
        } else {
            throw new MatchError((Object)list);
        }
        return scalafixEvaluationImpl;
    }

    public scala.collection.immutable.Seq<AbsolutePath> getFilesFrom(ValidatedArgs args) {
        List list;
        SimpleFileVisitor<Path> visitor;
        ReusableBuilder buf;
        Ls ls = args.args().ls();
        if (Ls$Find$.MODULE$.equals(ls)) {
            buf = package$.MODULE$.Vector().newBuilder();
            visitor = new SimpleFileVisitor<Path>(args, buf){
                private final ValidatedArgs args$2;
                private final ReusableBuilder buf$1;

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    AbsolutePath path = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
                    RelativePath relpath = path.toRelative(this.args$2.sourceroot());
                    Object object = this.args$2.matches(relpath) ? this.buf$1.$plus$eq((Object)path) : BoxedUnit.UNIT;
                    return FileVisitResult.CONTINUE;
                }
                {
                    this.args$2 = args$2;
                    this.buf$1 = buf$1;
                }
            };
            if (args.args().files().isEmpty()) {
                AbsolutePath absolutePath = args.sourceroot();
                list = package$.MODULE$.Nil().$colon$colon((Object)absolutePath);
            } else {
                list = args.args().files();
            }
        } else {
            throw new MatchError((Object)ls);
        }
        List roots = list;
        roots.foreach((Function1 & Serializable)root -> {
            Path path;
            if (root.isFile()) {
                path = args.matches(root.toRelative(args.args().cwd())) ? buf.$plus$eq(root) : BoxedUnit.UNIT;
            } else if (root.isDirectory()) {
                path = Files.walkFileTree(root.toNIO(), visitor);
            } else {
                args.config().reporter().error(new java.lang.StringBuilder(14).append(root).append(" is not a file").toString(), args.config().reporter().error$default$2());
                path = BoxedUnit.UNIT;
            }
            return path;
        });
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)buf.result();
        return seq;
    }

    private final void trimStackTrace(Throwable e, String untilMethod) {
        while (true) {
            StackTraceElement[] relevantStackTrace = (StackTraceElement[])ArrayOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$trimStackTrace$1(untilMethod, x$3)));
            e.setStackTrace(relevantStackTrace);
            if (e.getCause() == null) break;
            e = e.getCause();
        }
    }

    public void handleException(Throwable ex, PrintStream out) {
    }

    public ExitStatus adjustExitCode(ValidatedArgs args, ExitStatus code, Seq<AbsolutePath> files) {
        ExitStatus exitStatus;
        if (args.callback().hasLintErrors()) {
            exitStatus = ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.LinterError(), code);
        } else if (args.callback().hasErrors() && code.isOk()) {
            exitStatus = ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.UnexpectedError(), code);
        } else if (files.isEmpty()) {
            args.config().reporter().error("No files to fix", args.config().reporter().error$default$2());
            exitStatus = ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.NoFilesError(), code);
        } else {
            exitStatus = code;
        }
        return exitStatus;
    }

    public void assertFreshSemanticDB(Input input, AbsolutePath file, String fix, TextDocument doc) {
        String string = input.text();
        String string2 = fix;
        if (string == null ? string2 != null : !string.equals(string2)) {
            String inputMD5;
            if (doc.md5().isEmpty()) {
                throw new IllegalArgumentException("-P:semanticdb:md5:on is required.");
            }
            String string3 = inputMD5 = FingerprintOps$.MODULE$.md5(StandardCharsets.UTF_8.encode(CharBuffer.wrap(input.chars())));
            String string4 = doc.md5();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                String string5;
                if (doc.text().isEmpty()) {
                    String string6 = inputMD5;
                    String string7 = doc.md5();
                    string5 = DiffUtils$.MODULE$.unifiedDiff(new java.lang.StringBuilder(23).append(scala.meta.internal.inputs.package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append("-ondisk-md5-fingerprint").toString(), new java.lang.StringBuilder(27).append(scala.meta.internal.inputs.package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append("-semanticdb-md5-fingerprint").toString(), package$.MODULE$.Nil().$colon$colon((Object)string6), package$.MODULE$.Nil().$colon$colon((Object)string7), 1);
                } else {
                    string5 = DiffUtils$.MODULE$.unifiedDiff(new java.lang.StringBuilder(7).append(scala.meta.internal.inputs.package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append("-ondisk").toString(), new java.lang.StringBuilder(11).append(scala.meta.internal.inputs.package$.MODULE$.XtensionInputSyntaxStructure(input).syntax()).append("-semanticdb").toString(), StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(input.text())).toList(), StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(doc.text())).toList(), 3);
                }
                String diff = string5;
                throw new MainOps.StaleSemanticDB(file, diff);
            }
        }
    }

    public ExitStatus unsafeHandleFile(ValidatedArgs args, AbsolutePath file) {
        ExitStatus exitStatus;
        Input input = args.input(file);
        PatchInternals.ResultWithContext result = this.getPatchesAndDiags(args, input, file);
        List messages = result.diagnostics();
        String fixed = result.fixed();
        if (!args.args().autoSuppressLinterErrors()) {
            messages.foreach((Function1 & Serializable)diag -> {
                MainOps$.$anonfun$unsafeHandleFile$1(args, diag);
                return BoxedUnit.UNIT;
            });
        }
        if (args.args().check()) {
            String string = fixed;
            String string2 = input.text();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                exitStatus = ExitStatus$.MODULE$.Ok();
            } else {
                String diff = DiffUtils$.MODULE$.unifiedDiff(file.toString(), "<expected fix>", StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(input.text())).toList(), StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(fixed)).toList(), 3);
                args.args().out().println(diff);
                exitStatus = ExitStatus$.MODULE$.TestError();
            }
        } else if (args.args().stdout()) {
            args.args().out().println(fixed);
            exitStatus = ExitStatus$.MODULE$.Ok();
        } else {
            Object object;
            String string = fixed;
            String string3 = input.text();
            if (string == null ? string3 != null : !string.equals(string3)) {
                Path toFix = ((AbsolutePath)args.pathReplace().apply((Object)file)).toNIO();
                Files.createDirectories(toFix.getParent(), new FileAttribute[0]);
                object = Files.write(toFix, fixed.getBytes(args.args().charset()), new OpenOption[0]);
            } else {
                object = BoxedUnit.UNIT;
            }
            exitStatus = ExitStatus$.MODULE$.Ok();
        }
        return exitStatus;
    }

    private PatchInternals.ResultWithContext getPatchesAndDiags(ValidatedArgs args, Input input, AbsolutePath file) {
        PatchInternals.ResultWithContext resultWithContext;
        SyntacticDocument doc = SyntacticDocument$.MODULE$.apply(input, args.diffDisable(), args.config());
        if (args.rules().isSemantic()) {
            RelativePath relpath = file.toRelative(args.sourceroot());
            SemanticDocument sdoc = SemanticDocument$.MODULE$.fromPath(doc, relpath, args.classLoader(), args.symtab());
            PatchInternals.ResultWithContext result = args.rules().semanticPatch(sdoc, args.args().autoSuppressLinterErrors());
            this.assertFreshSemanticDB(input, file, result.fixed(), sdoc.internal().textDocument());
            resultWithContext = result;
        } else {
            resultWithContext = args.rules().syntacticPatch(doc, args.args().autoSuppressLinterErrors());
        }
        return resultWithContext;
    }

    public Option<String> previewPatches(scala.collection.immutable.Seq<Patch> patches, RuleCtx ctx, Option<SemanticdbIndex> index) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> PatchInternals$.MODULE$.tokenPatchApply(ctx, index, (Iterable)patches)).toOption();
    }

    public Try<ExitStatus> applyPatches(ValidatedArgs args, scala.collection.immutable.Seq<Patch> patches, RuleCtx ctx, Option<SemanticdbIndex> index, AbsolutePath file) {
        Input input = args.input(file);
        return Try$.MODULE$.apply((Function0 & Serializable)() -> PatchInternals$.MODULE$.tokenPatchApply(ctx, index, (Iterable)patches)).withFilter((Function1 & Serializable)fixed -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$applyPatches$2(input, fixed))).map((Function1 & Serializable)fixed -> {
            Path toFix = ((AbsolutePath)args.pathReplace().apply((Object)file)).toNIO();
            return new Tuple2(fixed, (Object)toFix);
        }).flatMap((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fixed = (String)tuple2._1();
            Path toFix = (Path)tuple2._2();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Files.createDirectories(toFix.getParent(), new FileAttribute[0])).flatMap((Function1 & Serializable)x$5 -> {
                Path path = x$5;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Files.write(toFix, fixed.getBytes(args.args().charset()), new OpenOption[0])).map((Function1 & Serializable)x$4 -> {
                    Path path = x$4;
                    ExitStatus exitStatus = ExitStatus$.MODULE$.Ok();
                    return exitStatus;
                });
                return try_;
            });
            return try_;
        });
    }

    public Try<ExitStatus> applyDiff(ValidatedArgs args, AbsolutePath file, String fixed) {
        Success success;
        Input input = args.input(file);
        String string = fixed;
        String string2 = input.text();
        if (string == null ? string2 != null : !string.equals(string2)) {
            Path toFix = ((AbsolutePath)args.pathReplace().apply((Object)file)).toNIO();
            success = Try$.MODULE$.apply((Function0 & Serializable)() -> Files.createDirectories(toFix.getParent(), new FileAttribute[0])).flatMap((Function1 & Serializable)x$8 -> {
                Path path = x$8;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Files.write(toFix, fixed.getBytes(args.args().charset()), new OpenOption[0])).map((Function1 & Serializable)x$7 -> {
                    Path path = x$7;
                    ExitStatus exitStatus = ExitStatus$.MODULE$.Ok();
                    return exitStatus;
                });
                return try_;
            });
        } else {
            success = new Success((Object)ExitStatus$.MODULE$.Ok());
        }
        return success;
    }

    public ExitStatus handleFile(ValidatedArgs args, AbsolutePath file) {
        ExitStatus exitStatus;
        try {
            exitStatus = this.unsafeHandleFile(args, file);
        }
        catch (Throwable throwable) {
            Option option;
            ExitStatus exitStatus2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ParseException) {
                ParseException parseException = (ParseException)throwable2;
                args.config().reporter().error(parseException.shortMessage(), parseException.pos());
                exitStatus2 = ExitStatus$.MODULE$.ParseError();
            } else if (throwable2 instanceof SemanticDocument.Error$.MissingSemanticdb) {
                SemanticDocument.Error$.MissingSemanticdb missingSemanticdb = (SemanticDocument.Error$.MissingSemanticdb)throwable2;
                args.config().reporter().error(missingSemanticdb.getMessage(), args.config().reporter().error$default$2());
                exitStatus2 = ExitStatus$.MODULE$.MissingSemanticdbError();
            } else if (throwable2 instanceof MainOps.StaleSemanticDB) {
                ExitStatus exitStatus3;
                MainOps.StaleSemanticDB staleSemanticDB = (MainOps.StaleSemanticDB)throwable2;
                if (args.args().noStaleSemanticdb()) {
                    exitStatus3 = ExitStatus$.MODULE$.Ok();
                } else {
                    args.config().reporter().error(staleSemanticDB.getMessage(), args.config().reporter().error$default$2());
                    exitStatus3 = ExitStatus$.MODULE$.StaleSemanticdbError();
                }
                exitStatus2 = exitStatus3;
            } else if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                FileException ex = new FileException(file, e);
                this.trimStackTrace(ex, "handleFile");
                Throwable throwable3 = e;
                if (throwable3 instanceof AssertionError && e.getMessage() != null && e.getMessage().startsWith("assertion failed:") && e.getMessage().contains("reconstructed args: ")) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    ex.printStackTrace(args.args().out());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                exitStatus2 = ExitStatus$.MODULE$.UnexpectedError();
            } else {
                throw throwable;
            }
            exitStatus = exitStatus2;
        }
        return exitStatus;
    }

    public ExitStatus run(ValidatedArgs args) {
        scala.collection.immutable.Seq<AbsolutePath> files = this.getFilesFrom(args);
        IntRef i = IntRef.create((int)0);
        int N = files.length();
        int width = Integer.toString(N).length();
        ObjectRef exit = ObjectRef.create((Object)ExitStatus$.MODULE$.Ok());
        args.rules().rules().foreach((Function1 & Serializable)x$9 -> {
            x$9.beforeStart();
            return BoxedUnit.UNIT;
        });
        files.foreach((Function1 & Serializable)file -> {
            MainOps$.$anonfun$run$3(args, width, i, N, exit, file);
            return BoxedUnit.UNIT;
        });
        args.rules().rules().foreach((Function1 & Serializable)x$10 -> {
            x$10.afterComplete();
            return BoxedUnit.UNIT;
        });
        return this.adjustExitCode(args, (ExitStatus)exit.elem, (Seq<AbsolutePath>)files);
    }

    public String version() {
        return new java.lang.StringBuilder(9).append("Scalafix ").append(Versions$.MODULE$.version()).toString();
    }

    public String usage() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Usage: scalafix [options] [<path> ...]\n      |"));
    }

    public Doc description() {
        return Doc$.MODULE$.paragraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Scalafix is a refactoring and linting tool.\n        |Scalafix supports both syntactic and semantic linter and rewrite rules.\n        |Syntactic rules can run on source code without compilation.\n        |Semantic rules can run on source code that has been compiled with the\n        |SemanticDB compiler plugin.\n        |")));
    }

    public Doc markdownish(String text) {
        ListBuffer buf = ListBuffer$.MODULE$.empty();
        ListBuffer paragraphs = ListBuffer$.MODULE$.empty();
        BooleanRef insideCodeFence = BooleanRef.create((boolean)false);
        StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(text)).foreach((Function1 & Serializable)line -> {
            block0: {
                if (!line.startsWith("```")) break block0;
                MainOps$.flush$1(insideCodeFence, paragraphs, buf);
                insideCodeFence$1.elem = !insideCodeFence$1.elem;
            }
            return (ListBuffer)buf.$plus$eq(line);
        });
        MainOps$.flush$1(insideCodeFence, paragraphs, buf);
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)paragraphs);
    }

    public String options(int width) {
        StringBuilder sb = new StringBuilder();
        Settings settings = Settings$.MODULE$.apply(Args$.MODULE$.argsSurface());
        Conf.Obj obj = ConfEncoder$.MODULE$.apply(Args$.MODULE$.argsEncoder()).writeObj((Object)Args$.MODULE$.default());
        ((List)settings.settings().zip((IterableOnce)obj.values())).foreach((Function1 & Serializable)x0$1 -> {
            MainOps$.$anonfun$options$5(sb, width, x0$1);
            return BoxedUnit.UNIT;
        });
        return sb.toString();
    }

    public void helpMessage(PrintStream out, int width) {
        out.println(this.version());
        out.println(this.usage());
        out.println(this.description().render(width));
        out.println(this.options(width));
    }

    public String helpMessage(int width) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.helpMessage(new PrintStream(baos), width);
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    public static final /* synthetic */ boolean $anonfun$trimStackTrace$1(String untilMethod$1, StackTraceElement x$3) {
        String string = x$3.getMethodName();
        String string2 = untilMethod$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$unsafeHandleFile$1(ValidatedArgs args$3, RuleDiagnostic diag) {
        args$3.config().reporter().lint(diag);
    }

    public static final /* synthetic */ boolean $anonfun$applyPatches$2(Input input$2, String fixed) {
        String string = fixed;
        String string2 = input$2.text();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$run$3(ValidatedArgs args$6, int width$1, IntRef i$1, int N$1, ObjectRef exit$1, AbsolutePath file) {
        if (args$6.args().verbose()) {
            String message = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(21).append("Processing (%").append(width$1).append("s/%s) %s").toString()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$1.elem), BoxesRunTime.boxToInteger((int)N$1), file}));
            args$6.config().reporter().info(message, args$6.config().reporter().info$default$2());
            ++i$1.elem;
        }
        ExitStatus next = MODULE$.handleFile(args$6, file);
        exit$1.elem = ExitStatus$.MODULE$.merge((ExitStatus)exit$1.elem, next);
    }

    private static final void flush$1(BooleanRef insideCodeFence$1, ListBuffer paragraphs$1, ListBuffer buf$2) {
        Growable growable = insideCodeFence$1.elem ? paragraphs$1.$plus$eq((Object)Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)buf$2.map((Function1 & Serializable)str -> Doc$.MODULE$.text(str)))) : paragraphs$1.$plus$eq((Object)Doc$.MODULE$.paragraph(buf$2.mkString("\n")));
        buf$2.clear();
    }

    public static final /* synthetic */ boolean $anonfun$options$1(StaticAnnotation x$11) {
        return x$11 instanceof Hidden;
    }

    private static final void printOption$1(Setting setting, Conf value, StringBuilder sb$1, int width$2) {
        if (setting.annotations().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$options$1(x$11)))) {
            return;
        }
        setting.annotations().foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            StaticAnnotation staticAnnotation = x0$1;
            if (staticAnnotation instanceof Section) {
                Section section = (Section)staticAnnotation;
                boxedUnit = sb$1.append("\n").append(section.name()).append(":\n");
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        String name2 = Case$.MODULE$.camelToKebab(setting.name());
        sb$1.append("\n").append("  --").append(name2);
        setting.extraNames().foreach((Function1 & Serializable)name -> name.length() == 1 ? sb$1.append(" | -").append(Case$.MODULE$.camelToKebab(name)) : BoxedUnit.UNIT);
        Object object = !setting.isBoolean() ? sb$1.append(" ").append(setting.tpe()).append(" (default: ").append(value.toString()).append(")") : BoxedUnit.UNIT;
        sb$1.append("\n");
        setting.description().foreach((Function1 & Serializable)description -> sb$1.append("    ").append(MODULE$.markdownish((String)description).nested(4).render(width$2)).append('\n'));
    }

    public static final /* synthetic */ boolean $anonfun$options$6(StaticAnnotation x$12) {
        return x$12 instanceof Inline;
    }

    public static final /* synthetic */ boolean $anonfun$options$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$options$9(StringBuilder sb$1, int width$2, Tuple2 x$13) {
        Tuple2 tuple2;
        Setting field;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$13;
                if (tuple22 == null) break block2;
                field = (Setting)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        Conf fieldDefault = (Conf)tuple2._2();
        MainOps$.printOption$1(field, fieldDefault, sb$1, width$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$options$7(Conf value$1, StringBuilder sb$1, int width$2, Settings underlying) {
        ((IterableOps)underlying.settings().zip((IterableOnce)((Conf.Obj)value$1).values())).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$options$8(check$ifrefutable$1))).foreach((Function1 & Serializable)x$13 -> {
            MainOps$.$anonfun$options$9(sb$1, width$2, x$13);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$options$5(StringBuilder sb$1, int width$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Setting setting = (Setting)tuple2._1();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Conf value = (Conf)tuple22._2();
        if (setting.annotations().exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MainOps$.$anonfun$options$6(x$12)))) {
            setting.underlying().toList().foreach((Function1 & Serializable)underlying -> {
                MainOps$.$anonfun$options$7(value, sb$1, width$2, underlying);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            MainOps$.printOption$1(setting, value, sb$1, width$2);
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private MainOps$() {
    }
}

