/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.v1;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import metaconfig.Conf;
import metaconfig.Conf$;
import metaconfig.ConfEncoder$;
import metaconfig.ConfError;
import metaconfig.Configured;
import metaconfig.annotation.Hidden;
import metaconfig.annotation.Inline;
import metaconfig.generic.Setting;
import metaconfig.generic.Settings;
import metaconfig.generic.Settings$;
import metaconfig.internal.Case$;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.annotation.StaticAnnotation;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.ReusableBuilder;
import scala.collection.mutable.StringBuilder;
import scala.meta.inputs.Input;
import scala.meta.internal.inputs.package;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.parsers.ParseException;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scalafix.Versions$;
import scalafix.cli.ExitStatus;
import scalafix.cli.ExitStatus$;
import scalafix.interfaces.ScalafixEvaluation;
import scalafix.internal.config.PrintStreamReporter;
import scalafix.internal.config.PrintStreamReporter$;
import scalafix.internal.diff.DiffUtils$;
import scalafix.internal.interfaces.ScalafixEvaluationImpl$;
import scalafix.internal.interfaces.ScalafixFileEvaluationImpl;
import scalafix.internal.interfaces.ScalafixFileEvaluationImpl$;
import scalafix.internal.patch.PatchInternals;
import scalafix.internal.patch.PatchInternals$;
import scalafix.internal.v1.ArgExpansion$;
import scalafix.internal.v1.Args;
import scalafix.internal.v1.Args$;
import scalafix.internal.v1.CompletionsOps$;
import scalafix.internal.v1.FileException;
import scalafix.internal.v1.FileException$;
import scalafix.internal.v1.FingerprintOps$;
import scalafix.internal.v1.Ls;
import scalafix.internal.v1.Ls$Find$;
import scalafix.internal.v1.MainOps;
import scalafix.internal.v1.Section;
import scalafix.internal.v1.ValidatedArgs;
import scalafix.lint.RuleDiagnostic;
import scalafix.patch.Patch;
import scalafix.v0.RuleCtx;
import scalafix.v0.SemanticdbIndex;
import scalafix.v1.SemanticDocument;
import scalafix.v1.SemanticDocument$;
import scalafix.v1.SyntacticDocument;
import scalafix.v1.SyntacticDocument$;

public final class MainOps$
implements Serializable {
    public static final MainOps$ MODULE$ = new MainOps$();

    private MainOps$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MainOps$.class);
    }

    public ExitStatus run(String[] args, Args base) {
        List<String> expanded = ArgExpansion$.MODULE$.expand(args, base.cwd());
        PrintStream out = base.out();
        Configured configured = Conf$.MODULE$.parseCliArgs(expanded, Settings$.MODULE$.FieldsToSettings(Args$.MODULE$.argsSurface())).andThen((Function1 & Serializable)c -> c.as(Args$.MODULE$.decoder(base)));
        if (configured instanceof Configured.Ok) {
            Args args2 = (Args)((Configured.Ok)configured).value();
            if (args2.help()) {
                this.helpMessage(out, 80);
                return ExitStatus$.MODULE$.Ok();
            }
            if (args2.version()) {
                out.println(Versions$.MODULE$.version());
                return ExitStatus$.MODULE$.Ok();
            }
            if (args2.bash()) {
                out.println(CompletionsOps$.MODULE$.bashCompletions());
                return ExitStatus$.MODULE$.Ok();
            }
            if (args2.zsh()) {
                out.println(CompletionsOps$.MODULE$.zshCompletions());
                return ExitStatus$.MODULE$.Ok();
            }
            Configured<ValidatedArgs> configured2 = args2.validate();
            if (configured2 instanceof Configured.Ok) {
                ValidatedArgs validated = (ValidatedArgs)((Configured.Ok)configured2).value();
                if (validated.rules().isEmpty()) {
                    out.println("No rules requested to run");
                    return ExitStatus$.MODULE$.NoRulesError();
                }
                return this.run(validated);
            }
            if (configured2 instanceof Configured.NotOk) {
                ConfError err = ((Configured.NotOk)configured2).error();
                PrintStreamReporter printStreamReporter = PrintStreamReporter$.MODULE$.apply(out);
                printStreamReporter.error(err.toString(), printStreamReporter.error$default$2());
                return ExitStatus$.MODULE$.CommandLineError();
            }
            throw new MatchError(configured2);
        }
        if (configured instanceof Configured.NotOk) {
            ConfError err = ((Configured.NotOk)configured).error();
            PrintStreamReporter printStreamReporter = PrintStreamReporter$.MODULE$.apply(out);
            printStreamReporter.error(err.toString(), printStreamReporter.error$default$2());
            return ExitStatus$.MODULE$.CommandLineError();
        }
        throw new MatchError((Object)configured);
    }

    public ScalafixEvaluation runWithResult(ValidatedArgs args) {
        args.rules().rules().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.beforeStart());
        List list = args.rules().rules();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return ScalafixEvaluationImpl$.MODULE$.apply(ExitStatus$.MODULE$.NoRulesError(), (Option<String>)Some$.MODULE$.apply((Object)"No rules requested to run"));
        }
        if (list instanceof scala.collection.immutable.Seq) {
            scala.collection.immutable.Seq<AbsolutePath> files = this.getFilesFrom(args);
            if (files.nonEmpty()) {
                scala.collection.immutable.Seq fileEvaluations = (scala.collection.immutable.Seq)files.map((Function1 & Serializable)file -> {
                    Input input = args.input((AbsolutePath)file);
                    Try result = Try$.MODULE$.apply(() -> MainOps$.$anonfun$2(args, input, file));
                    Try try_ = result;
                    if (try_ instanceof Success) {
                        PatchInternals.ResultWithContext result2 = (PatchInternals.ResultWithContext)((Success)try_).value();
                        return ScalafixFileEvaluationImpl$.MODULE$.from((AbsolutePath)file, (Option<String>)Some$.MODULE$.apply((Object)result2.fixed()), ExitStatus$.MODULE$.Ok(), (scala.collection.immutable.Seq<Patch>)result2.patches(), (scala.collection.immutable.Seq<RuleDiagnostic>)result2.diagnostics(), args, result2.ruleCtx(), (Option<SemanticdbIndex>)result2.semanticdbIndex());
                    }
                    if (try_ instanceof Failure) {
                        Throwable exception = ((Failure)try_).exception();
                        return ScalafixFileEvaluationImpl$.MODULE$.from((AbsolutePath)file, ExitStatus$.MODULE$.from(exception), exception.getMessage(), args);
                    }
                    throw new MatchError((Object)try_);
                });
                args.rules().rules().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.afterComplete());
                return ScalafixEvaluationImpl$.MODULE$.from((scala.collection.immutable.Seq<ScalafixFileEvaluationImpl>)fileEvaluations, ExitStatus$.MODULE$.Ok());
            }
            return ScalafixEvaluationImpl$.MODULE$.apply(ExitStatus$.MODULE$.NoFilesError(), (Option<String>)Some$.MODULE$.apply((Object)"No files to fix"));
        }
        throw new MatchError((Object)list);
    }

    public scala.collection.immutable.Seq<AbsolutePath> getFilesFrom(ValidatedArgs args) {
        Ls ls = args.args().ls();
        if (Ls$Find$.MODULE$.equals(ls)) {
            ReusableBuilder buf = package$.MODULE$.Vector().newBuilder();
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(args, buf){
                private final ValidatedArgs args$3;
                private final ReusableBuilder buf$1;
                {
                    this.args$3 = args$13;
                    this.buf$1 = buf$5;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    AbsolutePath path = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
                    RelativePath relpath = path.toRelative(this.args$3.sourceroot());
                    if (this.args$3.matches(relpath)) {
                        this.buf$1.$plus$eq((Object)path);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            List roots = args.args().files().isEmpty() ? package$.MODULE$.Nil().$colon$colon((Object)args.sourceroot()) : args.args().files();
            roots.foreach((Function1 & Serializable)root -> {
                if (root.isFile()) {
                    if (args.matches(root.toRelative(args.args().cwd()))) {
                        buf.$plus$eq(root);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (root.isDirectory()) {
                    return Files.walkFileTree(root.toNIO(), visitor);
                }
                args.config().reporter().error(new java.lang.StringBuilder(14).append(root).append(" is not a file").toString(), args.config().reporter().error$default$2());
                return BoxedUnit.UNIT;
            });
            return (Vector)buf.result();
        }
        throw new MatchError((Object)ls);
    }

    private final void trimStackTrace(Throwable e, String untilMethod) {
        while (true) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace());
            StackTraceElement[] relevantStackTrace = (StackTraceElement[])ArrayOps$.MODULE$.takeWhile$extension(object, (Function1 & Serializable)_$3 -> {
                String string = _$3.getMethodName();
                String string2 = untilMethod;
                return string == null ? string2 != null : !string.equals(string2);
            });
            e.setStackTrace(relevantStackTrace);
            if (e.getCause() == null) break;
            e = e.getCause();
        }
    }

    public void handleException(Throwable ex, PrintStream out) {
    }

    public ExitStatus adjustExitCode(ValidatedArgs args, ExitStatus code, Seq<AbsolutePath> files) {
        if (args.callback().hasLintErrors()) {
            return ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.LinterError(), code);
        }
        if (args.callback().hasErrors() && code.isOk()) {
            return ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.UnexpectedError(), code);
        }
        if (files.isEmpty()) {
            args.config().reporter().error("No files to fix", args.config().reporter().error$default$2());
            return ExitStatus$.MODULE$.merge(ExitStatus$.MODULE$.NoFilesError(), code);
        }
        return code;
    }

    public void assertFreshSemanticDB(Input input, AbsolutePath file, String fix, TextDocument doc) {
        String inputMD5;
        String string = input.text();
        String string2 = fix;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return;
        }
        if (doc.md5().isEmpty()) {
            throw new IllegalArgumentException("-P:semanticdb:md5:on is required.");
        }
        String string3 = inputMD5 = FingerprintOps$.MODULE$.md5(StandardCharsets.UTF_8.encode(CharBuffer.wrap(input.chars())));
        String string4 = doc.md5();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return;
        }
        String diff = doc.text().isEmpty() ? DiffUtils$.MODULE$.unifiedDiff(new java.lang.StringBuilder(23).append(package.XtensionInput$.MODULE$.syntax$extension(scala.meta.internal.inputs.package$.MODULE$.XtensionInput(input))).append("-ondisk-md5-fingerprint").toString(), new java.lang.StringBuilder(27).append(package.XtensionInput$.MODULE$.syntax$extension(scala.meta.internal.inputs.package$.MODULE$.XtensionInput(input))).append("-semanticdb-md5-fingerprint").toString(), package$.MODULE$.Nil().$colon$colon((Object)inputMD5), package$.MODULE$.Nil().$colon$colon((Object)doc.md5()), 1) : DiffUtils$.MODULE$.unifiedDiff(new java.lang.StringBuilder(7).append(package.XtensionInput$.MODULE$.syntax$extension(scala.meta.internal.inputs.package$.MODULE$.XtensionInput(input))).append("-ondisk").toString(), new java.lang.StringBuilder(11).append(package.XtensionInput$.MODULE$.syntax$extension(scala.meta.internal.inputs.package$.MODULE$.XtensionInput(input))).append("-semanticdb").toString(), StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(input.text())).toList(), StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(doc.text())).toList(), 3);
        throw new MainOps.StaleSemanticDB(file, diff);
    }

    public ExitStatus unsafeHandleFile(ValidatedArgs args, AbsolutePath file) {
        Input input = args.input(file);
        PatchInternals.ResultWithContext result = this.getPatchesAndDiags(args, input, file);
        List messages = result.diagnostics();
        String fixed = result.fixed();
        if (!args.args().autoSuppressLinterErrors()) {
            messages.foreach((Function1)(JProcedure1 & Serializable)diag -> args.config().reporter().lint(diag));
        }
        if (args.args().check()) {
            String string = fixed;
            String string2 = input.text();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return ExitStatus$.MODULE$.Ok();
            }
            String diff = DiffUtils$.MODULE$.unifiedDiff(file.toString(), "<expected fix>", StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(input.text())).toList(), StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(fixed)).toList(), 3);
            args.args().out().println(diff);
            return ExitStatus$.MODULE$.TestError();
        }
        if (args.args().stdout()) {
            args.args().out().println(fixed);
            return ExitStatus$.MODULE$.Ok();
        }
        String string = fixed;
        String string3 = input.text();
        if (string == null ? string3 != null : !string.equals(string3)) {
            Path toFix = ((AbsolutePath)args.pathReplace().apply((Object)file)).toNIO();
            Files.createDirectories(toFix.getParent(), new FileAttribute[0]);
            Files.write(toFix, fixed.getBytes(args.args().charset()), new OpenOption[0]);
        }
        return ExitStatus$.MODULE$.Ok();
    }

    private PatchInternals.ResultWithContext getPatchesAndDiags(ValidatedArgs args, Input input, AbsolutePath file) {
        SyntacticDocument doc = SyntacticDocument$.MODULE$.apply(input, args.diffDisable(), args.config());
        if (args.rules().isSemantic()) {
            RelativePath relpath = file.toRelative(args.sourceroot());
            SemanticDocument sdoc = SemanticDocument$.MODULE$.fromPath(doc, relpath, args.classLoader(), args.symtab());
            PatchInternals.ResultWithContext result = args.rules().semanticPatch(sdoc, args.args().autoSuppressLinterErrors());
            this.assertFreshSemanticDB(input, file, result.fixed(), sdoc.internal().textDocument());
            return result;
        }
        return args.rules().syntacticPatch(doc, args.args().autoSuppressLinterErrors());
    }

    public Option<String> previewPatches(scala.collection.immutable.Seq<Patch> patches, RuleCtx ctx, Option<SemanticdbIndex> index) {
        return Try$.MODULE$.apply(() -> MainOps$.previewPatches$$anonfun$1(ctx, index, patches)).toOption();
    }

    public Try<ExitStatus> applyPatches(ValidatedArgs args, scala.collection.immutable.Seq<Patch> patches, RuleCtx ctx, Option<SemanticdbIndex> index, AbsolutePath file) {
        Input input = args.input(file);
        return Try$.MODULE$.apply(() -> MainOps$.applyPatches$$anonfun$1(ctx, index, patches)).withFilter((Function1 & Serializable)fixed -> {
            String string = fixed;
            String string2 = input.text();
            return string == null ? string2 != null : !string.equals(string2);
        }).map((Function1 & Serializable)fixed -> {
            Path toFix = ((AbsolutePath)args.pathReplace().apply((Object)file)).toNIO();
            return Tuple2$.MODULE$.apply(fixed, (Object)toFix);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String fixed = (String)tuple2._1();
                Path toFix = (Path)tuple2._2();
                return Try$.MODULE$.apply(() -> MainOps$.applyPatches$$anonfun$4$$anonfun$1(toFix)).flatMap((Function1 & Serializable)x$12 -> {
                    Path path = x$12;
                    return Try$.MODULE$.apply(() -> MainOps$.applyPatches$$anonfun$4$$anonfun$2$$anonfun$1(toFix, fixed, args)).map((Function1 & Serializable)x$1 -> {
                        Path path = x$1;
                        return ExitStatus$.MODULE$.Ok();
                    });
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Try<ExitStatus> applyDiff(ValidatedArgs args, AbsolutePath file, String fixed) {
        Input input = args.input(file);
        String string = fixed;
        String string2 = input.text();
        if (string == null ? string2 != null : !string.equals(string2)) {
            Path toFix = ((AbsolutePath)args.pathReplace().apply((Object)file)).toNIO();
            return Try$.MODULE$.apply(() -> MainOps$.applyDiff$$anonfun$1(toFix)).flatMap((Function1 & Serializable)x$12 -> {
                Path path = x$12;
                return Try$.MODULE$.apply(() -> MainOps$.applyDiff$$anonfun$2$$anonfun$1(toFix, fixed, args)).map((Function1 & Serializable)x$1 -> {
                    Path path = x$1;
                    return ExitStatus$.MODULE$.Ok();
                });
            });
        }
        return Success$.MODULE$.apply((Object)ExitStatus$.MODULE$.Ok());
    }

    public ExitStatus handleFile(ValidatedArgs args, AbsolutePath file) {
        ExitStatus exitStatus;
        try {
            exitStatus = this.unsafeHandleFile(args, file);
        }
        catch (ParseException e) {
            args.config().reporter().error(e.shortMessage(), e.pos());
            exitStatus = ExitStatus$.MODULE$.ParseError();
        }
        catch (SemanticDocument.Error$.MissingSemanticdb e) {
            args.config().reporter().error(e.getMessage(), args.config().reporter().error$default$2());
            exitStatus = ExitStatus$.MODULE$.MissingSemanticdbError();
        }
        catch (MainOps.StaleSemanticDB e) {
            if (args.args().noStaleSemanticdb()) {
                exitStatus = ExitStatus$.MODULE$.Ok();
            } else {
                args.config().reporter().error(e.getMessage(), args.config().reporter().error$default$2());
                exitStatus = ExitStatus$.MODULE$.StaleSemanticdbError();
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                FileException ex = FileException$.MODULE$.apply(file, e);
                this.trimStackTrace(ex, "handleFile");
                Throwable throwable4 = e;
                if (!(throwable4 instanceof AssertionError && e.getMessage() != null && e.getMessage().startsWith("assertion failed:") && e.getMessage().contains("reconstructed args: "))) {
                    ex.printStackTrace(args.args().out());
                }
                exitStatus = ExitStatus$.MODULE$.UnexpectedError();
            }
            throw throwable;
        }
        return exitStatus;
    }

    public ExitStatus run(ValidatedArgs args) {
        scala.collection.immutable.Seq<AbsolutePath> files = this.getFilesFrom(args);
        IntRef i = IntRef.create((int)0);
        int N = files.length();
        int width = BoxesRunTime.boxToInteger((int)N).toString().length();
        ObjectRef exit = ObjectRef.create((Object)ExitStatus$.MODULE$.Ok());
        args.rules().rules().foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.beforeStart());
        files.foreach((Function1)(JProcedure1 & Serializable)file -> {
            if (args.args().verbose()) {
                String message = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(21).append("Processing (%").append(width).append("s/%s) %s").toString()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$1.elem), BoxesRunTime.boxToInteger((int)N), file}));
                args.config().reporter().info(message, args.config().reporter().info$default$2());
                ++i$1.elem;
            }
            ExitStatus next = MODULE$.handleFile(args, (AbsolutePath)file);
            exit$1.elem = ExitStatus$.MODULE$.merge((ExitStatus)exit$1.elem, next);
        });
        args.rules().rules().foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.afterComplete());
        return this.adjustExitCode(args, (ExitStatus)exit.elem, (Seq<AbsolutePath>)files);
    }

    public String version() {
        return new java.lang.StringBuilder(9).append("Scalafix ").append(Versions$.MODULE$.version()).toString();
    }

    public String usage() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Usage: scalafix [options] [<path> ...]\n      |"));
    }

    public Doc description() {
        return Doc$.MODULE$.paragraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Scalafix is a refactoring and linting tool.\n        |Scalafix supports both syntactic and semantic linter and rewrite rules.\n        |Syntactic rules can run on source code without compilation.\n        |Semantic rules can run on source code that has been compiled with the\n        |SemanticDB compiler plugin.\n        |")));
    }

    public Doc markdownish(String text) {
        ListBuffer buf = ListBuffer$.MODULE$.empty();
        ListBuffer paragraphs = ListBuffer$.MODULE$.empty();
        BooleanRef insideCodeFence = BooleanRef.create((boolean)false);
        StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(text)).foreach((Function1 & Serializable)line -> {
            if (line.startsWith("```")) {
                this.flush$1(insideCodeFence, paragraphs, buf);
                insideCodeFence$2.elem = !insideCodeFence$2.elem;
            }
            return (ListBuffer)buf.$plus$eq(line);
        });
        this.flush$1(insideCodeFence, paragraphs, buf);
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)paragraphs);
    }

    public String options(int width) {
        StringBuilder sb = new StringBuilder();
        Settings settings = Settings$.MODULE$.apply(Args$.MODULE$.argsSurface());
        Conf.Obj obj = ConfEncoder$.MODULE$.apply(Args$.MODULE$.argsEncoder()).writeObj((Object)Args$.MODULE$.default());
        ((List)settings.settings().zip((IterableOnce)obj.values())).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Setting setting = (Setting)tuple2._1();
                if (tuple22 != null) {
                    Conf value = (Conf)tuple22._2();
                    if (setting.annotations().exists((Function1 & Serializable)_$7 -> _$7 instanceof Inline)) {
                        setting.underlying().toList().foreach((Function1)(JProcedure1 & Serializable)underlying -> ((IterableOps)underlying.settings().zip((IterableOnce)((Conf.Obj)value).values())).withFilter((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._2();
                                Setting field = (Setting)tuple2._1();
                                if (tuple22 != null) {
                                    Conf fieldDefault = (Conf)tuple22._2();
                                    return true;
                                }
                            }
                            return false;
                        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._2();
                                Setting field = (Setting)tuple2._1();
                                if (tuple22 != null) {
                                    Conf fieldDefault = (Conf)tuple22._2();
                                    this.printOption$1(sb, width, field, fieldDefault);
                                    return;
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }));
                        return;
                    }
                    this.printOption$1(sb, width, setting, value);
                    return;
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return sb.toString();
    }

    public void helpMessage(PrintStream out, int width) {
        out.println(this.version());
        out.println(this.usage());
        out.println(this.description().render(width));
        out.println(this.options(width));
    }

    public String helpMessage(int width) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.helpMessage(new PrintStream(baos), width);
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    private static final PatchInternals.ResultWithContext $anonfun$2(ValidatedArgs args$2, Input input$1, AbsolutePath file$1) {
        return MODULE$.getPatchesAndDiags(args$2, input$1, file$1);
    }

    private static final String previewPatches$$anonfun$1(RuleCtx ctx$1, Option index$1, scala.collection.immutable.Seq patches$1) {
        return PatchInternals$.MODULE$.tokenPatchApply(ctx$1, index$1, (Iterable)patches$1);
    }

    private static final String applyPatches$$anonfun$1(RuleCtx ctx$2, Option index$2, scala.collection.immutable.Seq patches$2) {
        return PatchInternals$.MODULE$.tokenPatchApply(ctx$2, index$2, (Iterable)patches$2);
    }

    private static final Path applyPatches$$anonfun$4$$anonfun$1(Path toFix$1) {
        return Files.createDirectories(toFix$1.getParent(), new FileAttribute[0]);
    }

    private static final Path applyPatches$$anonfun$4$$anonfun$2$$anonfun$1(Path toFix$3, String fixed$2, ValidatedArgs args$8) {
        return Files.write(toFix$3, fixed$2.getBytes(args$8.args().charset()), new OpenOption[0]);
    }

    private static final Path applyDiff$$anonfun$1(Path toFix$4) {
        return Files.createDirectories(toFix$4.getParent(), new FileAttribute[0]);
    }

    private static final Path applyDiff$$anonfun$2$$anonfun$1(Path toFix$6, String fixed$4, ValidatedArgs args$11) {
        return Files.write(toFix$6, fixed$4.getBytes(args$11.args().charset()), new OpenOption[0]);
    }

    private final void flush$1(BooleanRef insideCodeFence$1, ListBuffer paragraphs$1, ListBuffer buf$3) {
        ListBuffer listBuffer = insideCodeFence$1.elem ? (ListBuffer)paragraphs$1.$plus$eq((Object)Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)buf$3.map((Function1 & Serializable)str -> Doc$.MODULE$.text(str)))) : (ListBuffer)paragraphs$1.$plus$eq((Object)Doc$.MODULE$.paragraph(buf$3.mkString("\n")));
        buf$3.clear();
    }

    private final void printOption$1(StringBuilder sb$1, int width$2, Setting setting, Conf value) {
        if (setting.annotations().exists((Function1 & Serializable)_$6 -> _$6 instanceof Hidden)) {
            return;
        }
        setting.annotations().foreach((Function1 & Serializable)x$1 -> {
            StaticAnnotation staticAnnotation = x$1;
            if (staticAnnotation instanceof Section) {
                Section section = (Section)staticAnnotation;
                return sb$1.append("\n").append(section.name()).append(":\n");
            }
            return BoxedUnit.UNIT;
        });
        String name2 = Case$.MODULE$.camelToKebab(setting.name());
        sb$1.append("\n").append("  --").append(name2);
        setting.extraNames().foreach((Function1)(JProcedure1 & Serializable)name -> {
            if (name.length() == 1) {
                sb$1.append(" | -").append(Case$.MODULE$.camelToKebab(name));
                return;
            }
        });
        if (!setting.isBoolean()) {
            sb$1.append(" ").append(setting.tpe()).append(" (default: ").append(value.toString()).append(")");
        }
        sb$1.append("\n");
        setting.description().foreach((Function1 & Serializable)description -> sb$1.append("    ").append(MODULE$.markdownish((String)description).nested(4).render(width$2)).append('\n'));
    }
}

