/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.v1;

import java.util.concurrent.atomic.AtomicInteger;
import scalafix.interfaces.ScalafixDiagnostic;
import scalafix.interfaces.ScalafixMainCallback;
import scalafix.interfaces.ScalafixSeverity;

public final class DelegatingMainCallback
implements ScalafixMainCallback {
    private final ScalafixMainCallback underlying;
    private final AtomicInteger lintErrorCount;
    private final AtomicInteger normalErrorCount;

    public DelegatingMainCallback(ScalafixMainCallback underlying) {
        this.underlying = underlying;
        this.lintErrorCount = new AtomicInteger();
        this.normalErrorCount = new AtomicInteger();
    }

    public boolean hasErrors() {
        return this.normalErrorCount.get() > 0;
    }

    public boolean hasLintErrors() {
        return this.lintErrorCount.get() > 0;
    }

    public void reportDiagnostic(ScalafixDiagnostic diagnostic) {
        ScalafixSeverity scalafixSeverity = diagnostic.severity();
        ScalafixSeverity scalafixSeverity2 = ScalafixSeverity.ERROR;
        if (!(scalafixSeverity != null ? !scalafixSeverity.equals(scalafixSeverity2) : scalafixSeverity2 != null)) {
            if (diagnostic.lintID().isPresent()) {
                this.lintErrorCount.incrementAndGet();
            } else {
                this.normalErrorCount.incrementAndGet();
            }
        }
        this.underlying.reportDiagnostic(diagnostic);
    }
}

