/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.interfaces;

import scalafix.interfaces.ScalafixRule;
import scalafix.interfaces.ScalafixRuleKind;
import scalafix.internal.interfaces.ScalafixRuleImpl$;
import scalafix.v1.Rule;
import scalafix.v1.SemanticRule;
import scalafix.v1.SyntacticRule;

public final class ScalafixRuleImpl
implements ScalafixRule {
    private final Rule rule;

    public static ScalafixRule apply(Rule rule) {
        return ScalafixRuleImpl$.MODULE$.apply(rule);
    }

    public ScalafixRuleImpl(Rule rule) {
        this.rule = rule;
    }

    public String name() {
        return this.rule.name().value();
    }

    public String description() {
        return this.rule.description();
    }

    public String toString() {
        return new StringBuilder(14).append("ScalafixRule(").append(this.name()).append(")").toString();
    }

    public ScalafixRuleKind kind() {
        Rule rule = this.rule;
        if (rule instanceof SemanticRule) {
            SemanticRule semanticRule = (SemanticRule)rule;
            return ScalafixRuleKind.SEMANTIC;
        }
        if (rule instanceof SyntacticRule) {
            SyntacticRule syntacticRule = (SyntacticRule)rule;
            return ScalafixRuleKind.SYNTACTIC;
        }
        throw new IllegalArgumentException(new StringBuilder(40).append("Rule '").append(this.rule).append("' is neither semantic or syntactic").toString());
    }

    public boolean isLinter() {
        return this.rule.isLinter();
    }

    public boolean isRewrite() {
        return this.rule.isRewrite();
    }

    public boolean isExperimental() {
        return this.rule.isExperimental();
    }
}

