/*
 * Decompiled with CFR 0.152.
 */
package scalafix.interfaces;

import coursierapi.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Properties;
import scalafix.interfaces.ScalafixArguments;
import scalafix.interfaces.ScalafixException;
import scalafix.internal.interfaces.ScalafixCoursier;
import scalafix.internal.interfaces.ScalafixInterfacesClassloader;

public interface Scalafix {
    public ScalafixArguments newArguments();

    public String mainHelp(int var1);

    public String scalaVersion();

    public String scalafixVersion();

    public String scalametaVersion();

    public String[] supportedScalaVersions();

    @Deprecated
    public String scala211();

    public String scala212();

    public String scala213();

    public String scala33();

    public String scala35();

    public String scala36();

    public String scala3LTS();

    public String scala3Next();

    public static Scalafix fetchAndClassloadInstance(String string) throws ScalafixException {
        return Scalafix.fetchAndClassloadInstance(string, Repository.defaults());
    }

    public static Scalafix fetchAndClassloadInstance(String string, List<Repository> list) throws ScalafixException {
        String string2;
        String string3 = string.replaceAll("^(\\d+\\.\\d+).*", "$1");
        if (string3.equals("2.12")) {
            string2 = "scala212";
        } else if (string3.equals("2.13") || string3.equals("2")) {
            string2 = "scala213";
        } else if (string3.equals("3.0") || string3.equals("3.1") || string3.equals("3.2") || string3.equals("3.3")) {
            string2 = "scala33";
        } else if (string3.equals("3.5")) {
            string2 = "scala35";
        } else if (string3.equals("3.6")) {
            string2 = "scala36";
        } else if (string3.startsWith("3")) {
            string2 = "scala3Next";
        } else {
            throw new IllegalArgumentException("Unsupported scala version " + string);
        }
        Properties properties = new Properties();
        String string4 = "scalafix-interfaces.properties";
        InputStream inputStream = Scalafix.class.getClassLoader().getResourceAsStream(string4);
        try {
            properties.load(inputStream);
        }
        catch (IOException | NullPointerException exception) {
            throw new ScalafixException("Failed to load '" + string4 + "' to lookup versions", exception);
        }
        String string5 = properties.getProperty("scalafixVersion");
        String string6 = properties.getProperty(string2);
        if (string5 == null || string6 == null) {
            throw new ScalafixException("Failed to lookup versions from '" + string4 + "'");
        }
        List<URL> list2 = ScalafixCoursier.scalafixCliJars(list, string5, string6);
        ScalafixInterfacesClassloader scalafixInterfacesClassloader = new ScalafixInterfacesClassloader(Scalafix.class.getClassLoader());
        return Scalafix.classloadInstance(new URLClassLoader((URL[])list2.stream().toArray(URL[]::new), (ClassLoader)scalafixInterfacesClassloader));
    }

    public static Scalafix classloadInstance(ClassLoader classLoader) throws ScalafixException {
        try {
            Class<?> clazz = classLoader.loadClass("scalafix.internal.interfaces.ScalafixImpl");
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Scalafix)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new ScalafixException("Failed to reflectively load Scalafix with classloader " + classLoader.toString(), reflectiveOperationException);
        }
    }
}

