/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMergeObject;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ReplaceableMergeStack;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveReplacer;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigDelayedMerge
extends AbstractConfigValue
implements Unmergeable,
ReplaceableMergeStack {
    private final List<AbstractConfigValue> stack;

    ConfigDelayedMerge(ConfigOrigin origin, List<AbstractConfigValue> stack) {
        super(origin);
        this.stack = stack;
        if (stack.isEmpty()) {
            throw new ConfigException.BugOrBroken("creating empty delayed merge value");
        }
        for (AbstractConfigValue v : stack) {
            if (!(v instanceof ConfigDelayedMerge) && !(v instanceof ConfigDelayedMergeObject)) continue;
            throw new ConfigException.BugOrBroken("placed nested DelayedMerge in a ConfigDelayedMerge, should have consolidated stack");
        }
    }

    @Override
    public ConfigValueType valueType() {
        throw new ConfigException.NotResolved("called valueType() on value with unresolved substitutions, need to Config#resolve() first, see API docs");
    }

    @Override
    public Object unwrapped() {
        throw new ConfigException.NotResolved("called unwrapped() on value with unresolved substitutions, need to Config#resolve() first, see API docs");
    }

    @Override
    AbstractConfigValue resolveSubstitutions(ResolveContext context) throws AbstractConfigValue.NotPossibleToResolve {
        return ConfigDelayedMerge.resolveSubstitutions(this, this.stack, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AbstractConfigValue resolveSubstitutions(ReplaceableMergeStack replaceable, List<AbstractConfigValue> stack, ResolveContext context) throws AbstractConfigValue.NotPossibleToResolve {
        int count2 = 0;
        AbstractConfigValue merged = null;
        for (AbstractConfigValue v : stack) {
            AbstractConfigValue resolved;
            if (v instanceof ReplaceableMergeStack) {
                throw new ConfigException.BugOrBroken("A delayed merge should not contain another one: " + replaceable);
            }
            boolean replaced = false;
            if (v instanceof Unmergeable) {
                context.source().replace((AbstractConfigValue)((Object)replaceable), replaceable.makeReplacer(count2 + 1));
                replaced = true;
            }
            try {
                resolved = context.resolve(v);
            }
            finally {
                if (replaced) {
                    context.source().unreplace((AbstractConfigValue)((Object)replaceable));
                }
            }
            if (resolved != null) {
                merged = merged == null ? resolved : merged.withFallback(resolved);
            }
            ++count2;
        }
        return merged;
    }

    @Override
    public ResolveReplacer makeReplacer(final int skipping) {
        return new ResolveReplacer(){

            @Override
            protected AbstractConfigValue makeReplacement(ResolveContext context) throws AbstractConfigValue.NotPossibleToResolve {
                return ConfigDelayedMerge.makeReplacement(context, ConfigDelayedMerge.this.stack, skipping);
            }
        };
    }

    static AbstractConfigValue makeReplacement(ResolveContext context, List<AbstractConfigValue> stack, int skipping) throws AbstractConfigValue.NotPossibleToResolve {
        List<AbstractConfigValue> subStack = stack.subList(skipping, stack.size());
        if (subStack.isEmpty()) {
            throw new AbstractConfigValue.NotPossibleToResolve(context);
        }
        AbstractConfigValue merged = null;
        for (AbstractConfigValue v : subStack) {
            if (merged == null) {
                merged = v;
                continue;
            }
            merged = merged.withFallback(v);
        }
        return merged;
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigDelayedMerge relativized(Path prefix2) {
        ArrayList<AbstractConfigValue> newStack = new ArrayList<AbstractConfigValue>();
        for (AbstractConfigValue o : this.stack) {
            newStack.add(o.relativized(prefix2));
        }
        return new ConfigDelayedMerge(this.origin(), newStack);
    }

    static boolean stackIgnoresFallbacks(List<AbstractConfigValue> stack) {
        AbstractConfigValue last2 = stack.get(stack.size() - 1);
        return last2.ignoresFallbacks();
    }

    @Override
    protected boolean ignoresFallbacks() {
        return ConfigDelayedMerge.stackIgnoresFallbacks(this.stack);
    }

    @Override
    protected AbstractConfigValue newCopy(ConfigOrigin newOrigin) {
        return new ConfigDelayedMerge(newOrigin, this.stack);
    }

    @Override
    protected final ConfigDelayedMerge mergedWithTheUnmergeable(Unmergeable fallback) {
        return (ConfigDelayedMerge)this.mergedWithTheUnmergeable(this.stack, fallback);
    }

    @Override
    protected final ConfigDelayedMerge mergedWithObject(AbstractConfigObject fallback) {
        return (ConfigDelayedMerge)this.mergedWithObject(this.stack, fallback);
    }

    @Override
    protected ConfigDelayedMerge mergedWithNonObject(AbstractConfigValue fallback) {
        return (ConfigDelayedMerge)this.mergedWithNonObject(this.stack, fallback);
    }

    public Collection<AbstractConfigValue> unmergedValues() {
        return this.stack;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConfigDelayedMerge;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConfigDelayedMerge) {
            return this.canEqual(other) && ((Object)this.stack).equals(((ConfigDelayedMerge)other).stack);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.stack).hashCode();
    }

    @Override
    protected void render(StringBuilder sb, int indent, boolean atRoot, String atKey, ConfigRenderOptions options2) {
        ConfigDelayedMerge.render(this.stack, sb, indent, atRoot, atKey, options2);
    }

    static void render(List<AbstractConfigValue> stack, StringBuilder sb, int indent, boolean atRoot, String atKey, ConfigRenderOptions options2) {
        boolean commentMerge = options2.getComments();
        if (commentMerge) {
            sb.append("# unresolved merge of " + stack.size() + " values follows (\n");
            if (atKey == null) {
                ConfigDelayedMerge.indent(sb, indent, options2);
                sb.append("# this unresolved merge will not be parseable because it's at the root of the object\n");
                ConfigDelayedMerge.indent(sb, indent, options2);
                sb.append("# the HOCON format has no way to list multiple root objects in a single file\n");
            }
        }
        ArrayList<AbstractConfigValue> reversed = new ArrayList<AbstractConfigValue>();
        reversed.addAll(stack);
        Collections.reverse(reversed);
        int i = 0;
        for (AbstractConfigValue v : reversed) {
            if (commentMerge) {
                ConfigDelayedMerge.indent(sb, indent, options2);
                if (atKey != null) {
                    sb.append("#     unmerged value " + i + " for key " + ConfigImplUtil.renderJsonString(atKey) + " from ");
                } else {
                    sb.append("#     unmerged value " + i + " from ");
                }
                ++i;
                sb.append(v.origin().description());
                sb.append("\n");
                for (String comment : v.origin().comments()) {
                    ConfigDelayedMerge.indent(sb, indent, options2);
                    sb.append("# ");
                    sb.append(comment);
                    sb.append("\n");
                }
            }
            ConfigDelayedMerge.indent(sb, indent, options2);
            if (atKey != null) {
                sb.append(ConfigImplUtil.renderJsonString(atKey));
                if (options2.getFormatted()) {
                    sb.append(" : ");
                } else {
                    sb.append(":");
                }
            }
            v.render(sb, indent, atRoot, options2);
            sb.append(",");
            if (!options2.getFormatted()) continue;
            sb.append('\n');
        }
        sb.setLength(sb.length() - 1);
        if (options2.getFormatted()) {
            sb.setLength(sb.length() - 1);
            sb.append("\n");
        }
        if (commentMerge) {
            ConfigDelayedMerge.indent(sb, indent, options2);
            sb.append("# ) end of unresolved merge\n");
        }
    }
}

