/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigBoolean;
import com.typesafe.config.impl.ConfigDouble;
import com.typesafe.config.impl.ConfigLong;
import com.typesafe.config.impl.ConfigNull;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.SimpleConfigList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

final class DefaultTransformer {
    DefaultTransformer() {
    }

    static AbstractConfigValue transform(AbstractConfigValue value2, ConfigValueType requested) {
        if (value2.valueType() == ConfigValueType.STRING) {
            String s = (String)value2.unwrapped();
            switch (requested) {
                case NUMBER: {
                    try {
                        Long v = Long.parseLong(s);
                        return new ConfigLong(value2.origin(), v, s);
                    }
                    catch (NumberFormatException e) {
                        try {
                            Double v = Double.parseDouble(s);
                            return new ConfigDouble(value2.origin(), v, s);
                        }
                        catch (NumberFormatException e2) {
                            break;
                        }
                    }
                }
                case NULL: {
                    if (!s.equals("null")) break;
                    return new ConfigNull(value2.origin());
                }
                case BOOLEAN: {
                    if (s.equals("true") || s.equals("yes") || s.equals("on")) {
                        return new ConfigBoolean(value2.origin(), true);
                    }
                    if (!s.equals("false") && !s.equals("no") && !s.equals("off")) break;
                    return new ConfigBoolean(value2.origin(), false);
                }
                case LIST: {
                    break;
                }
                case OBJECT: {
                    break;
                }
            }
        } else if (requested == ConfigValueType.STRING) {
            switch (value2.valueType()) {
                case NUMBER: 
                case BOOLEAN: {
                    return new ConfigString(value2.origin(), value2.transformToString());
                }
                case NULL: {
                    break;
                }
                case OBJECT: {
                    break;
                }
                case LIST: {
                    break;
                }
            }
        } else if (requested == ConfigValueType.LIST && value2.valueType() == ConfigValueType.OBJECT) {
            AbstractConfigObject o = (AbstractConfigObject)value2;
            HashMap<Integer, AbstractConfigValue> values2 = new HashMap<Integer, AbstractConfigValue>();
            for (String key2 : o.keySet()) {
                try {
                    int i = Integer.parseInt(key2, 10);
                    if (i < 0) continue;
                    values2.put(i, o.get(key2));
                }
                catch (NumberFormatException e) {}
            }
            if (!values2.isEmpty()) {
                ArrayList entryList = new ArrayList(values2.entrySet());
                Collections.sort(entryList, new Comparator<Map.Entry<Integer, AbstractConfigValue>>(){

                    @Override
                    public int compare(Map.Entry<Integer, AbstractConfigValue> a, Map.Entry<Integer, AbstractConfigValue> b) {
                        return Integer.valueOf(a.getKey()).compareTo(b.getKey());
                    }
                });
                ArrayList<AbstractConfigValue> list = new ArrayList<AbstractConfigValue>();
                for (Map.Entry entry : entryList) {
                    list.add((AbstractConfigValue)entry.getValue());
                }
                return new SimpleConfigList(value2.origin(), list);
            }
        }
        return value2;
    }
}

