/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.MemoKey;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveMemos;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SubstitutionExpression;
import java.util.ArrayList;
import java.util.List;

final class ResolveContext {
    private final ResolveSource source;
    private final ResolveMemos memos;
    private final ConfigResolveOptions options;
    private final Path restrictToChild;
    private final List<SubstitutionExpression> expressionTrace;

    ResolveContext(ResolveSource source2, ResolveMemos memos, ConfigResolveOptions options2, Path restrictToChild, List<SubstitutionExpression> expressionTrace) {
        this.source = source2;
        this.memos = memos;
        this.options = options2;
        this.restrictToChild = restrictToChild;
        this.expressionTrace = expressionTrace;
    }

    ResolveContext(AbstractConfigObject root2, ConfigResolveOptions options2, Path restrictToChild) {
        this(new ResolveSource(root2), new ResolveMemos(), options2, restrictToChild, new ArrayList<SubstitutionExpression>());
    }

    ResolveSource source() {
        return this.source;
    }

    ConfigResolveOptions options() {
        return this.options;
    }

    boolean isRestrictedToChild() {
        return this.restrictToChild != null;
    }

    Path restrictToChild() {
        return this.restrictToChild;
    }

    ResolveContext restrict(Path restrictTo) {
        if (restrictTo == this.restrictToChild) {
            return this;
        }
        return new ResolveContext(this.source, this.memos, this.options, restrictTo, this.expressionTrace);
    }

    ResolveContext unrestricted() {
        return this.restrict(null);
    }

    void trace(SubstitutionExpression expr2) {
        this.expressionTrace.add(expr2);
    }

    void untrace() {
        this.expressionTrace.remove(this.expressionTrace.size() - 1);
    }

    String traceString() {
        String separator = ", ";
        StringBuilder sb = new StringBuilder();
        for (SubstitutionExpression expr2 : this.expressionTrace) {
            sb.append(expr2.toString());
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - separator.length());
        }
        return sb.toString();
    }

    AbstractConfigValue resolve(AbstractConfigValue original) throws AbstractConfigValue.NotPossibleToResolve {
        MemoKey fullKey = new MemoKey(original, null);
        MemoKey restrictedKey = null;
        AbstractConfigValue cached = this.memos.get(fullKey);
        if (cached == null && this.isRestrictedToChild()) {
            restrictedKey = new MemoKey(original, this.restrictToChild());
            cached = this.memos.get(restrictedKey);
        }
        if (cached != null) {
            return cached;
        }
        AbstractConfigValue resolved = this.source.resolveCheckingReplacement(this, original);
        if (resolved == null || resolved.resolveStatus() == ResolveStatus.RESOLVED) {
            this.memos.put(fullKey, resolved);
        } else if (this.isRestrictedToChild()) {
            if (restrictedKey == null) {
                throw new ConfigException.BugOrBroken("restrictedKey should not be null here");
            }
            this.memos.put(restrictedKey, resolved);
        } else if (this.options().getAllowUnresolved()) {
            this.memos.put(fullKey, resolved);
        } else {
            throw new ConfigException.BugOrBroken("resolveSubstitutions() did not give us a resolved object");
        }
        return resolved;
    }

    static AbstractConfigValue resolve(AbstractConfigValue value2, AbstractConfigObject root2, ConfigResolveOptions options2) {
        ResolveContext context = new ResolveContext(root2, options2, null);
        try {
            return context.resolve(value2);
        }
        catch (AbstractConfigValue.NotPossibleToResolve e) {
            throw new ConfigException.BugOrBroken("NotPossibleToResolve was thrown from an outermost resolve", e);
        }
    }
}

