/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveReplacer;
import com.typesafe.config.impl.SubstitutionExpression;
import java.util.IdentityHashMap;
import java.util.Map;

final class ResolveSource {
    private final AbstractConfigObject root;
    private final Map<AbstractConfigValue, ResolveReplacer> replacements;

    ResolveSource(AbstractConfigObject root2) {
        this.root = root2;
        this.replacements = new IdentityHashMap<AbstractConfigValue, ResolveReplacer>();
    }

    private static AbstractConfigValue findInObject(AbstractConfigObject obj, ResolveContext context, SubstitutionExpression subst) throws AbstractConfigValue.NotPossibleToResolve {
        return obj.peekPath(subst.path(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractConfigValue lookupSubst(ResolveContext context, SubstitutionExpression subst, int prefixLength) throws AbstractConfigValue.NotPossibleToResolve {
        context.trace(subst);
        try {
            AbstractConfigValue result2 = ResolveSource.findInObject(this.root, context, subst);
            if (result2 == null) {
                SubstitutionExpression unprefixed = subst.changePath(subst.path().subPath(prefixLength));
                context.untrace();
                context.trace(unprefixed);
                if (prefixLength > 0) {
                    result2 = ResolveSource.findInObject(this.root, context, unprefixed);
                }
                if (result2 == null && context.options().getUseSystemEnvironment()) {
                    result2 = ResolveSource.findInObject(ConfigImpl.envVariablesAsConfigObject(), context, unprefixed);
                }
            }
            if (result2 != null) {
                result2 = context.resolve(result2);
            }
            AbstractConfigValue abstractConfigValue = result2;
            return abstractConfigValue;
        }
        finally {
            context.untrace();
        }
    }

    void replace(AbstractConfigValue value2, ResolveReplacer replacer) {
        ResolveReplacer old = this.replacements.put(value2, replacer);
        if (old != null) {
            throw new ConfigException.BugOrBroken("should not have replaced the same value twice: " + value2);
        }
    }

    void unreplace(AbstractConfigValue value2) {
        ResolveReplacer replacer = this.replacements.remove(value2);
        if (replacer == null) {
            throw new ConfigException.BugOrBroken("unreplace() without replace(): " + value2);
        }
    }

    private AbstractConfigValue replacement(ResolveContext context, AbstractConfigValue value2) throws AbstractConfigValue.NotPossibleToResolve {
        ResolveReplacer replacer = this.replacements.get(value2);
        if (replacer == null) {
            return value2;
        }
        return replacer.replace(context);
    }

    AbstractConfigValue resolveCheckingReplacement(ResolveContext context, AbstractConfigValue original) throws AbstractConfigValue.NotPossibleToResolve {
        AbstractConfigValue replacement = this.replacement(context, original);
        if (replacement != original) {
            return context.resolve(replacement);
        }
        AbstractConfigValue resolved = original.resolveSubstitutions(context);
        return resolved;
    }
}

