/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

class NioZipEncoding
implements ZipEncoding {
    private final Charset charset;

    public NioZipEncoding(Charset charset) {
        this.charset = charset;
    }

    public boolean canEncode(String name2) {
        CharsetEncoder enc = this.charset.newEncoder();
        enc.onMalformedInput(CodingErrorAction.REPORT);
        enc.onUnmappableCharacter(CodingErrorAction.REPORT);
        return enc.canEncode(name2);
    }

    public ByteBuffer encode(String name2) {
        CharsetEncoder enc = this.charset.newEncoder();
        enc.onMalformedInput(CodingErrorAction.REPORT);
        enc.onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer cb = CharBuffer.wrap(name2);
        ByteBuffer out = ByteBuffer.allocate(name2.length() + (name2.length() + 1) / 2);
        while (cb.remaining() > 0) {
            CoderResult res2 = enc.encode(cb, out, true);
            if (res2.isUnmappable() || res2.isMalformed()) {
                if (res2.length() * 6 > out.remaining()) {
                    out = ZipEncodingHelper.growBuffer(out, out.position() + res2.length() * 6);
                }
                for (int i = 0; i < res2.length(); ++i) {
                    ZipEncodingHelper.appendSurrogate(out, cb.get());
                }
                continue;
            }
            if (res2.isOverflow()) {
                out = ZipEncodingHelper.growBuffer(out, 0);
                continue;
            }
            if (!res2.isUnderflow()) continue;
            enc.flush(out);
            break;
        }
        out.limit(out.position());
        out.rewind();
        return out;
    }

    public String decode(byte[] data2) throws IOException {
        return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(data2)).toString();
    }
}

