/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.ArchiveStream;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.CommonsArchiveStream;
import org.rauschig.jarchivelib.CommonsStreamFactory;
import org.rauschig.jarchivelib.FileModeMapper;
import org.rauschig.jarchivelib.IOUtils;

class CommonsArchiver
implements Archiver {
    private final ArchiveFormat archiveFormat;

    CommonsArchiver(ArchiveFormat archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File create(String archive, File destination, File ... sources2) throws IOException {
        IOUtils.requireDirectory(destination);
        File archiveFile = this.createNewArchiveFile(archive, this.getFilenameExtension(), destination);
        ArchiveOutputStream outputStream = null;
        try {
            outputStream = this.createArchiveOutputStream(archiveFile);
            this.writeToArchive(sources2, outputStream);
            outputStream.flush();
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
        return archiveFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(File archive, File destination) throws IOException {
        this.assertExtractSource(archive);
        IOUtils.requireDirectory(destination);
        ArchiveInputStream input = null;
        try {
            ArchiveEntry entry;
            input = this.createArchiveInputStream(archive);
            while ((entry = input.getNextEntry()) != null) {
                File file2 = new File(destination, entry.getName());
                if (entry.isDirectory()) {
                    file2.mkdirs();
                } else {
                    file2.getParentFile().mkdirs();
                    IOUtils.copy((InputStream)input, file2);
                }
                FileModeMapper.map(entry, file2);
            }
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    @Override
    public ArchiveStream stream(File archive) throws IOException {
        return new CommonsArchiveStream(this.createArchiveInputStream(archive));
    }

    @Override
    public String getFilenameExtension() {
        return this.getArchiveFormat().getDefaultFileExtension();
    }

    protected ArchiveInputStream createArchiveInputStream(File archive) throws IOException {
        try {
            return CommonsStreamFactory.createArchiveInputStream(archive);
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    protected ArchiveOutputStream createArchiveOutputStream(File archiveFile) throws IOException {
        try {
            return CommonsStreamFactory.createArchiveOutputStream(this, archiveFile);
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    protected void assertExtractSource(File archive) throws FileNotFoundException, IllegalArgumentException {
        if (archive.isDirectory()) {
            throw new IllegalArgumentException("Can not extract " + archive + ". Source is a directory.");
        }
        if (!archive.exists()) {
            throw new FileNotFoundException(archive.getPath());
        }
        if (!archive.canRead()) {
            throw new IllegalArgumentException("Can not extract " + archive + ". Can not read from source.");
        }
    }

    protected File createNewArchiveFile(String archive, String extension2, File destination) throws IOException {
        if (!archive.endsWith(extension2)) {
            archive = archive + extension2;
        }
        File file2 = new File(destination, archive);
        file2.createNewFile();
        return file2;
    }

    protected void writeToArchive(File[] sources2, ArchiveOutputStream archive) throws IOException {
        for (File source2 : sources2) {
            if (!source2.exists()) {
                throw new FileNotFoundException(source2.getPath());
            }
            if (!source2.canRead()) {
                throw new FileNotFoundException(source2.getPath() + " (Permission denied)");
            }
            if (source2.isFile()) {
                this.writeToArchive(source2.getParentFile(), new File[]{source2}, archive);
                continue;
            }
            this.writeToArchive(source2, source2.listFiles(), archive);
        }
    }

    protected void writeToArchive(File parent, File[] sources2, ArchiveOutputStream archive) throws IOException {
        for (File source2 : sources2) {
            String relativePath = IOUtils.relativePath(parent, source2);
            this.createArchiveEntry(source2, relativePath, archive);
            if (!source2.isDirectory()) continue;
            this.writeToArchive(parent, source2.listFiles(), archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createArchiveEntry(File file2, String entryName, ArchiveOutputStream archive) throws IOException {
        ArchiveEntry entry = archive.createArchiveEntry(file2, entryName);
        archive.putArchiveEntry(entry);
        if (!entry.isDirectory()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file2);
                IOUtils.copy((InputStream)input, archive);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly(input);
        }
        archive.closeArchiveEntry();
    }
}

