/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.rauschig.jarchivelib.AttributeAccessor;

abstract class FileModeMapper {
    private static final Logger LOG = Logger.getLogger(FileModeMapper.class.getCanonicalName());
    private ArchiveEntry archiveEntry;

    public FileModeMapper(ArchiveEntry archiveEntry) {
        this.archiveEntry = archiveEntry;
    }

    public abstract void map(File var1) throws IOException;

    public ArchiveEntry getArchiveEntry() {
        return this.archiveEntry;
    }

    public static void map(ArchiveEntry entry, File file2) throws IOException {
        FileModeMapper.create(entry).map(file2);
    }

    public static FileModeMapper create(ArchiveEntry entry) {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return new FallbackFileModeMapper(entry);
        }
        return new UnixPermissionMapper(entry);
    }

    public static class RuntimeExecChmodCommand
    implements ChmodCommand {
        @Override
        public void chmod(int mode, File file2) throws Exception {
            String cmd = "chmod " + Integer.toOctalString(mode) + " " + file2.getAbsolutePath();
            Runtime.getRuntime().exec(cmd);
        }
    }

    public static class FileSystemPreferencesReflectionChmodCommand
    implements ChmodCommand {
        private static Method method;

        @Override
        public void chmod(int mode, File file2) throws Exception {
            this.getMethod().invoke(null, file2.getAbsolutePath(), mode);
        }

        private Method getMethod() throws Exception {
            if (method == null) {
                Class<?> clazz = Class.forName("java.util.prefs.FileSystemPreferences");
                method = clazz.getDeclaredMethod("chmod", String.class, Integer.TYPE);
                method.setAccessible(true);
            }
            return method;
        }
    }

    public static interface ChmodCommand {
        public void chmod(int var1, File var2) throws Exception;
    }

    public static class UnixPermissionMapper
    extends FileModeMapper {
        public static final int UNIX_PERMISSION_MASK = 511;

        public UnixPermissionMapper(ArchiveEntry archiveEntry) {
            super(archiveEntry);
        }

        @Override
        public void map(File file2) throws IOException {
            int perm = this.getMode() & 0x1FF;
            if (perm > 0) {
                this.chmod(perm, file2);
            }
        }

        public int getMode() throws IOException {
            return AttributeAccessor.create(this.getArchiveEntry()).getMode();
        }

        public ChmodCommand getChmodCommand() {
            return new FileSystemPreferencesReflectionChmodCommand();
        }

        private void chmod(int mode, File file2) throws IOException {
            try {
                this.getChmodCommand().chmod(mode, file2);
            }
            catch (Exception e) {
                LOG.warning("Could not set file permissions of " + file2 + ". Exception was: " + e.getMessage());
            }
        }
    }

    public static class FallbackFileModeMapper
    extends FileModeMapper {
        public FallbackFileModeMapper(ArchiveEntry archiveEntry) {
            super(archiveEntry);
        }

        @Override
        public void map(File file2) throws IOException {
        }
    }
}

