/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8024;

    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream source2, File destination) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(destination);
            IOUtils.copy(source2, output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly(output);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 8024);
    }

    public static long copy(InputStream input, OutputStream output, int buffersize) throws IOException {
        int n;
        byte[] buffer = new byte[buffersize];
        long count2 = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static String relativePath(File root2, File node) throws IOException {
        String rootPath = root2.getCanonicalPath();
        String nodePath = node.getCanonicalPath();
        return nodePath.substring(rootPath.length() + 1);
    }

    public static void requireDirectory(File destination) throws IOException, IllegalArgumentException {
        if (destination.isFile()) {
            throw new IllegalArgumentException(destination + " exists and is a file, directory or path expected.");
        }
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if (!destination.canWrite()) {
            throw new IllegalArgumentException("Can not write to destination " + destination);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

