/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.CommonsArchiver;

class SevenZArchiver
extends CommonsArchiver {
    public SevenZArchiver() {
        super(ArchiveFormat.SEVEN_Z);
    }

    @Override
    protected ArchiveOutputStream createArchiveOutputStream(File archive) throws IOException {
        return new SevenZOutputStream(new SevenZOutputFile(archive));
    }

    @Override
    protected ArchiveInputStream createArchiveInputStream(File archive) throws IOException {
        return new SevenZInputStream(new SevenZFile(archive));
    }

    static class SevenZOutputStream
    extends ArchiveOutputStream {
        private SevenZOutputFile file;

        public SevenZOutputStream(SevenZOutputFile file2) {
            this.file = file2;
        }

        @Override
        public void putArchiveEntry(ArchiveEntry entry) throws IOException {
            this.file.putArchiveEntry(entry);
        }

        @Override
        public void closeArchiveEntry() throws IOException {
            this.file.closeArchiveEntry();
        }

        @Override
        public void finish() throws IOException {
            this.file.finish();
        }

        @Override
        public ArchiveEntry createArchiveEntry(File inputFile, String entryName) throws IOException {
            return this.file.createArchiveEntry(inputFile, entryName);
        }

        @Override
        public void write(int b) throws IOException {
            this.file.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.file.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.file.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        public SevenZOutputFile getSevenZOutputFile() {
            return this.file;
        }
    }

    static class SevenZInputStream
    extends ArchiveInputStream {
        private SevenZFile file;

        public SevenZInputStream(SevenZFile file2) {
            this.file = file2;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.file.read(b, off, len);
        }

        @Override
        public ArchiveEntry getNextEntry() throws IOException {
            return this.file.getNextEntry();
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }
}

