/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntryLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class MapEntry<K, V>
extends AbstractMessage {
    private final K key;
    private final V value;
    private final Metadata<K, V> metadata;
    private volatile int cachedSerializedSize = -1;

    private MapEntry(Descriptors.Descriptor descriptor, WireFormat.FieldType keyType2, K defaultKey, WireFormat.FieldType valueType2, V defaultValue2) {
        this.key = defaultKey;
        this.value = defaultValue2;
        this.metadata = new Metadata(descriptor, this, keyType2, valueType2);
    }

    private MapEntry(Metadata metadata, K key2, V value2) {
        this.key = key2;
        this.value = value2;
        this.metadata = metadata;
    }

    private MapEntry(Metadata<K, V> metadata, CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        try {
            this.metadata = metadata;
            Map.Entry<K, V> entry = MapEntryLite.parseEntry(input, metadata, extensionRegistry);
            this.key = entry.getKey();
            this.value = entry.getValue();
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
        }
    }

    public static <K, V> MapEntry<K, V> newDefaultInstance(Descriptors.Descriptor descriptor, WireFormat.FieldType keyType2, K defaultKey, WireFormat.FieldType valueType2, V defaultValue2) {
        return new MapEntry<K, V>(descriptor, keyType2, defaultKey, valueType2, defaultValue2);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public int getSerializedSize() {
        int size;
        if (this.cachedSerializedSize != -1) {
            return this.cachedSerializedSize;
        }
        this.cachedSerializedSize = size = MapEntryLite.computeSerializedSize(this.metadata, this.key, this.value);
        return size;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        MapEntryLite.writeTo(output, this.metadata, this.key, this.value);
    }

    @Override
    public boolean isInitialized() {
        return MapEntry.isInitialized(this.metadata, this.value);
    }

    public Parser<MapEntry<K, V>> getParserForType() {
        return this.metadata.parser;
    }

    @Override
    public Builder<K, V> newBuilderForType() {
        return new Builder(this.metadata);
    }

    @Override
    public Builder<K, V> toBuilder() {
        return new Builder(this.metadata, this.key, this.value);
    }

    @Override
    public MapEntry<K, V> getDefaultInstanceForType() {
        return new MapEntry<Object, Object>(this.metadata, this.metadata.defaultKey, this.metadata.defaultValue);
    }

    @Override
    public Descriptors.Descriptor getDescriptorForType() {
        return this.metadata.descriptor;
    }

    @Override
    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        TreeMap<Descriptors.FieldDescriptor, Object> result2 = new TreeMap<Descriptors.FieldDescriptor, Object>();
        for (Descriptors.FieldDescriptor field2 : this.metadata.descriptor.getFields()) {
            if (!this.hasField(field2)) continue;
            result2.put(field2, this.getField(field2));
        }
        return Collections.unmodifiableMap(result2);
    }

    private void checkFieldDescriptor(Descriptors.FieldDescriptor field2) {
        if (field2.getContainingType() != this.metadata.descriptor) {
            throw new RuntimeException("Wrong FieldDescriptor \"" + field2.getFullName() + "\" used in message \"" + this.metadata.descriptor.getFullName());
        }
    }

    @Override
    public boolean hasField(Descriptors.FieldDescriptor field2) {
        this.checkFieldDescriptor(field2);
        return true;
    }

    @Override
    public Object getField(Descriptors.FieldDescriptor field2) {
        Object result2;
        this.checkFieldDescriptor(field2);
        Object object = result2 = field2.getNumber() == 1 ? this.getKey() : this.getValue();
        if (field2.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            result2 = field2.getEnumType().findValueByNumberCreatingIfUnknown((Integer)result2);
        }
        return result2;
    }

    @Override
    public int getRepeatedFieldCount(Descriptors.FieldDescriptor field2) {
        throw new RuntimeException("There is no repeated field in a map entry message.");
    }

    @Override
    public Object getRepeatedField(Descriptors.FieldDescriptor field2, int index) {
        throw new RuntimeException("There is no repeated field in a map entry message.");
    }

    @Override
    public UnknownFieldSet getUnknownFields() {
        return UnknownFieldSet.getDefaultInstance();
    }

    private static <V> boolean isInitialized(Metadata metadata, V value2) {
        if (metadata.valueType.getJavaType() == WireFormat.JavaType.MESSAGE) {
            return ((MessageLite)value2).isInitialized();
        }
        return true;
    }

    public static class Builder<K, V>
    extends AbstractMessage.Builder<Builder<K, V>> {
        private final Metadata<K, V> metadata;
        private K key;
        private V value;

        private Builder(Metadata<K, V> metadata) {
            this(metadata, metadata.defaultKey, metadata.defaultValue);
        }

        private Builder(Metadata<K, V> metadata, K key2, V value2) {
            this.metadata = metadata;
            this.key = key2;
            this.value = value2;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Builder<K, V> setKey(K key2) {
            this.key = key2;
            return this;
        }

        public Builder<K, V> clearKey() {
            this.key = this.metadata.defaultKey;
            return this;
        }

        public Builder<K, V> setValue(V value2) {
            this.value = value2;
            return this;
        }

        public Builder<K, V> clearValue() {
            this.value = this.metadata.defaultValue;
            return this;
        }

        @Override
        public MapEntry<K, V> build() {
            Message result2 = this.buildPartial();
            if (!((MapEntry)result2).isInitialized()) {
                throw Builder.newUninitializedMessageException(result2);
            }
            return result2;
        }

        @Override
        public MapEntry<K, V> buildPartial() {
            return new MapEntry(this.metadata, this.key, this.value);
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return this.metadata.descriptor;
        }

        private void checkFieldDescriptor(Descriptors.FieldDescriptor field2) {
            if (field2.getContainingType() != this.metadata.descriptor) {
                throw new RuntimeException("Wrong FieldDescriptor \"" + field2.getFullName() + "\" used in message \"" + this.metadata.descriptor.getFullName());
            }
        }

        @Override
        public Message.Builder newBuilderForField(Descriptors.FieldDescriptor field2) {
            this.checkFieldDescriptor(field2);
            if (field2.getNumber() != 2 || field2.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new RuntimeException("\"" + field2.getFullName() + "\" is not a message value field.");
            }
            return ((Message)this.value).newBuilderForType();
        }

        @Override
        public Builder<K, V> setField(Descriptors.FieldDescriptor field2, Object value2) {
            this.checkFieldDescriptor(field2);
            if (field2.getNumber() == 1) {
                this.setKey(value2);
            } else {
                if (field2.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                    value2 = ((Descriptors.EnumValueDescriptor)value2).getNumber();
                } else if (field2.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && value2 != null && !this.metadata.defaultValue.getClass().isInstance(value2)) {
                    value2 = ((Message)this.metadata.defaultValue).toBuilder().mergeFrom((Message)value2).build();
                }
                this.setValue(value2);
            }
            return this;
        }

        @Override
        public Builder<K, V> clearField(Descriptors.FieldDescriptor field2) {
            this.checkFieldDescriptor(field2);
            if (field2.getNumber() == 1) {
                this.clearKey();
            } else {
                this.clearValue();
            }
            return this;
        }

        @Override
        public Builder<K, V> setRepeatedField(Descriptors.FieldDescriptor field2, int index, Object value2) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public Builder<K, V> addRepeatedField(Descriptors.FieldDescriptor field2, Object value2) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public Builder<K, V> setUnknownFields(UnknownFieldSet unknownFields) {
            return this;
        }

        @Override
        public MapEntry<K, V> getDefaultInstanceForType() {
            return new MapEntry(this.metadata, this.metadata.defaultKey, this.metadata.defaultValue);
        }

        @Override
        public boolean isInitialized() {
            return MapEntry.isInitialized(this.metadata, this.value);
        }

        @Override
        public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
            TreeMap<Descriptors.FieldDescriptor, Object> result2 = new TreeMap<Descriptors.FieldDescriptor, Object>();
            for (Descriptors.FieldDescriptor field2 : this.metadata.descriptor.getFields()) {
                if (!this.hasField(field2)) continue;
                result2.put(field2, this.getField(field2));
            }
            return Collections.unmodifiableMap(result2);
        }

        @Override
        public boolean hasField(Descriptors.FieldDescriptor field2) {
            this.checkFieldDescriptor(field2);
            return true;
        }

        @Override
        public Object getField(Descriptors.FieldDescriptor field2) {
            Object result2;
            this.checkFieldDescriptor(field2);
            Object object = result2 = field2.getNumber() == 1 ? this.getKey() : this.getValue();
            if (field2.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                result2 = field2.getEnumType().findValueByNumberCreatingIfUnknown((Integer)result2);
            }
            return result2;
        }

        @Override
        public int getRepeatedFieldCount(Descriptors.FieldDescriptor field2) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public Object getRepeatedField(Descriptors.FieldDescriptor field2, int index) {
            throw new RuntimeException("There is no repeated field in a map entry message.");
        }

        @Override
        public UnknownFieldSet getUnknownFields() {
            return UnknownFieldSet.getDefaultInstance();
        }

        @Override
        public Builder<K, V> clone() {
            return new Builder<K, V>(this.metadata, this.key, this.value);
        }
    }

    private static final class Metadata<K, V>
    extends MapEntryLite.Metadata<K, V> {
        public final Descriptors.Descriptor descriptor;
        public final Parser<MapEntry<K, V>> parser;

        public Metadata(Descriptors.Descriptor descriptor, MapEntry<K, V> defaultInstance, WireFormat.FieldType keyType2, WireFormat.FieldType valueType2) {
            super(keyType2, ((MapEntry)defaultInstance).key, valueType2, ((MapEntry)defaultInstance).value);
            this.descriptor = descriptor;
            this.parser = new AbstractParser<MapEntry<K, V>>(){

                @Override
                public MapEntry<K, V> parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    return new MapEntry(Metadata.this, input, extensionRegistry);
                }
            };
        }
    }
}

