/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.Path;
import java.util.Stack;

final class PathBuilder {
    private final Stack<String> keys = new Stack();
    private Path result;

    PathBuilder() {
    }

    private void checkCanAppend() {
        if (this.result != null) {
            throw new ConfigException.BugOrBroken("Adding to PathBuilder after getting result");
        }
    }

    void appendKey(String key2) {
        this.checkCanAppend();
        this.keys.push(key2);
    }

    void appendPath(Path path2) {
        this.checkCanAppend();
        String first = path2.first();
        Path remainder = path2.remainder();
        while (true) {
            this.keys.push(first);
            if (remainder == null) break;
            first = remainder.first();
            remainder = remainder.remainder();
        }
    }

    Path result() {
        if (this.result == null) {
            Path remainder = null;
            while (!this.keys.isEmpty()) {
                String key2 = this.keys.pop();
                remainder = new Path(key2, remainder);
            }
            this.result = remainder;
        }
        return this.result;
    }
}

