/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

class CpioUtil {
    CpioUtil() {
    }

    static long fileType(long mode) {
        return mode & 0xF000L;
    }

    static long byteArray2long(byte[] number2, boolean swapHalfWord) {
        if (number2.length % 2 != 0) {
            throw new UnsupportedOperationException();
        }
        long ret = 0L;
        int pos2 = 0;
        byte[] tmp_number = new byte[number2.length];
        System.arraycopy(number2, 0, tmp_number, 0, number2.length);
        if (!swapHalfWord) {
            byte tmp = 0;
            for (pos2 = 0; pos2 < tmp_number.length; ++pos2) {
                tmp = tmp_number[pos2];
                tmp_number[pos2++] = tmp_number[pos2];
                tmp_number[pos2] = tmp;
            }
        }
        ret = tmp_number[0] & 0xFF;
        for (pos2 = 1; pos2 < tmp_number.length; ++pos2) {
            ret <<= 8;
            ret |= (long)(tmp_number[pos2] & 0xFF);
        }
        return ret;
    }

    static byte[] long2byteArray(long number2, int length, boolean swapHalfWord) {
        byte[] ret = new byte[length];
        int pos2 = 0;
        long tmp_number = 0L;
        if (length % 2 != 0 || length < 2) {
            throw new UnsupportedOperationException();
        }
        tmp_number = number2;
        for (pos2 = length - 1; pos2 >= 0; --pos2) {
            ret[pos2] = (byte)(tmp_number & 0xFFL);
            tmp_number >>= 8;
        }
        if (!swapHalfWord) {
            byte tmp = 0;
            for (pos2 = 0; pos2 < length; ++pos2) {
                tmp = ret[pos2];
                ret[pos2++] = ret[pos2];
                ret[pos2] = tmp;
            }
        }
        return ret;
    }
}

