/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.rauschig.jarchivelib.CommonsStreamFactory;
import org.rauschig.jarchivelib.CompressionType;
import org.rauschig.jarchivelib.Compressor;
import org.rauschig.jarchivelib.FileType;
import org.rauschig.jarchivelib.IOUtils;

class CommonsCompressor
implements Compressor {
    private final CompressionType compressionType;

    CommonsCompressor(CompressionType type2) {
        this.compressionType = type2;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    @Override
    public void compress(File source2, File destination) throws IllegalArgumentException, IOException {
        this.assertSource(source2);
        this.assertDestination(destination);
        if (destination.isDirectory()) {
            destination = new File(destination, this.getCompressedFilename(source2));
        }
        CompressorOutputStream compressed = null;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(source2));
            compressed = CommonsStreamFactory.createCompressorOutputStream(this, destination);
            IOUtils.copy((InputStream)input, compressed);
        }
        catch (CompressorException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(compressed);
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(compressed);
        IOUtils.closeQuietly(input);
    }

    @Override
    public void decompress(File source2, File destination) throws IOException {
        this.assertSource(source2);
        this.assertDestination(destination);
        if (destination.isDirectory()) {
            destination = new File(destination, this.getDecompressedFilename(source2));
        }
        CompressorInputStream compressed = null;
        FileOutputStream output = null;
        try {
            compressed = CommonsStreamFactory.createCompressorInputStream(this.getCompressionType(), source2);
            output = new FileOutputStream(destination);
            IOUtils.copy((InputStream)compressed, output);
        }
        catch (CompressorException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(compressed);
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(compressed);
        IOUtils.closeQuietly(output);
    }

    @Override
    public String getFilenameExtension() {
        return this.getCompressionType().getDefaultFileExtension();
    }

    private String getCompressedFilename(File source2) {
        return source2.getName() + this.getFilenameExtension();
    }

    private String getDecompressedFilename(File source2) {
        FileType fileType = FileType.get(source2);
        if (this.compressionType != fileType.getCompressionType()) {
            throw new IllegalArgumentException(source2 + " is not of type " + (Object)((Object)this.compressionType));
        }
        return source2.getName().substring(0, source2.getName().length() - fileType.getSuffix().length());
    }

    private void assertSource(File source2) throws IllegalArgumentException, FileNotFoundException {
        if (source2 == null) {
            throw new IllegalArgumentException("Source is null");
        }
        if (source2.isDirectory()) {
            throw new IllegalArgumentException("Source " + source2 + " is a directory.");
        }
        if (!source2.exists()) {
            throw new FileNotFoundException(source2.getName());
        }
        if (!source2.canRead()) {
            throw new IllegalArgumentException("Can not read from source " + source2);
        }
    }

    private void assertDestination(File destination) {
        if (destination == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (destination.isDirectory() ? !destination.canWrite() : destination.exists() && !destination.canWrite()) {
            throw new IllegalArgumentException("Can not write to destination " + destination);
        }
    }
}

