/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

public enum CompressionType {
    BZIP2("bzip2", ".bz2"),
    GZIP("gz", ".gz"),
    XZ("xz", ".xz"),
    PACK200("pack200", ".pack");

    private final String name;
    private final String defaultFileExtension;

    private CompressionType(String name2, String defaultFileExtension) {
        this.name = name2;
        this.defaultFileExtension = defaultFileExtension;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    public static boolean isValidCompressionType(String compression) {
        for (CompressionType type2 : CompressionType.values()) {
            if (!compression.equalsIgnoreCase(type2.getName())) continue;
            return true;
        }
        return false;
    }

    public static CompressionType fromString(String compression) {
        for (CompressionType type2 : CompressionType.values()) {
            if (!compression.equalsIgnoreCase(type2.getName())) continue;
            return type2;
        }
        throw new IllegalArgumentException("Unknown compression type " + compression);
    }
}

