/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import org.rauschig.jarchivelib.CommonsCompressor;
import org.rauschig.jarchivelib.CompressionType;
import org.rauschig.jarchivelib.Compressor;
import org.rauschig.jarchivelib.FileType;

public final class CompressorFactory {
    private CompressorFactory() {
    }

    public static Compressor createCompressor(File file2) throws IllegalArgumentException {
        FileType fileType = FileType.get(file2);
        if (fileType == FileType.UNKNOWN) {
            throw new IllegalArgumentException("Unknown file extension " + file2.getName());
        }
        return CompressorFactory.createCompressor(fileType);
    }

    public static Compressor createCompressor(FileType fileType) throws IllegalArgumentException {
        if (fileType == FileType.UNKNOWN) {
            throw new IllegalArgumentException("Unknown file type");
        }
        if (fileType.isCompressed()) {
            return CompressorFactory.createCompressor(fileType.getCompressionType());
        }
        throw new IllegalArgumentException("Unknown compressed file type " + fileType);
    }

    public static Compressor createCompressor(String compression) throws IllegalArgumentException {
        if (!CompressionType.isValidCompressionType(compression)) {
            throw new IllegalArgumentException("Unkonwn compression type " + compression);
        }
        return CompressorFactory.createCompressor(CompressionType.fromString(compression));
    }

    public static Compressor createCompressor(CompressionType compression) {
        return new CommonsCompressor(compression);
    }
}

