/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.CommonsArchiver;
import org.rauschig.jarchivelib.IOUtils;

class ZipFileArchiver
extends CommonsArchiver {
    ZipFileArchiver() {
        super(ArchiveFormat.ZIP);
    }

    @Override
    protected ArchiveInputStream createArchiveInputStream(File archive) throws IOException {
        return new ZipFileArchiveInputStream(new ZipFile(archive));
    }

    static class ZipFileArchiveInputStream
    extends ArchiveInputStream {
        private ZipFile file;
        private Enumeration<ZipArchiveEntry> entries;
        private ZipArchiveEntry currentEntry;
        private InputStream currentEntryStream;

        public ZipFileArchiveInputStream(ZipFile file2) {
            this.file = file2;
        }

        @Override
        public ZipArchiveEntry getNextEntry() throws IOException {
            Enumeration<ZipArchiveEntry> entries = this.getEntries();
            this.closeCurrentEntryStream();
            this.currentEntry = entries.hasMoreElements() ? entries.nextElement() : null;
            this.currentEntryStream = this.currentEntry != null ? this.file.getInputStream(this.currentEntry) : null;
            return this.currentEntry;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read2 = this.getCurrentEntryStream().read(b, off, len);
            if (read2 == -1) {
                IOUtils.closeQuietly(this.getCurrentEntryStream());
            }
            this.count(read2);
            return read2;
        }

        @Override
        public boolean canReadEntryData(ArchiveEntry archiveEntry) {
            return archiveEntry == this.getCurrentEntry();
        }

        public ZipArchiveEntry getCurrentEntry() {
            return this.currentEntry;
        }

        public InputStream getCurrentEntryStream() {
            return this.currentEntryStream;
        }

        private Enumeration<ZipArchiveEntry> getEntries() {
            if (this.entries == null) {
                this.entries = this.file.getEntriesInPhysicalOrder();
            }
            return this.entries;
        }

        private void closeCurrentEntryStream() {
            InputStream stream = this.getCurrentEntryStream();
            IOUtils.closeQuietly(stream);
            this.currentEntryStream = null;
        }

        private void closeFile() {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            this.closeCurrentEntryStream();
            this.closeFile();
            super.close();
        }
    }
}

