/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.tokenizers;

import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.meta.internal.tokenizers.Chars$;
import scala.meta.internal.tokenizers.LegacyTokenData;
import scala.meta.internal.tokenizers.Reporter;
import scala.meta.internal.tokenizers.Reporter$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public abstract class LegacyTokenData$class {
    public static LegacyTokenData copyFrom(LegacyTokenData $this, LegacyTokenData td) {
        $this.input_$eq(td.input());
        $this.token_$eq(td.token());
        $this.offset_$eq(td.offset());
        $this.lastOffset_$eq(td.lastOffset());
        $this.endOffset_$eq(td.endOffset());
        $this.name_$eq(td.name());
        $this.strVal_$eq(td.strVal());
        $this.base_$eq(td.base());
        return $this;
    }

    public static String toString(LegacyTokenData $this) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{token = ", ", position = ", "..", ", lastOffset = ", ", name = ", ", strVal = ", ", base = ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.token()), BoxesRunTime.boxToInteger((int)$this.offset()), BoxesRunTime.boxToInteger((int)$this.endOffset()), BoxesRunTime.boxToInteger((int)$this.lastOffset()), $this.name(), $this.strVal(), BoxesRunTime.boxToInteger((int)$this.base())}));
    }

    public static Reporter reporter(LegacyTokenData $this) {
        return Reporter$.MODULE$.apply($this.input());
    }

    public static char charVal(LegacyTokenData $this) {
        return $this.strVal().length() > 0 ? $this.strVal().charAt(0) : (char)'\u0000';
    }

    /*
     * WARNING - void declaration
     */
    private static BigInt integerVal(LegacyTokenData $this) {
        void var2_2;
        String input = $this.strVal();
        if (input.startsWith("0x") || input.startsWith("0X")) {
            input = input.substring(2);
        }
        if (input.endsWith("l") || input.endsWith("L")) {
            input = input.substring(0, input.length() - 1);
        }
        BigInt value = BigInt$.MODULE$.int2bigInt(0);
        int divider = $this.base() == 10 ? 1 : 2;
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            int d = Chars$.MODULE$.digit2int(input.charAt(i), $this.base());
            if (d < 0) {
                throw $this.reporter().syntaxError("malformed integer number", $this.offset());
            }
            value = value.$times(BigInt$.MODULE$.int2bigInt($this.base())).$plus(BigInt$.MODULE$.int2bigInt(d));
        }
        return var2_2;
    }

    private static BigDecimal floatingVal(LegacyTokenData $this) {
        if (LegacyTokenData$class.isDeprecatedForm$1($this)) {
            throw $this.reporter().syntaxError("floating point number is missing digit after dot", $this.offset());
        }
        List designatorSuffixes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'d', 'D', 'f', 'F'}));
        String parsee = new StringOps(Predef$.MODULE$.augmentString($this.strVal())).nonEmpty() && designatorSuffixes.contains(new StringOps(Predef$.MODULE$.augmentString($this.strVal())).last()) ? (String)new StringOps(Predef$.MODULE$.augmentString($this.strVal())).dropRight(1) : $this.strVal();
        try {
            return package$.MODULE$.BigDecimal().apply(parsee);
        }
        catch (Exception exception) {
            throw $this.reporter().syntaxError("malformed floating point number", $this.offset());
        }
    }

    public static BigInt intVal(LegacyTokenData $this) {
        return LegacyTokenData$class.integerVal($this);
    }

    public static BigInt longVal(LegacyTokenData $this) {
        return LegacyTokenData$class.integerVal($this);
    }

    public static BigDecimal floatVal(LegacyTokenData $this) {
        return LegacyTokenData$class.floatingVal($this);
    }

    public static BigDecimal doubleVal(LegacyTokenData $this) {
        return LegacyTokenData$class.floatingVal($this);
    }

    private static final boolean isDeprecatedForm$1(LegacyTokenData $this) {
        int idx = $this.strVal().indexOf(46);
        return idx == $this.strVal().length() - 1 || idx >= 0 && idx + 1 < $this.strVal().length() && !Character.isDigit($this.strVal().charAt(idx + 1));
    }

    public static void $init$(LegacyTokenData $this) {
        $this.input_$eq(null);
        $this.token_$eq(-3);
        $this.offset_$eq(0);
        $this.lastOffset_$eq(0);
        $this.endOffset_$eq(0);
        $this.name_$eq(null);
        $this.strVal_$eq(null);
        $this.base_$eq(0);
    }
}

