/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.reflect;

import java.io.FileNotFoundException;
import java.net.URL;
import metaconfig.Conf;
import metaconfig.ConfError$;
import metaconfig.Configured;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class GitHubUrlRule$ {
    public static final GitHubUrlRule$ MODULE$;
    private final Regex GitHubOrgRepo;
    private final Regex GitHubOrgRepoVersion;
    private final Regex GitHubOrgRepoVersionSha;
    private final Regex GitHubFallback;
    private final String alphanumerical;

    static {
        new GitHubUrlRule$();
    }

    public Option<Configured<URL>> unapply(Conf.Str arg) {
        None$ none$;
        String string = arg.value();
        Option option = this.GitHubOrgRepoVersionSha().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
            String org = (String)((LinearSeqOptimized)option.get()).apply(0);
            String repo = (String)((LinearSeqOptimized)option.get()).apply(1);
            String version = (String)((LinearSeqOptimized)option.get()).apply(2);
            String sha = (String)((LinearSeqOptimized)option.get()).apply(3);
            none$ = Option$.MODULE$.apply((Object)new Configured.Ok((Object)this.guessGitHubURL(org, repo, version, sha)));
        } else {
            Option option2 = this.GitHubOrgRepoVersion().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
                String org = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String repo = (String)((LinearSeqOptimized)option2.get()).apply(1);
                String version = (String)((LinearSeqOptimized)option2.get()).apply(2);
                none$ = Option$.MODULE$.apply((Object)new Configured.Ok((Object)this.guessGitHubURL(org, repo, version, "master")));
            } else {
                Option option3 = this.GitHubOrgRepo().unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    String org = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    String repo = (String)((LinearSeqOptimized)option3.get()).apply(1);
                    none$ = Option$.MODULE$.apply((Object)new Configured.Ok((Object)this.guessGitHubURL(org, repo, this.normalCamelCase(repo), "master")));
                } else {
                    Option option4 = this.GitHubFallback().unapplySeq((CharSequence)string);
                    if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
                        String invalid = (String)((LinearSeqOptimized)option4.get()).apply(0);
                        none$ = new Some((Object)ConfError$.MODULE$.message(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid url 'github:", "'. Valid formats are:\n                      |- github:org/repo\n                      |- github:org/repo/name\n                      |- github:org/repo/name?sha=branch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalid})))).stripMargin()).notOk());
                    } else {
                        none$ = None$.MODULE$;
                    }
                }
            }
        }
        return none$;
    }

    private URL guessGitHubURL(String org, String repo, String filename, String sha) {
        URL secondGuess;
        URL firstGuess = this.expandGitHubURL(org, repo, filename, sha);
        return this.is404(firstGuess) ? (this.is404(secondGuess = this.expandGitHubURL(org, repo, this.g8CamelCase(filename), sha)) ? firstGuess : secondGuess) : firstGuess;
    }

    private Regex GitHubOrgRepo() {
        return this.GitHubOrgRepo;
    }

    private Regex GitHubOrgRepoVersion() {
        return this.GitHubOrgRepoVersion;
    }

    private Regex GitHubOrgRepoVersionSha() {
        return this.GitHubOrgRepoVersionSha;
    }

    private Regex GitHubFallback() {
        return this.GitHubFallback;
    }

    private String alphanumerical() {
        return this.alphanumerical;
    }

    private String g8CamelCase(String string) {
        return new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.refArrayOps((Object[])string.split(this.alphanumerical())).mkString().toLowerCase())).capitalize();
    }

    private String normalCamelCase(String string) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])string.split(this.alphanumerical())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).capitalize();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString();
    }

    private boolean is404(URL url) {
        boolean bl;
        try {
            url.openStream().close();
            bl = false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        return bl;
    }

    private URL expandGitHubURL(String org, String repo, String filename, String sha) {
        return new URL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://raw.githubusercontent.com/", "/", "/", "/scalafix/rules/src/main/scala/fix/", ".scala"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org, repo, sha, filename})));
    }

    private GitHubUrlRule$() {
        MODULE$ = this;
        this.GitHubOrgRepo = new StringOps(Predef$.MODULE$.augmentString("github:([^\\/]+)\\/([^\\/]+)")).r();
        this.GitHubOrgRepoVersion = new StringOps(Predef$.MODULE$.augmentString("github:([^\\/]+)\\/([^\\/]+)\\/([^\\/]+)")).r();
        this.GitHubOrgRepoVersionSha = new StringOps(Predef$.MODULE$.augmentString("github:([^\\/]+)\\/([^\\/]+)\\/([^\\/]+)\\?sha=(.+)")).r();
        this.GitHubFallback = new StringOps(Predef$.MODULE$.augmentString("github:(.*)")).r();
        this.alphanumerical = "[^a-zA-Z0-9]";
    }
}

