/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.reflect;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Builder;
import scala.meta.internal.symtab.GlobalSymbolTable$;
import scala.meta.internal.symtab.SymbolTable;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.Classpath;
import scala.meta.package$;
import scala.reflect.ClassTag$;
import sun.misc.Unsafe;

public final class ClasspathOps$ {
    public static final ClasspathOps$ MODULE$;
    private final PrintStream devNull;
    private final Path META_INF;
    private final Path SEMANTICDB;

    static {
        new ClasspathOps$();
    }

    public PrintStream devNull() {
        return this.devNull;
    }

    public SymbolTable newSymbolTable(Classpath classpath, boolean parallel, PrintStream out) {
        return GlobalSymbolTable$.MODULE$.apply(classpath, true);
    }

    public boolean newSymbolTable$default$2() {
        return false;
    }

    public PrintStream newSymbolTable$default$3() {
        return System.out;
    }

    public URLClassLoader thisClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return new URLClassLoader(this.getURLs(classLoader), classLoader);
    }

    public URLClassLoader thisClassLoaderWith(URL url) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = url;
        return new URLClassLoader((URL[])Predef$.MODULE$.refArrayOps((Object[])this.getURLs(classLoader)).$plus$colon((Object)uRL, ClassTag$.MODULE$.apply(URL.class)), classLoader);
    }

    public Classpath thisClasspath() {
        return package$.MODULE$.Classpath().apply(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getURLs(this.getClass().getClassLoader())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AbsolutePath apply(URL url) {
                return AbsolutePath$.MODULE$.apply(Paths.get(url.toURI()), AbsolutePath$.MODULE$.workingDirectory());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class)))).toList());
    }

    public String getCurrentClasspath() {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getURLs(this.getClass().getClassLoader())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(URL x$2) {
                return x$2.getFile();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(File.pathSeparator);
    }

    private Path META_INF() {
        return this.META_INF;
    }

    private Path SEMANTICDB() {
        return this.SEMANTICDB;
    }

    public boolean scalafix$internal$reflect$ClasspathOps$$isTargetroot(Path path) {
        return path.toFile().isDirectory() && path.resolve(this.META_INF()).toFile().isDirectory() && path.resolve(this.META_INF()).resolve(this.SEMANTICDB()).toFile().isDirectory();
    }

    public boolean scalafix$internal$reflect$ClasspathOps$$isJar(AbsolutePath path) {
        return path.isFile() && path.toFile().getName().endsWith(".jar");
    }

    public Classpath autoClasspath(List<AbsolutePath> roots) {
        Builder buffer = List$.MODULE$.newBuilder();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(buffer){
            private final Builder buffer$1;

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                FileVisitResult fileVisitResult;
                if (ClasspathOps$.MODULE$.scalafix$internal$reflect$ClasspathOps$$isTargetroot(dir)) {
                    this.buffer$1.$plus$eq((Object)AbsolutePath$.MODULE$.apply(dir, AbsolutePath$.MODULE$.workingDirectory()));
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                } else {
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }
            {
                this.buffer$1 = buffer$1;
            }
        };
        roots.foreach((Function1)new Serializable(visitor){
            public static final long serialVersionUID = 0L;
            private final SimpleFileVisitor visitor$1;

            public final Path apply(AbsolutePath x) {
                return Files.walkFileTree(x.toNIO(), this.visitor$1);
            }
            {
                this.visitor$1 = visitor$1;
            }
        });
        ((List)roots.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AbsolutePath path) {
                return ClasspathOps$.MODULE$.scalafix$internal$reflect$ClasspathOps$$isJar(path);
            }
        })).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final Builder buffer$1;

            public final Builder<AbsolutePath, List<AbsolutePath>> apply(AbsolutePath x$3) {
                return this.buffer$1.$plus$eq((Object)x$3);
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        return package$.MODULE$.Classpath().apply((List)buffer.result());
    }

    public URLClassLoader toClassLoader(Classpath classpath) {
        return this.toClassLoaderWithParent(classpath, this.getClass().getClassLoader());
    }

    public URLClassLoader toOrphanClassLoader(Classpath classpath) {
        return this.toClassLoaderWithParent(classpath, null);
    }

    private URLClassLoader toClassLoaderWithParent(Classpath classpath, ClassLoader parent) {
        URL[] urls = (URL[])((TraversableOnce)classpath.entries().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URL apply(AbsolutePath x$4) {
                return x$4.toNIO().toUri().toURL();
            }
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class));
        return new URLClassLoader(urls, parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL[] getURLs(ClassLoader classLoader) {
        URL[] uRLArray;
        if (classLoader instanceof URLClassLoader) {
            uRLArray = ((URLClassLoader)classLoader).getURLs();
            return uRLArray;
        }
        if (!classLoader.getClass().getName().startsWith("jdk.internal.loader.ClassLoaders$")) {
            uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
            return uRLArray;
        }
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Unsafe unsafe = (Unsafe)field.get(null);
            Field ucpField = classLoader.getClass().getDeclaredField("ucp");
            long ucpFieldOffset = unsafe.objectFieldOffset(ucpField);
            Object ucpObject = unsafe.getObject(classLoader, ucpFieldOffset);
            Field pathField = ucpField.getType().getDeclaredField("path");
            long pathFieldOffset = unsafe.objectFieldOffset(pathField);
            ArrayList paths = (ArrayList)unsafe.getObject(ucpObject, pathFieldOffset);
            uRLArray = (URL[])paths.toArray((Object[])new URL[paths.size()]);
            return uRLArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
        }
        return uRLArray;
    }

    private ClasspathOps$() {
        MODULE$ = this;
        this.devNull = new PrintStream(new OutputStream(){

            public void write(int b) {
            }
        });
        this.META_INF = Paths.get("META-INF", new String[0]);
        this.SEMANTICDB = Paths.get("semanticdb", new String[0]);
    }
}

