/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.reflect;

import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scalafix.internal.v0.LegacySemanticRule;
import scalafix.internal.v0.LegacySyntacticRule;
import scalafix.v0.Rule;
import scalafix.v0.SemanticRule;
import scalafix.v0.SemanticdbIndex;
import scalafix.v0.SemanticdbIndex$;

public final class RuleDecoderOps$ {
    public static RuleDecoderOps$ MODULE$;
    private final Class<SemanticRule> legacySemanticRuleClass;
    private final Class<Rule> legacyRuleClass;
    private final Path scalafixRoot;
    private final TrieMap<Object, Path> fileCache;

    static {
        new RuleDecoderOps$();
    }

    public Class<SemanticRule> legacySemanticRuleClass() {
        return this.legacySemanticRuleClass;
    }

    public Class<Rule> legacyRuleClass() {
        return this.legacyRuleClass;
    }

    public scalafix.v1.Rule toRule(Class<?> cls) {
        this.assertNotOutdatedScalafixRule(cls);
        if (this.legacySemanticRuleClass().isAssignableFrom(cls)) {
            Function1 & java.io.Serializable & Serializable fn = (Function1 & java.io.Serializable & Serializable)index -> {
                Constructor ctor = cls.getDeclaredConstructor(SemanticdbIndex.class);
                ctor.setAccessible(true);
                return (Rule)ctor.newInstance(index);
            };
            return new LegacySemanticRule(((Rule)fn.apply((Object)SemanticdbIndex$.MODULE$.empty())).name(), (Function1)fn);
        }
        if (this.legacyRuleClass().isAssignableFrom(cls)) {
            Constructor<?> ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return new LegacySyntacticRule((Rule)ctor.newInstance(new Object[0]));
        }
        Constructor<?> ctor = cls.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        return (scalafix.v1.Rule)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void assertNotOutdatedScalafixRule(Class<?> cls) {
        String string = cls.getSuperclass().getName();
        if ("scalafix.rule.Rule".equals(string) ? true : "scalafix.rule.SemanticRule".equals(string)) {
            throw new IllegalArgumentException("Outdated Scalafix rule, please upgrade to the latest Scalafix version");
        }
    }

    public Option<scalafix.v1.Rule> tryClassload(ClassLoader classloader, String fqn) {
        Some some;
        try {
            some = new Some((Object)this.toRule(classloader.loadClass(fqn)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoSuchMethodException) {
                try {
                    some = new Some((Object)this.toRule(classloader.loadClass(new StringBuilder(1).append(fqn).append("$").toString())));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    some = None$.MODULE$;
                }
            }
            throw throwable;
        }
        return some;
    }

    public Path scalafixRoot() {
        return this.scalafixRoot;
    }

    public TrieMap<Object, Path> fileCache() {
        return this.fileCache;
    }

    private RuleDecoderOps$() {
        MODULE$ = this;
        this.legacySemanticRuleClass = SemanticRule.class;
        this.legacyRuleClass = Rule.class;
        this.scalafixRoot = Files.createTempDirectory("scalafix", new FileAttribute[0]);
        this.scalafixRoot().toFile().deleteOnExit();
        this.fileCache = TrieMap$.MODULE$.empty();
    }
}

