/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.reflect;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.meta.internal.symtab.GlobalSymbolTable$;
import scala.meta.internal.symtab.SymbolTable;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.Classpath;
import scala.meta.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ClasspathOps$ {
    public static ClasspathOps$ MODULE$;
    private final PrintStream devNull;
    private final Path META_INF;
    private final Path SEMANTICDB;

    static {
        new ClasspathOps$();
    }

    public PrintStream devNull() {
        return this.devNull;
    }

    public SymbolTable newSymbolTable(Classpath classpath, boolean parallel, PrintStream out) {
        return GlobalSymbolTable$.MODULE$.apply(classpath, true);
    }

    public boolean newSymbolTable$default$2() {
        return false;
    }

    public PrintStream newSymbolTable$default$3() {
        return System.out;
    }

    public URLClassLoader thisClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return new URLClassLoader(this.getURLs(classLoader), classLoader);
    }

    public URLClassLoader thisClassLoaderWith(URL url) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = url;
        return new URLClassLoader((URL[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getURLs(classLoader))).$plus$colon((Object)uRL, ClassTag$.MODULE$.apply(URL.class)), classLoader);
    }

    public URLClassLoader thisClassLoaderWith(Seq<URL> urls) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return new URLClassLoader((URL[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])urls.toArray(ClassTag$.MODULE$.apply(URL.class)))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getURLs(classLoader))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))), classLoader);
    }

    public Classpath thisClasspath() {
        return package$.MODULE$.Classpath().apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getURLs(this.getClass().getClassLoader()))).map((Function1 & java.io.Serializable & Serializable)url -> AbsolutePath$.MODULE$.apply(Paths.get(url.toURI()), AbsolutePath$.MODULE$.workingDirectory()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class))))).toList());
    }

    public String getCurrentClasspath() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getURLs(this.getClass().getClassLoader()))).map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.getFile(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(File.pathSeparator);
    }

    private Path META_INF() {
        return this.META_INF;
    }

    private Path SEMANTICDB() {
        return this.SEMANTICDB;
    }

    public boolean scalafix$internal$reflect$ClasspathOps$$isTargetroot(Path path) {
        return path.toFile().isDirectory() && path.resolve(this.META_INF()).toFile().isDirectory() && path.resolve(this.META_INF()).resolve(this.SEMANTICDB()).toFile().isDirectory();
    }

    private boolean isJar(AbsolutePath path) {
        return path.isFile() && path.toFile().getName().endsWith(".jar");
    }

    public Classpath autoClasspath(List<AbsolutePath> roots) {
        Builder buffer = List$.MODULE$.newBuilder();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(buffer){
            private final Builder buffer$1;

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (ClasspathOps$.MODULE$.scalafix$internal$reflect$ClasspathOps$$isTargetroot(dir)) {
                    this.buffer$1.$plus$eq((Object)AbsolutePath$.MODULE$.apply(dir, AbsolutePath$.MODULE$.workingDirectory()));
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.buffer$1 = buffer$1;
            }
        };
        roots.foreach((Function1 & java.io.Serializable & Serializable)x -> Files.walkFileTree(x.toNIO(), visitor));
        ((List)roots.filter((Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ClasspathOps$.MODULE$.isJar(path)))).foreach((Function1 & java.io.Serializable & Serializable)x$3 -> buffer.$plus$eq(x$3));
        return package$.MODULE$.Classpath().apply((List)buffer.result());
    }

    public URLClassLoader toClassLoader(Classpath classpath) {
        return this.toClassLoaderWithParent(classpath, this.getClass().getClassLoader());
    }

    public URLClassLoader toOrphanClassLoader(Classpath classpath) {
        return this.toClassLoaderWithParent(classpath, null);
    }

    private URLClassLoader toClassLoaderWithParent(Classpath classpath, ClassLoader parent) {
        URL[] urls = (URL[])((TraversableOnce)classpath.entries().map((Function1 & java.io.Serializable & Serializable)x$4 -> x$4.toNIO().toUri().toURL(), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class));
        return new URLClassLoader(urls, parent);
    }

    public URL[] getURLs(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        if (classLoader.getClass().getName().startsWith("jdk.internal.loader.ClassLoaders$")) {
            URL[] uRLArray;
            try {
                Class<?> unsafeClass = classLoader.loadClass("sun.misc.Unsafe");
                Field field = unsafeClass.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Object unsafe = field.get(null);
                Field ucpField = (new StringOps(Predef$.MODULE$.augmentString(System.getProperty("java.version").split("(\\.|-)")[0])).toInt() >= 16 ? classLoader.getClass().getSuperclass() : classLoader.getClass()).getDeclaredField("ucp");
                long ucpFieldOffset = ClasspathOps$.objectFieldOffset$1(ucpField, unsafeClass, unsafe);
                Object ucpObject = ClasspathOps$.getObject$1(classLoader, ucpFieldOffset, unsafeClass, unsafe);
                Field pathField = ucpField.getType().getDeclaredField("path");
                long pathFieldOffset = ClasspathOps$.objectFieldOffset$1(pathField, unsafeClass, unsafe);
                URL[] paths = (URL[])((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)((ArrayList)ClasspathOps$.getObject$1(ucpObject, pathFieldOffset, unsafeClass, unsafe))).asScala()).toArray(ClassTag$.MODULE$.apply(URL.class));
                uRLArray = paths;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
            }
            return uRLArray;
        }
        return (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
    }

    private static final long objectFieldOffset$1(Field field, Class unsafeClass$1, Object unsafe$1) {
        return BoxesRunTime.unboxToLong((Object)unsafeClass$1.getMethod("objectFieldOffset", Field.class).invoke(unsafe$1, field));
    }

    private static final Object getObject$1(Object obj, long offset, Class unsafeClass$1, Object unsafe$1) {
        return unsafeClass$1.getMethod("getObject", Object.class, Long.TYPE).invoke(unsafe$1, obj, BoxesRunTime.boxToLong((long)offset));
    }

    private ClasspathOps$() {
        MODULE$ = this;
        this.devNull = new PrintStream(new OutputStream(){

            public void write(int b) {
            }
        });
        this.META_INF = Paths.get("META-INF", new String[0]);
        this.SEMANTICDB = Paths.get("semanticdb", new String[0]);
    }
}

