/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.reflect;

import java.net.URL;
import metaconfig.Conf;
import metaconfig.ConfError$;
import metaconfig.Configured;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class GitHubUrlRule$ {
    public static GitHubUrlRule$ MODULE$;
    private final Regex GitHubShorthand;
    private final Regex GitHubShorthandWithSha;
    private final Regex GitHubFallback;
    private final String alphanumerical;

    static {
        new GitHubUrlRule$();
    }

    private String CamelCase(String string) {
        return new StringOps(Predef$.MODULE$.augmentString(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split(this.alphanumerical))).mkString())).capitalize();
    }

    private String SnakeCase(String string) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split(this.alphanumerical))).map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("_");
    }

    private URL expandGitHubURL(String org, String repo, String version, String sha) {
        String fileName = new StringBuilder(7).append(this.CamelCase(repo)).append("_").append(this.SnakeCase(version)).append(".scala").toString();
        return new URL(new StringBuilder(71).append("https://raw.githubusercontent.com/").append(org).append("/").append(repo).append("/").append(sha).append("/scalafix/rules/src/main/scala/fix/").append(fileName).toString());
    }

    public Option<Configured<URL>> unapply(Conf.Str arg) {
        None$ none$;
        String string = arg.value();
        Option option = this.GitHubShorthandWithSha.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
            String org = (String)((LinearSeqOptimized)option.get()).apply(0);
            String repo = (String)((LinearSeqOptimized)option.get()).apply(1);
            String version = (String)((LinearSeqOptimized)option.get()).apply(2);
            String sha = (String)((LinearSeqOptimized)option.get()).apply(3);
            none$ = Option$.MODULE$.apply((Object)new Configured.Ok((Object)this.expandGitHubURL(org, repo, version, sha)));
        } else {
            Option option2 = this.GitHubShorthand.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
                String org = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String repo = (String)((LinearSeqOptimized)option2.get()).apply(1);
                String version = (String)((LinearSeqOptimized)option2.get()).apply(2);
                none$ = Option$.MODULE$.apply((Object)new Configured.Ok((Object)this.expandGitHubURL(org, repo, version, "master")));
            } else {
                Option option3 = this.GitHubFallback.unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                    String invalid = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    none$ = new Some((Object)ConfError$.MODULE$.message(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("Invalid url 'github:").append(invalid).append("'. Valid formats are:\n                      |- github:org/repo/version\n                      |- github:org/repo/version?sha=branch").toString())).stripMargin()).notOk());
                } else {
                    none$ = None$.MODULE$;
                }
            }
        }
        return none$;
    }

    private GitHubUrlRule$() {
        MODULE$ = this;
        this.GitHubShorthand = new StringOps(Predef$.MODULE$.augmentString("github:([^\\/]+)\\/([^\\/]+)\\/([^\\/]+)")).r();
        this.GitHubShorthandWithSha = new StringOps(Predef$.MODULE$.augmentString("github:([^\\/]+)\\/([^\\/]+)\\/([^\\/]+)\\?sha=(.+)")).r();
        this.GitHubFallback = new StringOps(Predef$.MODULE$.augmentString("github:(.*)")).r();
        this.alphanumerical = "[^a-zA-Z0-9]";
    }
}

