/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.reflect;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.meta.internal.symtab.GlobalSymbolTable$;
import scala.meta.internal.symtab.SymbolTable;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.Classpath;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import sun.misc.Unsafe;

public final class ClasspathOps$ {
    public static final ClasspathOps$ MODULE$ = new ClasspathOps$();
    private static final PrintStream devNull = new PrintStream(new OutputStream(){

        public void write(int b) {
        }
    });
    private static final Path META_INF = Paths.get("META-INF", new String[0]);
    private static final Path SEMANTICDB = Paths.get("semanticdb", new String[0]);

    public PrintStream devNull() {
        return devNull;
    }

    public SymbolTable newSymbolTable(Classpath classpath, boolean parallel, PrintStream out) {
        return GlobalSymbolTable$.MODULE$.apply(classpath, true);
    }

    public boolean newSymbolTable$default$2() {
        return false;
    }

    public PrintStream newSymbolTable$default$3() {
        return System.out;
    }

    public URLClassLoader thisClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return new URLClassLoader(this.getURLs(classLoader), classLoader);
    }

    public URLClassLoader thisClassLoaderWith(URL url) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = url;
        return new URLClassLoader((URL[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])this.getURLs(classLoader)), (Object)uRL, ClassTag$.MODULE$.apply(URL.class)), classLoader);
    }

    public URLClassLoader thisClassLoaderWith(Seq<URL> urls) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return new URLClassLoader((URL[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])urls.toArray(ClassTag$.MODULE$.apply(URL.class))), (Object)this.getURLs(classLoader), ClassTag$.MODULE$.apply(URL.class)), classLoader);
    }

    public Classpath thisClasspath() {
        return scala.meta.package$.MODULE$.Classpath().apply(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.getURLs(this.getClass().getClassLoader())), (Function1 & Serializable)url -> AbsolutePath$.MODULE$.apply(Paths.get(url.toURI()), AbsolutePath$.MODULE$.workingDirectory()), ClassTag$.MODULE$.apply(AbsolutePath.class))).toList());
    }

    public String getCurrentClasspath() {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.getURLs(this.getClass().getClassLoader())), (Function1 & Serializable)x$1 -> x$1.getFile(), ClassTag$.MODULE$.apply(String.class))).mkString(File.pathSeparator);
    }

    private Path META_INF() {
        return META_INF;
    }

    private Path SEMANTICDB() {
        return SEMANTICDB;
    }

    public boolean scalafix$internal$reflect$ClasspathOps$$isTargetroot(Path path) {
        return path.toFile().isDirectory() && path.resolve(this.META_INF()).toFile().isDirectory() && path.resolve(this.META_INF()).resolve(this.SEMANTICDB()).toFile().isDirectory();
    }

    private boolean isJar(AbsolutePath path) {
        return path.isFile() && path.toFile().getName().endsWith(".jar");
    }

    public Classpath autoClasspath(List<AbsolutePath> roots) {
        Builder buffer = package$.MODULE$.List().newBuilder();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(buffer){
            private final Builder buffer$1;

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                FileVisitResult fileVisitResult;
                if (ClasspathOps$.MODULE$.scalafix$internal$reflect$ClasspathOps$$isTargetroot(dir)) {
                    this.buffer$1.$plus$eq((Object)AbsolutePath$.MODULE$.apply(dir, AbsolutePath$.MODULE$.workingDirectory()));
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                } else {
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }
            {
                this.buffer$1 = buffer$1;
            }
        };
        roots.foreach((Function1 & Serializable)x -> Files.walkFileTree(x.toNIO(), visitor));
        roots.filter((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ClasspathOps$.MODULE$.isJar(path))).foreach((Function1 & Serializable)x$2 -> (Builder)buffer.$plus$eq(x$2));
        return scala.meta.package$.MODULE$.Classpath().apply((List)buffer.result());
    }

    public URLClassLoader toClassLoader(Classpath classpath) {
        return this.toClassLoaderWithParent(classpath, this.getClass().getClassLoader());
    }

    public URLClassLoader toOrphanClassLoader(Classpath classpath) {
        return this.toClassLoaderWithParent(classpath, null);
    }

    private URLClassLoader toClassLoaderWithParent(Classpath classpath, ClassLoader parent) {
        URL[] urls = (URL[])classpath.entries().map((Function1 & Serializable)x$3 -> x$3.toNIO().toUri().toURL()).toArray(ClassTag$.MODULE$.apply(URL.class));
        return new URLClassLoader(urls, parent);
    }

    public URL[] getURLs(ClassLoader classLoader) {
        URL[] uRLArray;
        if (classLoader instanceof URLClassLoader) {
            uRLArray = ((URLClassLoader)classLoader).getURLs();
        } else if (classLoader.getClass().getName().startsWith("jdk.internal.loader.ClassLoaders$")) {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Unsafe unsafe = (Unsafe)field.get(null);
                Field ucpField = classLoader.getClass().getDeclaredField("ucp");
                long ucpFieldOffset = unsafe.objectFieldOffset(ucpField);
                Object ucpObject = unsafe.getObject(classLoader, ucpFieldOffset);
                Field pathField = ucpField.getType().getDeclaredField("path");
                long pathFieldOffset = unsafe.objectFieldOffset(pathField);
                ArrayList paths = (ArrayList)unsafe.getObject(ucpObject, pathFieldOffset);
                uRLArray = (URL[])paths.toArray((Object[])new URL[paths.size()]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
            }
        } else {
            uRLArray = (URL[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(URL.class));
        }
        return uRLArray;
    }

    private ClasspathOps$() {
    }
}

