/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.reflect;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URL;
import metaconfig.Conf;
import metaconfig.ConfError$;
import metaconfig.Configured;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class GitHubUrlRule$ {
    public static final GitHubUrlRule$ MODULE$ = new GitHubUrlRule$();
    private static final Regex GitHubOrgRepo = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("github:([^\\/]+)\\/([^\\/]+)"));
    private static final Regex GitHubOrgRepoVersion = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("github:([^\\/]+)\\/([^\\/]+)\\/([^\\/]+)"));
    private static final Regex GitHubOrgRepoVersionSha = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("github:([^\\/]+)\\/([^\\/]+)\\/([^\\/]+)\\?sha=(.+)"));
    private static final Regex GitHubFallback = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("github:(.*)"));
    private static final String alphanumerical = "[^a-zA-Z0-9]";

    public Option<Configured<URL>> unapply(Conf.Str arg) {
        Option option;
        Option option2;
        Option option3;
        None$ none$;
        Option option4;
        String string = arg.value();
        if (string != null && !(option4 = this.GitHubOrgRepoVersionSha().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(4) == 0) {
            String org = (String)((LinearSeqOps)option4.get()).apply(0);
            String repo = (String)((LinearSeqOps)option4.get()).apply(1);
            String version = (String)((LinearSeqOps)option4.get()).apply(2);
            String sha = (String)((LinearSeqOps)option4.get()).apply(3);
            none$ = Option$.MODULE$.apply((Object)new Configured.Ok((Object)this.guessGitHubURL(org, repo, version, sha)));
        } else if (string != null && !(option3 = this.GitHubOrgRepoVersion().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(3) == 0) {
            String org = (String)((LinearSeqOps)option3.get()).apply(0);
            String repo = (String)((LinearSeqOps)option3.get()).apply(1);
            String version = (String)((LinearSeqOps)option3.get()).apply(2);
            none$ = Option$.MODULE$.apply((Object)new Configured.Ok((Object)this.guessGitHubURL(org, repo, version, "master")));
        } else if (string != null && !(option2 = this.GitHubOrgRepo().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
            String org = (String)((LinearSeqOps)option2.get()).apply(0);
            String repo = (String)((LinearSeqOps)option2.get()).apply(1);
            none$ = Option$.MODULE$.apply((Object)new Configured.Ok((Object)this.guessGitHubURL(org, repo, this.normalCamelCase(repo), "master")));
        } else if (string != null && !(option = this.GitHubFallback().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String invalid = (String)((LinearSeqOps)option.get()).apply(0);
            none$ = new Some((Object)ConfError$.MODULE$.message(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(155).append("Invalid url 'github:").append(invalid).append("'. Valid formats are:\n            |- github:org/repo\n            |- github:org/repo/name\n            |- github:org/repo/name?sha=branch").toString()))).notOk());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private URL guessGitHubURL(String org, String repo, String filename, String sha) {
        URL secondGuess;
        URL firstGuess = this.expandGitHubURL(org, repo, filename, sha);
        return this.is404(firstGuess) ? (this.is404(secondGuess = this.expandGitHubURL(org, repo, this.g8CamelCase(filename), sha)) ? firstGuess : secondGuess) : firstGuess;
    }

    private Regex GitHubOrgRepo() {
        return GitHubOrgRepo;
    }

    private Regex GitHubOrgRepoVersion() {
        return GitHubOrgRepoVersion;
    }

    private Regex GitHubOrgRepoVersionSha() {
        return GitHubOrgRepoVersionSha;
    }

    private Regex GitHubFallback() {
        return GitHubFallback;
    }

    private String alphanumerical() {
        return alphanumerical;
    }

    private String g8CamelCase(String string) {
        return StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(Predef$.MODULE$.wrapRefArray((Object[])string.split(this.alphanumerical())).mkString().toLowerCase()));
    }

    private String normalCamelCase(String string) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])string.split(this.alphanumerical())), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(x$1)), ClassTag$.MODULE$.apply(String.class))).mkString();
    }

    private boolean is404(URL url) {
        boolean bl;
        try {
            url.openStream().close();
            bl = false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        return bl;
    }

    private URL expandGitHubURL(String org, String repo, String filename, String sha) {
        return new URL(new StringBuilder(77).append("https://raw.githubusercontent.com/").append(org).append("/").append(repo).append("/").append(sha).append("/scalafix/rules/src/main/scala/fix/").append(filename).append(".scala").toString());
    }

    private GitHubUrlRule$() {
    }
}

