/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.reflect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scalafix.internal.v0.LegacySemanticRule;
import scalafix.internal.v0.LegacySyntacticRule;
import scalafix.v0.Rule;
import scalafix.v0.SemanticRule;
import scalafix.v0.SemanticdbIndex;
import scalafix.v0.SemanticdbIndex$;

public final class RuleDecoderOps$ {
    public static final RuleDecoderOps$ MODULE$ = new RuleDecoderOps$();
    private static final Class<SemanticRule> legacySemanticRuleClass = SemanticRule.class;
    private static final Class<Rule> legacyRuleClass = Rule.class;
    private static final Path scalafixRoot = Files.createTempDirectory("scalafix", new FileAttribute[0]);
    private static final TrieMap<Object, Path> fileCache;

    static {
        MODULE$.scalafixRoot().toFile().deleteOnExit();
        fileCache = TrieMap$.MODULE$.empty();
    }

    public Class<SemanticRule> legacySemanticRuleClass() {
        return legacySemanticRuleClass;
    }

    public Class<Rule> legacyRuleClass() {
        return legacyRuleClass;
    }

    public scalafix.v1.Rule toRule(Class<?> cls) {
        LegacySemanticRule legacySemanticRule;
        this.assertNotOutdatedScalafixRule(cls);
        if (this.legacySemanticRuleClass().isAssignableFrom(cls)) {
            Function1 & Serializable fn = (Function1 & Serializable)index -> {
                Constructor ctor = cls.getDeclaredConstructor(SemanticdbIndex.class);
                ctor.setAccessible(true);
                return (Rule)ctor.newInstance(index);
            };
            legacySemanticRule = new LegacySemanticRule(((Rule)fn.apply((Object)SemanticdbIndex$.MODULE$.empty())).name(), (Function1)fn);
        } else if (this.legacyRuleClass().isAssignableFrom(cls)) {
            Constructor<?> ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            legacySemanticRule = new LegacySyntacticRule((Rule)ctor.newInstance(new Object[0]));
        } else {
            Constructor<?> ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            legacySemanticRule = (scalafix.v1.Rule)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return legacySemanticRule;
    }

    public void assertNotOutdatedScalafixRule(Class<?> cls) {
        block6: {
            String string = cls.getSuperclass().getName();
            switch (string == null ? 0 : string.hashCode()) {
                case -702747473: {
                    if ("scalafix.rule.Rule".equals(string)) {
                        break;
                    }
                    break block6;
                }
                case 464656533: {
                    if ("scalafix.rule.SemanticRule".equals(string)) {
                        break;
                    }
                    break block6;
                }
                default: {
                    break block6;
                }
            }
            throw new IllegalArgumentException("Outdated Scalafix rule, please upgrade to the latest Scalafix version");
        }
    }

    public Option<scalafix.v1.Rule> tryClassload(ClassLoader classloader, String fqn) {
        Some some;
        try {
            some = new Some((Object)this.toRule(classloader.loadClass(fqn)));
        }
        catch (Throwable throwable) {
            Some some2;
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoSuchMethodException;
            if (bl) {
                try {
                    some2 = new Some((Object)this.toRule(classloader.loadClass(new StringBuilder(1).append(fqn).append("$").toString())));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    some2 = None$.MODULE$;
                }
            } else {
                throw throwable;
            }
            Some some3 = some2;
            some = some3;
        }
        return some;
    }

    public Path scalafixRoot() {
        return scalafixRoot;
    }

    public TrieMap<Object, Path> fileCache() {
        return fileCache;
    }

    private RuleDecoderOps$() {
    }
}

